/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.core.proxy;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.core.proxy.JEEMXProxyHandler;
import com.bes.admin.jeemx.util.ExceptionUtil;
import com.bes.admin.jeemx.util.JEEMXDebugHelper;
import com.bes.admin.jeemx.util.StringUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import com.bes.external.jeemx.JEEMXBes;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.remote.JMXConnectionNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class ProxyFactory
implements NotificationListener {
    private final MBeanServerConnection mMBeanServerConnection;
    private final String mMBeanServerID;
    private final ObjectName mDomainRootObjectName;
    private DomainRoot mDomainRoot;
    private final ConcurrentMap<ObjectName, MBeanInfo> mMBeanInfoCache = new ConcurrentHashMap<ObjectName, MBeanInfo>();
    private static final JEEMXDebugHelper mDebug = new JEEMXDebugHelper(ProxyFactory.class.getName());
    private static final String NEED_LISTEN_MBEANS = "com.bes.mq.jeemx.listenMBeans";
    private static final Map<MBeanServerConnection, ProxyFactory> INSTANCES = Collections.synchronizedMap(new HashMap());
    private static final String DOMAIN_ROOT_KEY = "DomainRoot";

    private static void debug(Object ... args) {
        System.out.println(StringUtil.toString(", ", args));
    }

    private static void warning(Object ... args) {
        ProxyFactory.debug(args);
    }

    private ProxyFactory(MBeanServerConnection conn) {
        mDebug.setEchoToStdOut(true);
        assert (conn != null);
        this.mMBeanServerConnection = conn;
        try {
            this.mMBeanServerID = JMXUtil.getMBeanServerID(conn);
            this.mDomainRootObjectName = JEEMXBes.DEFAULT.domainRoot();
            if (this.mDomainRootObjectName == null) {
                throw new IllegalStateException("ProxyFactory: JEEMX has not been started");
            }
            this.mDomainRoot = this.getProxy(this.mDomainRootObjectName, DomainRoot.class);
            int WAIT_MBEAN_READY_RETRY_TIMES = 60;
            int WAIT_MBEAN_READY_RETRY_INTERVAL = 500;
            int count = 0;
            while (null == this.mDomainRoot && count++ < 60) {
                Thread.sleep(500L);
                this.mDomainRoot = this.getProxy(this.mDomainRootObjectName, DomainRoot.class);
            }
            if (Boolean.getBoolean(NEED_LISTEN_MBEANS)) {
                try {
                    MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
                    filter.enableAllObjectNames();
                    filter.disableAllTypes();
                    filter.enableType("JMX.mbean.unregistered");
                    JMXUtil.listenToMBeanServerDelegate(conn, this, filter, null);
                }
                catch (Exception e) {
                    ProxyFactory.warning("ProxyFactory: connection does not support notifications: ", this.mMBeanServerID, conn);
                }
            }
        }
        catch (Exception e) {
            ProxyFactory.warning("ProxyFactory.ProxyFactory:\n", e);
            throw new RuntimeException(e);
        }
    }

    private void connectionBad() {
        HashSet proxies = new HashSet();
        for (JEEMXProxy jeemx : proxies) {
            JEEMXProxyHandler proxy = JEEMXProxyHandler.unwrap(jeemx);
            proxy.connectionBad();
        }
    }

    public boolean checkConnection() {
        boolean connectionGood = true;
        try {
            this.getMBeanServerConnection().isRegistered(JMXUtil.getMBeanServerDelegateObjectName());
            connectionGood = true;
        }
        catch (Exception e) {
            this.connectionBad();
        }
        return connectionGood;
    }

    void notifsLost() {
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (type.equals("JMX.mbean.unregistered")) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
        } else if (notifIn instanceof JMXConnectionNotification) {
            if (type.equals("jmx.remote.connection.closed") || type.equals("jmx.remote.connection.failed")) {
                ProxyFactory.debug("ProxyFactory.handleNotification: connection closed or failed: ", notifIn);
                this.connectionBad();
            } else if (type.equals("jmx.remote.connection.notifs.lost")) {
                ProxyFactory.debug("ProxyFactory.handleNotification: notifications lost: ", notifIn);
                this.notifsLost();
            }
        } else {
            ProxyFactory.debug("ProxyFactory.handleNotification: UNKNOWN notification: ", notifIn);
        }
    }

    public DomainRoot createDomainRoot() throws IOException {
        return this.mDomainRoot;
    }

    public DomainRoot initDomainRoot() throws IOException {
        ObjectName domainRootObjectName = this.getDomainRootObjectName();
        DomainRoot dr = this.getProxy(domainRootObjectName, DomainRoot.class);
        return dr;
    }

    public ObjectName getDomainRootObjectName() {
        return this.mDomainRootObjectName;
    }

    public DomainRoot getDomainRootProxy() {
        return this.getDomainRootProxy(false);
    }

    public DomainRoot getDomainRootProxy(boolean waitReady) {
        if (waitReady) {
            this.mDomainRoot.waitJEEMXReady();
        }
        return this.mDomainRoot;
    }

    public String getMBeanServerID() {
        return this.mMBeanServerID;
    }

    public static ProxyFactory getInstance(MBeanServer server) {
        return ProxyFactory.getInstance(server, true);
    }

    public static ProxyFactory getInstance(MBeanServerConnection conn) {
        return ProxyFactory.getInstance(conn, true);
    }

    public static synchronized ProxyFactory getInstance(MBeanServerConnection conn, boolean useMBeanServerID) {
        ProxyFactory instance = ProxyFactory.findInstance(conn);
        if (instance == null) {
            try {
                if (useMBeanServerID) {
                    String id = JMXUtil.getMBeanServerID(conn);
                    instance = ProxyFactory.findInstanceByID(id);
                }
                if (instance == null) {
                    instance = new ProxyFactory(conn);
                    INSTANCES.put(conn, instance);
                }
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory.getInstance: failure creating ProxyFactory: ", e);
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstance(MBeanServerConnection conn) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (factory.getMBeanServerConnection() != conn) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstanceByID(String mbeanServerID) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (!factory.getMBeanServerID().equals(mbeanServerID)) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        try {
            MBeanInfo info = (MBeanInfo)this.mMBeanInfoCache.get(objectName);
            if (info == null && ProxyFactory.invariantMBeanInfo(info = this.getMBeanServerConnection().getMBeanInfo(objectName))) {
                this.mMBeanInfoCache.put(objectName, info);
            }
            return info;
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static boolean invariantMBeanInfo(MBeanInfo info) {
        Descriptor d = info.getDescriptor();
        if (d == null) {
            return false;
        }
        String value = "" + d.getFieldValue("immutableInfo");
        return Boolean.valueOf(value);
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.mMBeanServerConnection;
    }

    public <T extends JEEMXProxy> T getProxy(ObjectName objectName, Class<T> intf) {
        MBeanInfo info = this.getMBeanInfo(objectName);
        if (info == null) {
            return null;
        }
        T proxy = this.getProxy(objectName, info, intf);
        return proxy;
    }

    public JEEMXProxy getProxy(ObjectName objectName) {
        MBeanInfo info = this.getMBeanInfo(objectName);
        if (info == null) {
            return null;
        }
        Class<? extends JEEMXProxy> intf = ProxyFactory.genericInterface(info);
        JEEMXProxy proxy = this.getProxy(objectName, info, intf);
        return proxy;
    }

    public static Class<? extends JEEMXProxy> genericInterface(MBeanInfo info) {
        String intfName = JEEMXProxyHandler.genericInterfaceName(info);
        Class<JEEMXProxy> intf = JEEMXProxy.class;
        if (intfName == null || JEEMXProxy.class.getName().equals(intfName)) {
            intf = JEEMXProxy.class;
        } else if (JEEMXConfigProxy.class.getName().equals(intfName)) {
            intf = JEEMXConfigProxy.class;
        } else if (intfName.startsWith(JEEMXProxy.class.getPackage().getName())) {
            try {
                intf = Class.forName(intfName, false, ProxyFactory.class.getClassLoader()).asSubclass(JEEMXProxy.class);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.getInterfaceClass(): Unable to load interface " + intfName);
            }
        } else {
            intf = JEEMXProxy.class;
        }
        return intf;
    }

    <T extends JEEMXProxy> T getProxy(ObjectName objectName, MBeanInfo mbeanInfoIn, Class<T> intfIn) {
        JEEMXProxy proxy = null;
        try {
            Class<Object> intf;
            MBeanInfo mbeanInfo = mbeanInfoIn;
            if (mbeanInfo == null) {
                mbeanInfo = this.getMBeanInfo(objectName);
            }
            if (JEEMXProxy.class == (intf = intfIn)) {
                intf = ProxyFactory.genericInterface(mbeanInfoIn);
            }
            JEEMXProxyHandler handler = new JEEMXProxyHandler(this.getMBeanServerConnection(), objectName, mbeanInfo);
            proxy = (JEEMXProxy)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            if (!(rootCause instanceof InstanceNotFoundException)) {
                throw new RuntimeException(e);
            }
            proxy = null;
        }
        return (T)(proxy == null ? null : (JEEMXProxy)intfIn.cast(proxy));
    }

    protected static String toString(Object o) {
        return "" + o;
    }

    public JEEMXProxy[] toProxy(ObjectName[] objectNames) {
        JEEMXProxy[] result = new JEEMXProxy[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            result[i] = this.getProxy(objectNames[i]);
        }
        return result;
    }

    public Set<JEEMXProxy> toProxySet(Set<ObjectName> objectNames) {
        HashSet<JEEMXProxy> s = new HashSet<JEEMXProxy>();
        for (ObjectName objectName : objectNames) {
            try {
                JEEMXProxy proxy = this.getProxy(objectName);
                if (proxy == null) continue;
                s.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return s;
    }

    public Set<JEEMXProxy> toProxySet(ObjectName[] objectNames, Class<? extends JEEMXProxy> intf) {
        HashSet<JEEMXProxy> result = new HashSet<JEEMXProxy>();
        for (ObjectName objectName : objectNames) {
            JEEMXProxy proxy = this.getProxy(objectName, intf);
            if (proxy == null) continue;
            result.add(proxy);
        }
        return result;
    }

    public List<JEEMXProxy> toProxyList(Collection<ObjectName> objectNames) {
        ArrayList<JEEMXProxy> list = new ArrayList<JEEMXProxy>();
        for (ObjectName objectName : objectNames) {
            try {
                JEEMXProxy proxy = this.getProxy(objectName);
                if (proxy == null) continue;
                list.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return list;
    }

    public Map<String, JEEMXProxy> toProxyMap(Map<String, ObjectName> objectNameMap) {
        HashMap<String, JEEMXProxy> resultMap = new HashMap<String, JEEMXProxy>();
        Set<String> keys = objectNameMap.keySet();
        for (String key : keys) {
            ObjectName objectName = objectNameMap.get(key);
            try {
                JEEMXProxy proxy = this.getProxy(objectName);
                if (proxy == null) continue;
                resultMap.put(key, proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return resultMap;
    }

    public Map<String, JEEMXProxy> toProxyMap(ObjectName[] objectNames, Class<? extends JEEMXProxy> intf) {
        HashMap<String, JEEMXProxy> resultMap = new HashMap<String, JEEMXProxy>();
        for (ObjectName objectName : objectNames) {
            String key = Util.unquoteIfNeeded(objectName.getKeyProperty("name"));
            JEEMXProxy proxy = this.getProxy(objectName, intf);
            if (proxy == null) continue;
            resultMap.put(key, proxy);
        }
        return resultMap;
    }

    public List<JEEMXProxy> toProxyList(ObjectName[] objectNames, Class<? extends JEEMXProxy> intf) {
        ArrayList<JEEMXProxy> result = new ArrayList<JEEMXProxy>();
        for (ObjectName objectName : objectNames) {
            JEEMXProxy proxy = this.getProxy(objectName, intf);
            if (proxy == null) continue;
            result.add(proxy);
        }
        return result;
    }
}

