/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.extra.mbeanserver;

import com.bes.admin.jeemx.extra.AbstractJEEMXFactory;
import com.bes.admin.jeemx.extra.mbeanserver.JEEMXStartupServiceMBean;
import com.bes.admin.jeemx.extra.mbeanserver.Util;
import com.bes.external.jeemx.BootJEEMXMBean;
import com.bes.external.jeemx.JEEMXBes;
import com.bes.mss.component.Habitat;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;

public final class BootJEEMX
implements BootJEEMXMBean {
    private final MBeanServer mMBeanServer;
    private final ObjectName mObjectName;
    private final Habitat mHabitat;
    private ObjectName mDomainRootObjectName;

    private static void debug(String s) {
        System.out.println(s);
    }

    private BootJEEMX(Habitat habitat, MBeanServer mbeanServer) {
        this.mHabitat = habitat;
        this.mMBeanServer = mbeanServer;
        this.mObjectName = BootJEEMX.getBootJEEMXMBeanObjectName();
        this.mDomainRootObjectName = null;
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException("JEEMX Booter MBean is already registered: " + this.mObjectName);
        }
    }

    public static ObjectName getBootJEEMXMBeanObjectName() {
        return JEEMXBes.DEFAULT.getBootJEEMXMBeanObjectName();
    }

    public static synchronized BootJEEMX create(Habitat habitat, MBeanServer server) {
        BootJEEMX booter = new BootJEEMX(habitat, server);
        ObjectName objectName = BootJEEMX.getBootJEEMXMBeanObjectName();
        try {
            StandardMBean mbean = new StandardMBean(booter, BootJEEMXMBean.class);
            if (!server.registerMBean(mbean, objectName).getObjectName().equals(objectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return booter;
    }

    JEEMXStartupServiceMBean getLoader() {
        try {
            return (JEEMXStartupServiceMBean)this.mHabitat.getByContract(JEEMXStartupServiceMBean.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public synchronized ObjectName bootJEEMX() {
        if (this.mDomainRootObjectName == null) {
            JEEMXStartupServiceMBean loader = this.getLoader();
            ObjectName startupON = JEEMXStartupServiceMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                throw new IllegalStateException("JEEMX MBean not yet available: " + startupON);
            }
            try {
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "loadJEEMXMBeans", null, null);
            }
            catch (JMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        return AbstractJEEMXFactory.getInstance().getJMXServiceURLs();
    }

    public void shutdown() {
        try {
            this.mMBeanServer.unregisterMBean(BootJEEMX.getBootJEEMXMBeanObjectName());
        }
        catch (Exception e) {
            Util.getLogger().log(Level.WARNING, "BootJEEMX.shutdown", e);
        }
    }
}

