/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.extra.mbeanserver;

import com.bes.external.jeemx.BootJEEMXMBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;

class BootJEEMXListener
implements NotificationListener {
    private final JMXConnectorServer mServer;
    private final BootJEEMXMBean mBooter;
    private final Logger mLogger = Logger.getLogger(BootJEEMXListener.class.getName());

    public BootJEEMXListener(JMXConnectorServer server, BootJEEMXMBean booter) {
        this.mServer = server;
        this.mBooter = booter;
    }

    public void handleNotification(Notification notif, Object handback) {
        JMXConnectionNotification n;
        if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
            this.mLogger.log(Level.INFO, "jmx.bootingjeemx.listener", handback);
            this.mBooter.bootJEEMX();
            try {
                this.mServer.removeNotificationListener(this);
                this.mLogger.fine("ConnectorStartupService.BootJEEMXListener: JEEMX is booted, stopped listening");
            }
            catch (ListenerNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

