/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.extra.mbeanserver;

import com.bes.admin.jeemx.extra.JEEMXFactory;
import com.bes.admin.jeemx.extra.mbeanserver.PendingConfigBeanJob;
import com.bes.admin.jeemx.extra.mbeanserver.Util;
import com.bes.mss.annotations.Inject;
import com.bes.mss.annotations.Service;
import com.bes.mss.component.CageBuilder;
import com.bes.mss.component.Inhabitant;
import com.bes.mss.component.PostConstruct;
import com.bes.mss.config.ConfigBean;
import com.bes.mss.config.ConfigBeanProxy;
import com.bes.mss.config.TransactionListener;
import com.bes.mss.config.Transactions;
import com.bes.mss.config.UnprocessedChangeEvents;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="PendingConfigBeans")
public class PendingConfigBeans
implements CageBuilder<ConfigBean>,
PostConstruct,
TransactionListener {
    @Inject
    Transactions transactions;
    @Inject(optional=true)
    JEEMXFactory jeemxFactory;
    private Class<? extends ConfigBeanProxy> rootConfigBeanClass;
    private final LinkedBlockingQueue<PendingConfigBeanJob> mJobs = new LinkedBlockingQueue();

    public int size() {
        return this.mJobs.size();
    }

    public void postConstruct() {
        this.transactions.addTransactionsListener((TransactionListener)this);
        this.rootConfigBeanClass = this.jeemxFactory == null ? null : this.jeemxFactory.getRootConfigBeanClass();
    }

    public PendingConfigBeanJob take() throws InterruptedException {
        return this.mJobs.take();
    }

    public PendingConfigBeanJob peek() throws InterruptedException {
        return this.mJobs.peek();
    }

    final ConfigBean asConfigBean(Object o) {
        return o instanceof ConfigBean ? (ConfigBean)ConfigBean.class.cast(o) : null;
    }

    public void onEntered(Inhabitant<ConfigBean> inhabitant) {
        ConfigBean cb = this.asConfigBean(inhabitant);
        if (cb != null) {
            this.add(cb);
        }
    }

    private PendingConfigBeanJob addJob(PendingConfigBeanJob job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        this.mJobs.add(job);
        return job;
    }

    private PendingConfigBeanJob add(ConfigBean cb) {
        return this.add(cb, null);
    }

    public PendingConfigBeanJob add(ConfigBean cb, boolean useLatch) {
        PendingConfigBeanJob job = this.add(cb, useLatch ? new CountDownLatch(1) : null);
        return job;
    }

    private PendingConfigBeanJob add(ConfigBean cb, CountDownLatch latch) {
        ConfigBean parent;
        ConfigBean ancestor = cb;
        while ((parent = this.asConfigBean(ancestor.parent())) != null) {
            ancestor = parent;
        }
        PendingConfigBeanJob job = null;
        if (ancestor != null && this.rootConfigBeanClass != null && ancestor.getProxyType() == this.rootConfigBeanClass) {
            job = this.addJob(new PendingConfigBeanJob(cb, latch));
        } else {
            Util.getLogger().info("PendingConfigBeans.onEntered: ignoring ConfigBean that does not have Domain as ancestor: " + cb.getProxyType().getName());
            if (latch != null) {
                latch.countDown();
            }
        }
        return job;
    }

    public boolean remove(ConfigBean cb) {
        boolean found = false;
        for (PendingConfigBeanJob job : this.mJobs) {
            if (job.getConfigBean() != cb) continue;
            found = true;
            job.releaseLatch();
            this.mJobs.remove(job);
            break;
        }
        if (found) {
            this.removeAllDescendants(cb);
        }
        return found;
    }

    private void removeAllDescendants(ConfigBean cb) {
        ArrayList<PendingConfigBeanJob> jobs = new ArrayList<PendingConfigBeanJob>(this.mJobs);
        for (PendingConfigBeanJob job : jobs) {
            if (!this.isDescendent(job.getConfigBean(), cb)) continue;
            this.mJobs.remove(job);
        }
    }

    private boolean isDescendent(ConfigBean candidate, ConfigBean parent) {
        boolean isParent = false;
        for (ConfigBean temp = candidate.parent(); temp != null; temp = temp.parent()) {
            if (temp != parent) continue;
            isParent = true;
            break;
        }
        return isParent;
    }

    public synchronized void swapTransactionListener(TransactionListener newListener) {
        this.transactions.addTransactionsListener(newListener);
        this.transactions.removeTransactionsListener((TransactionListener)this);
    }

    public synchronized void transactionCommited(List<PropertyChangeEvent> events) {
        for (PropertyChangeEvent event : events) {
            ConfigBean cb;
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            Object source = event.getSource();
            String propertyName = event.getPropertyName();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                cb = this.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)((ConfigBeanProxy)newValue)));
                this.add(cb);
                continue;
            }
            if (newValue != null || !(oldValue instanceof ConfigBeanProxy)) continue;
            cb = this.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)((ConfigBeanProxy)oldValue)));
            this.remove(cb);
        }
    }

    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }
}

