/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.base.MBeanTracker;
import com.bes.admin.jeemx.base.MBeanTrackerMBean;
import com.bes.admin.jeemx.base.SystemInfo;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.admin.jeemx.extra.JEEMXLoader;
import com.bes.admin.jeemx.extra.JeemxPref;
import com.bes.admin.jeemx.extra.mbeanserver.JEEMXStartupServiceMBean;
import com.bes.admin.jeemx.impl.mbean.ComplianceMonitor;
import com.bes.admin.jeemx.impl.mbean.DomainRootImpl;
import com.bes.admin.jeemx.impl.mbean.SystemInfoFactory;
import com.bes.admin.jeemx.impl.mbean.SystemInfoImpl;
import com.bes.admin.jeemx.impl.util.ImplUtil;
import com.bes.admin.jeemx.impl.util.InjectedValues;
import com.bes.admin.jeemx.impl.util.ObjectNameBuilder;
import com.bes.admin.jeemx.impl.util.SingletonEnforcer;
import com.bes.admin.jeemx.util.ExceptionUtil;
import com.bes.admin.jeemx.util.FeatureAvailability;
import com.bes.admin.jeemx.util.TimingDelta;
import com.bes.admin.jeemx.util.jmx.stringifier.StringifierRegistryIniter;
import com.bes.admin.jeemx.util.stringifier.StringifierRegistryImpl;
import com.bes.admin.jeemx.util.stringifier.StringifierRegistryIniterImpl;
import com.bes.external.jeemx.JEEMXBes;
import com.bes.external.jeemx.JEEMXUtil;
import com.bes.external.jeemx.MBeanListener;
import com.bes.mq.api.event.EventListener;
import com.bes.mq.api.event.EventTypes;
import com.bes.mq.api.event.Events;
import com.bes.mss.annotations.Inject;
import com.bes.mss.annotations.Service;
import com.bes.mss.component.Habitat;
import com.bes.mss.component.PostConstruct;
import com.bes.mss.component.PreDestroy;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;

@Service
public final class JEEMXStartupService
implements PostConstruct,
PreDestroy,
JEEMXStartupServiceMBean {
    @Inject
    Habitat mHabitat;
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    Events mEvents;
    private volatile MBeanTracker mMBeanTracker;
    private volatile ObjectName DOMAIN_ROOT_OBJECTNAME = null;

    private static void debug(String s) {
        System.out.println(s);
    }

    public static MBeanTrackerMBean getMBeanTracker(MBeanServer server) {
        return MBeanServerInvocationHandler.newProxyInstance(server, MBeanTrackerMBean.MBEAN_TRACKER_OBJECT_NAME, MBeanTrackerMBean.class, false);
    }

    public JEEMXStartupService() {
        new StringifierRegistryIniterImpl(StringifierRegistryImpl.DEFAULT);
        new StringifierRegistryIniter(StringifierRegistryImpl.DEFAULT);
    }

    private void shutdown() {
        ImplUtil.getLogger().fine("JEEMXStartupService: shutting down JEEMX MBeans");
        this.unloadJEEMXMBeans();
        ObjectName allJEEMXPattern = JEEMXUtil.newObjectName(JEEMXBes.DEFAULT.jeemxJMXDomain(), "*");
        Set<ObjectName> remainingJEEMX = this.mMBeanServer.queryNames(allJEEMXPattern, null);
        if (remainingJEEMX.size() != 0) {
            ImplUtil.getLogger().log(Level.WARNING, "JEEMXStartupService.shutdown: MBeans have not been unregistered: " + remainingJEEMX);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        FeatureAvailability.getInstance().deRegisterFeatures();
        ImplUtil.getLogger().fine("JEEMXStartupService: has been shut down and all JEEMX MBeans unregistered, remaining MBeans: " + this.mMBeanServer.queryNames(allJEEMXPattern, null));
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        SingletonEnforcer.register(this.getClass(), this);
        if (this.mMBeanServer == null) {
            throw new Error("JEEMXStartup: null MBeanServer");
        }
        try {
            StandardMBean mbean = new StandardMBean(this, JEEMXStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
            this.mMBeanTracker = new MBeanTracker(JEEMXBes.DEFAULT.jeemxJMXDomain());
            JeemxPref jeemxPref = InjectedValues.getInstance().getJEEMXPrefs();
            this.mMBeanTracker.setEmitMBeanStatus(jeemxPref == null ? false : Boolean.valueOf(jeemxPref.getEmitRegisrationStatus()));
            this.mMBeanServer.registerMBean(this.mMBeanTracker, MBeanTrackerMBean.MBEAN_TRACKER_OBJECT_NAME);
        }
        catch (Exception e) {
            ImplUtil.getLogger().log(Level.INFO, "Fatal error loading JEEMX", e);
            throw new Error(e);
        }
        ImplUtil.getLogger().fine("Initialized JEEMXStartupServiceNew in " + delta.elapsedMillis() + " ms, registered as " + OBJECT_NAME);
        this.mEvents.register((EventListener)new ShutdownListener());
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("JEEMXStartupService.preDestroy(): stopping JEEMX");
        this.unloadJEEMXMBeans();
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        try {
            return (JMXServiceURL[])this.mMBeanServer.getAttribute(JEEMXBes.DEFAULT.getBootJEEMXMBeanObjectName(), "JMXServiceURLs");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public static JEEMXStartupServiceMBean getJEEMXStartupServiceMBeanProxy(MBeanServer mbs) {
        JEEMXStartupServiceMBean ss = null;
        if (mbs.isRegistered(OBJECT_NAME)) {
            ss = (JEEMXStartupServiceMBean)JEEMXStartupServiceMBean.class.cast(MBeanServerInvocationHandler.newProxyInstance(mbs, OBJECT_NAME, JEEMXStartupServiceMBean.class, false));
        }
        return ss;
    }

    public synchronized ObjectName getDomainRoot() {
        try {
            return this.getDomainRootProxy().extra().objectName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
    }

    public ObjectName loadJEEMXMBeans() {
        ObjectName objectName = JEEMXBes.DEFAULT.domainRoot();
        if (!this.mMBeanServer.isRegistered(objectName)) {
            try {
                objectName = this._loadJEEMXMBeans();
            }
            catch (Exception e) {
                JEEMXStartupService.debug("JEEMXStartupServiceNew.loadJEEMXMBeans: " + e);
                throw new RuntimeException(e);
            }
        }
        return objectName;
    }

    private synchronized ObjectName loadDomainRoot() {
        if (this.DOMAIN_ROOT_OBJECTNAME != null) {
            return this.DOMAIN_ROOT_OBJECTNAME;
        }
        DomainRootImpl domainRoot = new DomainRootImpl();
        this.DOMAIN_ROOT_OBJECTNAME = JEEMXBes.DEFAULT.domainRoot();
        try {
            this.DOMAIN_ROOT_OBJECTNAME = this.mMBeanServer.registerMBean(domainRoot, this.DOMAIN_ROOT_OBJECTNAME).getObjectName();
            this.loadSystemInfo();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            ImplUtil.getLogger().log(Level.INFO, "Fatal error loading JEEMX DomainRoot", rootCause);
            throw new RuntimeException(rootCause);
        }
        return this.DOMAIN_ROOT_OBJECTNAME;
    }

    protected final ObjectName loadSystemInfo() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        SystemInfoImpl systemInfo = SystemInfoFactory.createInstance(this.mMBeanServer);
        ObjectName systemInfoObjectName = ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.DOMAIN_ROOT_OBJECTNAME, SystemInfo.class);
        systemInfoObjectName = this.mMBeanServer.registerMBean(systemInfo, systemInfoObjectName).getObjectName();
        return systemInfoObjectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName _loadJEEMXMBeans() {
        JEEMXBes jeemxg = JEEMXBes.DEFAULT;
        MBeanListener<MyListener> bootJEEMXListener = jeemxg.listenForBootJEEMX(this.mMBeanServer, new MyListener());
        MBeanListener<MyListener> domainRootListener = jeemxg.listenForDomainRoot(this.mMBeanServer, new MyListener());
        this.loadDomainRoot();
        FeatureAvailability.getInstance().registerFeature("JEEMXCoreReady", this.getDomainRoot());
        ImplUtil.getLogger().fine("JEEMXStartupServiceNew: JEEMX core MBeans are ready for use, DomainRoot = " + this.getDomainRoot());
        try {
            Collection loaders = this.mHabitat.getAllByContract(JEEMXLoader.class);
            ImplUtil.getLogger().fine("JEEMXStartupService._loadJEEMXMBeans(): found this many loaders: " + loaders.size());
            JEEMXLoaderThread[] threads = new JEEMXLoaderThread[loaders.size()];
            int i = 0;
            for (JEEMXLoader loader : loaders) {
                ImplUtil.getLogger().fine("JEEMXStartupService._loadJEEMXMBeans(): found this many loaders: " + loader);
                threads[i] = new JEEMXLoaderThread(loader);
                threads[i].start();
                ++i;
            }
            for (JEEMXLoaderThread thread : threads) {
                thread.waitDone();
            }
        }
        catch (Throwable t) {
            ImplUtil.getLogger().log(Level.INFO, "_loadJEEMXMBeans", t);
        }
        finally {
            FeatureAvailability.getInstance().registerFeature("JEEMXReady", this.getDomainRoot());
            ImplUtil.getLogger().fine("JEEMXStartupServiceNew: JEEMX ready for use, DomainRoot = " + this.getDomainRoot());
        }
        if (bootJEEMXListener.getCallback().getRegistered() == null) {
            throw new IllegalStateException("BootJEEMX listener was not called");
        }
        if (domainRootListener.getCallback().getRegistered() == null) {
            throw new IllegalStateException("DomainRoot listener was not called");
        }
        return this.getDomainRoot();
    }

    public synchronized void unloadJEEMXMBeans() {
        if (this.getDomainRoot() != null) {
            Collection loaders = this.mHabitat.getAllByContract(JEEMXLoader.class);
            for (JEEMXLoader loader : loaders) {
                if (loader == this) continue;
                try {
                    loader.unloadJEEMXMBeans();
                }
                catch (Exception e) {
                    ImplUtil.getLogger().info("JEEMXLoader failed to unload: " + e);
                }
            }
            ImplUtil.unregisterJEEMXMBeans(this.getDomainRootProxy());
            this.DOMAIN_ROOT_OBJECTNAME = null;
            ComplianceMonitor.removeInstance();
            SystemInfoFactory.removeInstance();
        }
    }

    class MyListener
    extends MBeanListener.CallbackImpl {
        MyListener() {
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
        }
    }

    private static final class JEEMXLoaderThread
    extends Thread {
        private final JEEMXLoader mLoader;
        private volatile ObjectName mTop;
        private final CountDownLatch mLatch;

        public JEEMXLoaderThread(JEEMXLoader loader) {
            this.mLoader = loader;
            this.mLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ImplUtil.getLogger().fine("JEEMXStartupServiceNew.JEEMXLoaderThread: loading: " + this.mLoader.getClass().getName());
                this.mTop = this.mLoader.loadJEEMXMBeans();
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.INFO, "JEEMXStartupServiceNew._loadJEEMXMBeans: JEEMXLoader failed to load", e);
            }
            finally {
                this.mLatch.countDown();
            }
        }

        public ObjectName waitDone() {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTop;
        }

        public ObjectName top() {
            return this.mTop;
        }
    }

    private final class ShutdownListener
    implements EventListener {
        private ShutdownListener() {
        }

        public void event(EventListener.Event event) {
            if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                JEEMXStartupService.this.shutdown();
            }
        }
    }
}

