/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.config;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.admin.jeemx.extra.AbstractJEEMXFactory;
import com.bes.admin.jeemx.extra.mbeanserver.PendingConfigBeanJob;
import com.bes.admin.jeemx.extra.mbeanserver.PendingConfigBeans;
import com.bes.admin.jeemx.impl.config.ConfigBeanJMXSupport;
import com.bes.admin.jeemx.impl.config.ConfigBeanJMXSupportRegistry;
import com.bes.admin.jeemx.impl.config.ConfigBeanRegistry;
import com.bes.admin.jeemx.impl.config.JEEMXConfigImpl;
import com.bes.admin.jeemx.impl.config.JEEMXConfigLoaderMBean;
import com.bes.admin.jeemx.impl.mbean.MBeanImplBase;
import com.bes.admin.jeemx.impl.util.ImplUtil;
import com.bes.admin.jeemx.impl.util.ObjectNameBuilder;
import com.bes.admin.jeemx.impl.util.SingletonEnforcer;
import com.bes.admin.jeemx.util.ExceptionUtil;
import com.bes.admin.jeemx.util.FeatureAvailability;
import com.bes.admin.jeemx.util.MapUtil;
import com.bes.admin.jeemx.util.TypeCast;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import com.bes.external.jeemx.JEEMXBes;
import com.bes.mss.config.ConfigBean;
import com.bes.mss.config.ConfigBeanProxy;
import com.bes.mss.config.TransactionListener;
import com.bes.mss.config.Transactions;
import com.bes.mss.config.UnprocessedChangeEvents;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public final class JEEMXConfigLoader
extends MBeanImplBase
implements JEEMXConfigLoaderMBean,
TransactionListener {
    private volatile JEEMXConfigLoaderThread mLoaderThread;
    private final Transactions mTransactions;
    private final Logger mLogger = Logger.getLogger(JEEMXConfigLoader.class.getName());
    private final PendingConfigBeans mPendingConfigBeans;
    private final ConfigBeanRegistry mRegistry = ConfigBeanRegistry.getInstance();
    private volatile ObjectName mConfigToolsObjectName = null;
    private static final AtomicLong sCounter = new AtomicLong(1L);

    private static void debug(String s) {
        System.out.println(s);
    }

    public JEEMXConfigLoader(MBeanServer mbeanServer, PendingConfigBeans pending, Transactions transactions) {
        super(mbeanServer);
        if (transactions == null) {
            throw new IllegalStateException("JEEMXConfigLoader.JEEMXConfigLoader: null Transactions");
        }
        this.mTransactions = transactions;
        this.mPendingConfigBeans = pending;
    }

    public void registerConfigured(Class<? extends ConfigBeanProxy> intf) {
        ConfigBeanJMXSupportRegistry.getInstance(intf);
    }

    @Override
    public Map<String, String> getConfiguredTypes() {
        List<Class<? extends ConfigBeanProxy>> classes = ConfigBeanJMXSupportRegistry.getConfiguredClasses();
        Map<String, String> types = MapUtil.newMap();
        for (Class<? extends ConfigBeanProxy> clazz : classes) {
            String classname = clazz.getName();
            String elementType = Util.typeFromName(classname);
            types.put(elementType, classname);
        }
        return types;
    }

    private void configBeanRemoved(ConfigBean cb) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            ImplUtil.unregisterJEEMXMBeans(this.mServer, objectName);
            this.mRegistry.remove(objectName);
        } else {
            this.mPendingConfigBeans.remove(cb);
        }
    }

    private void issueAttributeChange(ConfigBean cb, String xmlAttrName, Object oldValue, Object newValue, long whenChanged) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName == null) {
            throw new IllegalArgumentException("Can't issue attribute change for null ObjectName for ConfigBean " + cb.getProxyType().getName());
        }
        boolean changed = false;
        if (oldValue != null) {
            changed = !oldValue.equals(newValue);
        } else if (newValue != null) {
            boolean bl = changed = !newValue.equals(oldValue);
        }
        if (changed) {
            Object impl = this.mRegistry.getImpl(cb);
            if (!(impl instanceof JEEMXConfigImpl)) {
                throw new IllegalStateException("impossible");
            }
            JEEMXConfigImpl jeemx = (JEEMXConfigImpl)impl;
            String message = cb.getProxyType().getName() + "." + xmlAttrName + ": " + oldValue + " => " + newValue;
            jeemx.issueAttributeChangeForXmlAttrName(xmlAttrName, message, oldValue, newValue, whenChanged);
        }
    }

    private void sortAndDispatch(List<PropertyChangeEvent> events, long whenChanged) {
        ConfigBean cb;
        ConfigBeanProxy cbp;
        String propertyName;
        Object source;
        Object newValue;
        Object oldValue;
        ArrayList<ConfigBean> newConfigBeans = new ArrayList<ConfigBean>();
        ArrayList<PropertyChangeEvent> remainingEvents = new ArrayList<PropertyChangeEvent>();
        for (PropertyChangeEvent event : events) {
            oldValue = event.getOldValue();
            newValue = event.getNewValue();
            source = event.getSource();
            propertyName = event.getPropertyName();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                cbp = (ConfigBeanProxy)newValue;
                cb = JEEMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                Class proxyClass = cb.getProxyType();
                boolean doWait = this.jeemxIsRunning();
                if (!this.handleConfigBean(cb, doWait)) continue;
                newConfigBeans.add(cb);
                continue;
            }
            if (newValue == null && oldValue instanceof ConfigBeanProxy && this.jeemxIsRunning()) {
                cbp = (ConfigBeanProxy)oldValue;
                cb = JEEMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                this.configBeanRemoved(cb);
                continue;
            }
            remainingEvents.add(event);
        }
        if (this.jeemxIsRunning()) {
            for (PropertyChangeEvent event : remainingEvents) {
                oldValue = event.getOldValue();
                newValue = event.getNewValue();
                source = event.getSource();
                propertyName = event.getPropertyName();
                if (source instanceof ConfigBeanProxy) {
                    cbp = (ConfigBeanProxy)source;
                    cb = JEEMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                    if (this.mRegistry.getObjectName(cb) == null) {
                        if (newConfigBeans.contains(cb) || !this.handleConfigBean(cb, false)) continue;
                        newConfigBeans.add(cb);
                        continue;
                    }
                    this.issueAttributeChange(cb, propertyName, oldValue, newValue, whenChanged);
                    continue;
                }
                JEEMXConfigLoader.debug("JEEMXConfigLoader.sortAndDispatch: WARNING: source is not a ConfigBean");
            }
        }
    }

    public void transactionCommited(List<PropertyChangeEvent> changes) {
        this.sortAndDispatch(changes, System.currentTimeMillis());
    }

    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }

    @Override
    protected void postRegisterHook(Boolean registrationDone) {
        super.postRegisterHook(registrationDone);
        if (registrationDone.booleanValue()) {
            this.mPendingConfigBeans.swapTransactionListener(this);
        }
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
    }

    @Override
    protected void postDeregisterHook() {
        super.postDeregisterHook();
        this.mTransactions.removeTransactionsListener((TransactionListener)this);
    }

    public void stop() {
        ObjectName objectName = JMXUtil.newObjectName(JEEMXBes.DEFAULT.jeemxSupportDomain(), "type=JEEMXConfigLoader");
        try {
            this.mServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.SEVERE, "Can't register JEEMXConfigLoader ", e);
            throw new RuntimeException(e);
        }
        SingletonEnforcer.deregister(JEEMXConfigLoader.class, this);
    }

    boolean handleConfigBean(ConfigBean cb, boolean waitDone) {
        boolean processed = true;
        if (this.mRegistry.getObjectName(cb) == null) {
            PendingConfigBeanJob job = this.mPendingConfigBeans.add(cb, waitDone);
            if (job == null) {
                this.mLogger.log(Level.INFO, "jeemx.ConfigBean.not.processed", cb.getProxyType().getName());
                processed = false;
            } else if (waitDone) {
                try {
                    job.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return processed;
    }

    private ConfigBean getActualParent(ConfigBean configBean) {
        ConfigBean parent = JEEMXConfigLoader.asConfigBean(configBean.parent());
        if (parent != null) {
            ObjectName objectName = this.mRegistry.getObjectName(parent);
        } else if (configBean.getProxyType() != AbstractJEEMXFactory.getInstance().getRootConfigBeanClass()) {
            throw new IllegalStateException("WARNING: parent is null for " + configBean.getProxyType().getName());
        }
        return parent;
    }

    private ObjectName getActualParentObjectName(ConfigBean configBean) {
        ObjectName parentObjectName = null;
        ConfigBean parent = this.getActualParent(configBean);
        if (parent != null) {
            parentObjectName = this.mRegistry.getObjectName(parent);
        }
        return parentObjectName;
    }

    static ConfigBean asConfigBean(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof ConfigBean)) {
            throw new IllegalArgumentException("Not a ConfigBean: " + o.getClass().getName());
        }
        return (ConfigBean)o;
    }

    public synchronized ObjectName start() {
        this.mLogger.log(Level.FINE, "jeemx.In.JEEMXConfigLoader", this.mLoaderThread);
        if (this.mLoaderThread == null) {
            FeatureAvailability.getInstance().waitForFeature("JEEMXCoreReady", "JEEMXConfigLoader.start");
            this.mLoaderThread = new JEEMXConfigLoaderThread(this.mPendingConfigBeans);
            this.mLoaderThread.setDaemon(true);
            this.mLoaderThread.start();
            ObjectName objectName = JMXUtil.newObjectName(JEEMXBes.DEFAULT.jeemxSupportDomain(), "type=JEEMXConfigLoader");
            try {
                this.mServer.registerMBean(this, objectName);
            }
            catch (Exception e) {
                this.mLogger.log(Level.SEVERE, "Can't register JEEMXConfigLoader ", e);
                throw new RuntimeException(e);
            }
            SingletonEnforcer.register(JEEMXConfigLoader.class, this);
            this.mLoaderThread.waitInitialQueue();
            ObjectName domainConfig = this.getDomainRootProxy().getDomain().objectName();
            this.mLogger.log(Level.FINE, "jeemx.domain.config.registered", domainConfig);
            FeatureAvailability.getInstance().registerFeature("JEEMXConfigReady", domainConfig);
        }
        return null;
    }

    private synchronized boolean jeemxIsRunning() {
        return this.mLoaderThread != null;
    }

    private ObjectName registerConfigBeanAsMBean(ConfigBean cb) {
        ObjectName objectName = null;
        ConfigBean parentCB = this.getActualParent(cb);
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            this.registerConfigBeanAsMBean(parentCB);
        }
        objectName = this._registerConfigBeanAsMBean(cb, parentCB);
        assert (objectName == null || this.mRegistry.getObjectName(cb) != null);
        return objectName;
    }

    private ObjectName _registerConfigBeanAsMBean(ConfigBean cb, ConfigBean parentCB) {
        Class cbClass = cb.getProxyType();
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            throw new IllegalArgumentException("ConfigBean " + cbClass.getName() + " already registered as " + objectName);
        }
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            throw new IllegalArgumentException("ConfigBean parent " + parentCB.getProxyType().getName() + " must be registered first before child = " + cbClass.getName());
        }
        objectName = this.buildObjectName(cb);
        if ((objectName = this.createAndRegister(cb, objectName)) != null) {
            this.mLogger.fine("REGISTERED MBEAN: " + objectName);
        }
        return objectName;
    }

    private ObjectName createAndRegister(ConfigBean cb, ObjectName objectNameIn) {
        ObjectName objectName = objectNameIn;
        String type = objectNameIn.getKeyProperty("type");
        ObjectName parentObjectName = this.getActualParentObjectName(cb);
        if (parentObjectName == null) {
            parentObjectName = JEEMXBes.DEFAULT.domainRoot();
        }
        JEEMXConfigImpl impl = new JEEMXConfigImpl(parentObjectName, cb);
        try {
            ObjectInstance instance = this.mServer.registerMBean(impl, objectNameIn);
            objectName = instance.getObjectName();
            this.mRegistry.add(cb, objectName, impl);
            if (JEEMXBes.DEFAULT.domainRoot().equals(parentObjectName) && cb.getProxyType() == AbstractJEEMXFactory.getInstance().getRootConfigBeanClass()) {
                String domainType = "domain";
                ObjectName domainName = ObjectNameBuilder.buildChildObjectName(this.mServer, parentObjectName, domainType, null);
                ObjectInstance domainInstance = this.mServer.registerMBean(impl, domainName);
                objectName = domainInstance.getObjectName();
                this.mRegistry.add(cb, domainName, impl);
            }
        }
        catch (JMException e) {
            JEEMXConfigLoader.debug(ExceptionUtil.toString(e));
            objectName = null;
        }
        return objectName;
    }

    private String getType(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        return spt.getTypeString();
    }

    static String getKey(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (spt.isSingleton()) {
            return null;
        }
        String name = null;
        String nameHint = spt.getNameHint();
        if (nameHint == null) {
            name = "MISSING_NAME__KEY_MUST_BE_SPECIFIED_IN_INTERFACE";
        } else if (spt.nameHintIsElement()) {
            List leaf = cb.leafElements(nameHint);
            if (leaf != null) {
                List<String> items = TypeCast.checkList(leaf, String.class);
                if (items.size() != 1) {
                    throw new IllegalArgumentException("Can't find sub-element of type " + nameHint + " in " + cb.getProxyType().getName());
                }
                name = items.get(0);
            }
        } else {
            name = cb.rawAttribute(nameHint);
        }
        return name;
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance(this.mServer).getDomainRootProxy(false);
    }

    private ObjectName buildObjectName(ConfigBean cb) {
        ConfigBean parent = this.getActualParent(cb);
        ObjectName parentObjectName = parent == null ? JEEMXBes.DEFAULT.domainRoot() : this.mRegistry.getObjectName(parent);
        String type = this.getType(cb);
        String name = JEEMXConfigLoader.getKey(cb);
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (!(spt.isSingleton() || name != null && name.length() != 0)) {
            name = "MISSING_NAME-" + sCounter.getAndIncrement();
            this.mLogger.log(Level.WARNING, "jeemx.nonsingleton.configbean", new Object[]{cb.getProxyType().getName(), name});
        }
        ObjectName objectName = ObjectNameBuilder.buildChildObjectName(this.mServer, parentObjectName, type, name);
        return objectName;
    }

    private final class JEEMXConfigLoaderThread
    extends Thread {
        private final PendingConfigBeans mPending;
        volatile boolean mQuit;
        private volatile CountDownLatch mInitalQueueLatch;

        JEEMXConfigLoaderThread(PendingConfigBeans pending) {
            super("JEEMXConfigLoader.JEEMXConfigLoaderThread");
            this.mQuit = false;
            this.mInitalQueueLatch = new CountDownLatch(1);
            this.mPending = pending;
        }

        void quit() {
            this.mQuit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectName registerOne(PendingConfigBeanJob job) {
            ConfigBean cb = job.getConfigBean();
            ObjectName objectName = JEEMXConfigLoader.this.mRegistry.getObjectName(cb);
            try {
                if (objectName == null) {
                    objectName = JEEMXConfigLoader.this.registerConfigBeanAsMBean(cb);
                }
            }
            catch (Throwable t) {
                JEEMXConfigLoader.this.mLogger.log(Level.WARNING, "Can't register config MBean: " + objectName, t);
            }
            finally {
                job.releaseLatch();
            }
            return objectName;
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                JEEMXConfigLoader.this.mLogger.log(Level.SEVERE, "Unexpected thread death of JEEMXConfigLoaderThread", t);
            }
        }

        public void waitInitialQueue() {
            CountDownLatch latch = this.mInitalQueueLatch;
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.mInitalQueueLatch = null;
            }
        }

        protected void doRun() throws Exception {
            PendingConfigBeanJob job = this.mPending.take();
            while (!this.mQuit && job != null) {
                ObjectName objectName = this.registerOne(job);
                job = this.mPending.peek();
                if (job == null) continue;
                job = this.mPending.take();
            }
            this.mInitalQueueLatch.countDown();
            while (!this.mQuit) {
                job = this.mPending.take();
                this.registerOne(job);
            }
        }
    }

    private static final class Job {
        final ConfigBean mConfigBean;
        final CountDownLatch mLatch;

        public Job(ConfigBean configBean, CountDownLatch latch) {
            this.mConfigBean = configBean;
            this.mLatch = latch;
        }

        public void releaseLatch() {
            if (this.mLatch != null) {
                this.mLatch.countDown();
            }
        }
    }
}

