/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.config;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.admin.jeemx.extra.AbstractJEEMXFactory;
import com.bes.admin.jeemx.extra.mbeanserver.PendingConfigBeans;
import com.bes.admin.jeemx.impl.config.JEEMXConfigLoader;
import com.bes.admin.jeemx.impl.config.JEEMXConfigStartupServiceMBean;
import com.bes.admin.jeemx.impl.util.ImplUtil;
import com.bes.admin.jeemx.impl.util.InjectedValues;
import com.bes.admin.jeemx.util.TimingDelta;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import com.bes.mss.annotations.Inject;
import com.bes.mss.annotations.Service;
import com.bes.mss.component.PostConstruct;
import com.bes.mss.component.PreDestroy;
import com.bes.mss.config.Transactions;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
@Service
public final class JEEMXConfigStartupService
implements PostConstruct,
PreDestroy,
JEEMXConfigStartupServiceMBean {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    private volatile PendingConfigBeans mPendingConfigBeans;
    @Inject
    private Transactions mTransactions;
    private volatile JEEMXConfigLoader mLoader;
    private volatile PendingConfigBeans mPendingConfigBeansBackup;

    private static void debug(String s) {
        System.out.println(s);
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        if (this.mMBeanServer == null) {
            throw new Error("JEEMXStartup: null MBeanServer");
        }
        if (this.mPendingConfigBeans == null) {
            throw new Error("JEEMXStartup: null mPendingConfigBeans");
        }
        this.mPendingConfigBeansBackup = this.mPendingConfigBeans;
        try {
            StandardMBean mbean = new StandardMBean(this, JEEMXConfigStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
        ImplUtil.getLogger().fine("Initialized JEEMXConfig Startup service in " + delta.elapsedMillis() + " ms, registered as " + OBJECT_NAME);
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("JEEMXConfigStartupService.preDestroy(): stopping JEEMX");
        this.unloadJEEMXMBeans();
    }

    public DomainRoot getDomainRoot() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
    }

    public ObjectName getDomainConfig() {
        return this.getDomainRoot().child(AbstractJEEMXFactory.getInstance().getJEEMXRooConfigClass()).extra().objectName();
    }

    public JEEMXProxy getDomainConfigProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getProxy(this.getDomainConfig(), AbstractJEEMXFactory.getInstance().getJEEMXRooConfigClass());
    }

    public synchronized ObjectName loadJEEMXMBeans() {
        if (this.mLoader == null) {
            if (this.mPendingConfigBeans.size() == 0) {
                this.mPendingConfigBeans = this.mPendingConfigBeansBackup;
            }
            this.mLoader = new JEEMXConfigLoader(this.mMBeanServer, this.mPendingConfigBeans, this.mTransactions);
            this.mLoader.start();
        }
        return this.getDomainConfig();
    }

    public synchronized void unloadJEEMXMBeans() {
        JEEMXProxy domainConfig = this.getDomainConfigProxy();
        if (domainConfig != null) {
            ImplUtil.unregisterJEEMXMBeans(domainConfig);
        }
        this.mLoader.stop();
        this.mLoader = null;
    }
}

