/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.ext;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.base.RuntimeRoot;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.admin.jeemx.impl.ext.JEEMXExtStartupServiceMBean;
import com.bes.admin.jeemx.impl.ext.LoggingImpl;
import com.bes.admin.jeemx.impl.ext.RuntimeRootImpl;
import com.bes.admin.jeemx.impl.mbean.JEEMXImplBase;
import com.bes.admin.jeemx.impl.util.InjectedValues;
import com.bes.admin.jeemx.impl.util.ObjectNameBuilder;
import com.bes.admin.jeemx.logging.Logging;
import com.bes.admin.jeemx.util.FeatureAvailability;
import com.bes.mss.annotations.Inject;
import com.bes.mss.annotations.Service;
import com.bes.mss.component.PostConstruct;
import com.bes.mss.component.PreDestroy;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

@Service
public final class JEEMXExtStartupService
implements PostConstruct,
PreDestroy,
JEEMXExtStartupServiceMBean {
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    private volatile boolean mLoaded = false;

    private static void debug(String s) {
        System.out.println(s);
    }

    public void postConstruct() {
        try {
            StandardMBean mbean = new StandardMBean(this, JEEMXExtStartupServiceMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
    }

    public void preDestroy() {
        this.unloadJEEMXMBeans();
    }

    public DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
    }

    public synchronized ObjectName loadJEEMXMBeans() {
        if (!this.mLoaded) {
            this.mLoaded = true;
            FeatureAvailability.getInstance().waitForFeature("JEEMXCoreReady", "JEEMXExtStartupService.loadJEEMXMBeans");
            FeatureAvailability.getInstance().waitForFeature("JEEMXConfigReady", "JEEMXExtStartupService.loadJEEMXMBeans");
            MBeanServer s = this.mMBeanServer;
            ObjectName domainRoot = this.getDomainRootProxy().objectName();
            ObjectName loggingObjectName = ObjectNameBuilder.buildChildObjectName(s, domainRoot, Logging.class);
            JEEMXImplBase mbean = new LoggingImpl(domainRoot, "server");
            this.registerChild(mbean, loggingObjectName);
            ObjectName runtimeObjectname = ObjectNameBuilder.buildChildObjectName(s, domainRoot, RuntimeRoot.class);
            mbean = new RuntimeRootImpl(domainRoot);
            this.registerChild(mbean, runtimeObjectname);
        }
        return null;
    }

    protected synchronized ObjectName registerChild(Object mbean, ObjectName childObjectName) {
        try {
            ObjectName objectName = this.mMBeanServer.registerMBean(mbean, childObjectName).getObjectName();
            return objectName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void unloadJEEMXMBeans() {
    }
}

