/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.ext;

import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.extra.AbstractJEEMXFactory;
import com.bes.admin.jeemx.impl.mbean.JEEMXImplBase;
import com.bes.admin.jeemx.logging.LogRecordEmitter;
import com.bes.admin.jeemx.logging.Logging;
import com.bes.admin.jeemx.util.ExceptionUtil;
import com.bes.admin.jeemx.util.SetUtil;
import com.bes.admin.jeemx.util.ThrowableMapper;
import com.bes.admin.jeemx.util.TypeCast;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.admin.jeemx.util.jmx.NotificationBuilder;
import com.bes.external.jeemx.JEEMXBes;
import com.bes.mss.annotations.Service;
import com.bes.mss.component.Habitat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class LoggingImpl
extends JEEMXImplBase {
    private final Map<Level, String> mLevelToNotificationTypeMap;
    private final Map<String, NotificationBuilder> mNotificationTypeToNotificationBuilderMap;
    private static final String SERVER_LOG_NAME = "server.log";
    private static final String ACCESS_LOG_NAME = "access.log";
    private final Logger logger;
    private final Habitat mHabitat;
    final String FILE_SEP;
    private final String mServerName;
    private static MBeanNotificationInfo[] SELF_NOTIFICATION_INFOS = null;
    private static final Integer INTEGER_0 = 0;
    private static final Map<String, Integer> EMPTY_ERROR_DISTRIBUTION_MAP = Collections.emptyMap();
    private static final Set<String> LEGAL_DISTRIBUTION_LEVELS = SetUtil.newUnmodifiableStringSet(Level.SEVERE.toString(), Level.WARNING.toString());
    private static final Object[] LEVELS_AND_NOTIF_TYPES = new Object[]{Level.SEVERE, LogRecordEmitter.LOG_RECORD_SEVERE_NOTIFICATION_TYPE, Level.WARNING, LogRecordEmitter.LOG_RECORD_WARNING_NOTIFICATION_TYPE, Level.INFO, LogRecordEmitter.LOG_RECORD_INFO_NOTIFICATION_TYPE, Level.CONFIG, LogRecordEmitter.LOG_RECORD_CONFIG_NOTIFICATION_TYPE, Level.FINE, LogRecordEmitter.LOG_RECORD_FINE_NOTIFICATION_TYPE, Level.FINER, LogRecordEmitter.LOG_RECORD_FINER_NOTIFICATION_TYPE, Level.FINEST, LogRecordEmitter.LOG_RECORD_FINEST_NOTIFICATION_TYPE};
    private long mMyThreadID = -1L;

    public static ObjectName getObjectName(String serverName) {
        String requiredProps = Util.makeRequiredProps(Util.deduceType(Logging.class), serverName);
        String ServerRootMonitorType = "ServerRootMonitor";
        String parentProp = Util.makeProp("ServerRootMonitor", serverName);
        String props = Util.concatenateProps(requiredProps, parentProp);
        return Util.newObjectName(JEEMXBes.DEFAULT.jeemxJMXDomain(), props);
    }

    public LoggingImpl(ObjectName parent, String serverName) {
        super(parent, Logging.class);
        this.mServerName = serverName;
        this.FILE_SEP = System.getProperty("file.separator");
        this.mLevelToNotificationTypeMap = LoggingImpl.initLevelToNotificationTypeMap();
        this.mNotificationTypeToNotificationBuilderMap = new HashMap<String, NotificationBuilder>();
        this.mHabitat = AbstractJEEMXFactory.getInstance().getDefaultHabitat();
        this.logger = Logger.getAnonymousLogger();
    }

    private static synchronized MBeanNotificationInfo[] getSelfNotificationInfos() {
        if (SELF_NOTIFICATION_INFOS == null) {
            String[] types = SetUtil.toStringArray(LogRecordEmitter.ALL_LOG_RECORD_NOTIFICATION_TYPES);
            MBeanNotificationInfo selfInfo = new MBeanNotificationInfo(types, Notification.class.getName(), "LogRecord notifications");
            SELF_NOTIFICATION_INFOS = new MBeanNotificationInfo[]{selfInfo};
        }
        return SELF_NOTIFICATION_INFOS;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        MBeanNotificationInfo[] all = JMXUtil.mergeMBeanNotificationInfos(superInfos, LoggingImpl.getSelfNotificationInfos());
        return all;
    }

    private void unimplemented() {
        throw new RuntimeException("Not implemented.");
    }

    public void setModuleLogLevel(String module, String level) {
        throw new RuntimeException("Not implemented.");
    }

    public String getModuleLogLevel(String module) {
        throw new RuntimeException("Not implemented.");
    }

    public Map<String, String> getLoggingProperties() {
        throw new RuntimeException("Not implemented.");
    }

    public void updateLoggingProperties(Map<String, String> properties) {
        throw new RuntimeException("Not implemented.");
    }

    public int getLogLevelListenerCount(Level logLevel) {
        throw new RuntimeException("Not implemented.");
    }

    public String[] getLogFileKeys() {
        this.unimplemented();
        return new String[]{"server", "access"};
    }

    public synchronized String[] getLogFileNames(String key) {
        String[] result = null;
        if (!"server".equals(key)) {
            throw new IllegalArgumentException(key);
        }
        return result;
    }

    public Map<String, String> getLoggingAttributes() {
        throw new RuntimeException("Not implemented.");
    }

    public void updateLoggingAttributes(Map<String, String> properties) {
        throw new RuntimeException("Not implemented.");
    }

    public synchronized void rotateAllLogFiles() {
        throw new RuntimeException("Not implemented.");
    }

    public synchronized void rotateLogFile(String key) {
        throw new RuntimeException("Not implemented.");
    }

    private Properties attributesToProps(List<Attribute> attrs) {
        Properties props = new Properties();
        if (attrs != null) {
            for (Attribute attr : attrs) {
                Object value = attr.getValue();
                if (value == null) {
                    throw new IllegalArgumentException(attr.getName() + "=" + null);
                }
                props.put(attr.getName(), value.toString());
            }
        }
        return props;
    }

    private List<Serializable[]> convertQueryResult(AttributeList queryResult) {
        AttributeList fieldAttrs = (AttributeList)((Attribute)queryResult.get(0)).getValue();
        String[] fieldHeaders = new String[fieldAttrs.size()];
        for (int i = 0; i < fieldHeaders.length; ++i) {
            Attribute attr = (Attribute)fieldAttrs.get(i);
            fieldHeaders[i] = (String)attr.getValue();
        }
        List srcRecords = TypeCast.asList(((Attribute)queryResult.get(1)).getValue());
        ArrayList<Serializable[]> results = new ArrayList<Serializable[]>(srcRecords.size());
        results.add((Serializable[])fieldHeaders);
        for (int recordIdx = 0; recordIdx < srcRecords.size(); ++recordIdx) {
            List record = (List)srcRecords.get(recordIdx);
            assert (record.size() == fieldHeaders.length);
            Serializable[] fieldValues = new Serializable[fieldHeaders.length];
            for (int fieldIdx = 0; fieldIdx < fieldValues.length; ++fieldIdx) {
                fieldValues[fieldIdx] = (Serializable)record.get(fieldIdx);
            }
            results.add(fieldValues);
        }
        return results;
    }

    public List<Serializable[]> queryServerLog(String name, long startIndex, boolean searchForward, int maximumNumberOfResults, Long fromTime, Long toTime, String logLevel, Set<String> modules, List<Attribute> nameValuePairs, String anySearch) {
        List<Serializable[]> result = this.queryServerLogInternal(name, startIndex, searchForward, maximumNumberOfResults, fromTime, toTime, logLevel, modules, nameValuePairs, anySearch);
        return result;
    }

    private List<Serializable[]> queryServerLogInternal(String name, long startIndex, boolean searchForward, int maximumNumberOfResults, Long fromTime, Long toTime, String logLevel, Set<String> modules, List<Attribute> nameValuePairs, String anySearch) {
        throw new RuntimeException("Not implemented.");
    }

    public Map<String, Number>[] getErrorInfo() {
        throw new RuntimeException("Not implemented.");
    }

    public Map<String, Integer> getErrorDistribution(long timestamp, String level) {
        throw new RuntimeException("Not implemented.");
    }

    public void setKeepErrorStatisticsForIntervals(int num) {
        this.unimplemented();
    }

    public int getKeepErrorStatisticsForIntervals() {
        return 0;
    }

    public void setErrorStatisticsIntervalMinutes(long minutes) {
        this.unimplemented();
    }

    public long getErrorStatisticsIntervalMinutes() {
        return 0L;
    }

    public String[] getLoggerNames() {
        return EMPTY_STRING_ARRAY;
    }

    public String[] getLoggerNamesUnder(String loggerName) {
        this.unimplemented();
        return null;
    }

    public String[] getDiagnosticCauses(String messageID, String moduleName) {
        throw new RuntimeException("Not implemented.");
    }

    public String[] getDiagnosticChecks(String messageID, String moduleName) {
        throw new RuntimeException("Not implemented.");
    }

    public String getDiagnosticURI(String messageID) {
        this.unimplemented();
        return null;
    }

    private static Map<Level, String> initLevelToNotificationTypeMap() {
        HashMap<Level, String> m = new HashMap<Level, String>();
        for (int i = 0; i < LEVELS_AND_NOTIF_TYPES.length; i += 2) {
            Level level = (Level)LEVELS_AND_NOTIF_TYPES[i];
            String notifType = (String)LEVELS_AND_NOTIF_TYPES[i + 1];
            m.put(level, notifType);
        }
        return Collections.unmodifiableMap(m);
    }

    private String logLevelToNotificationType(Level level) {
        String notificationType = this.mLevelToNotificationTypeMap.get(level);
        if (notificationType == null) {
            // empty if block
        }
        return notificationType;
    }

    @Override
    protected void preRegisterDone() throws Exception {
        this.initNotificationTypeToNotificationBuilderMap(this.getObjectName());
    }

    private void initNotificationTypeToNotificationBuilderMap(ObjectName objectName) {
        this.mNotificationTypeToNotificationBuilderMap.clear();
        for (String notifType : LogRecordEmitter.ALL_LOG_RECORD_NOTIFICATION_TYPES) {
            this.mNotificationTypeToNotificationBuilderMap.put(notifType, new NotificationBuilder(notifType, objectName));
        }
    }

    private NotificationBuilder notificationTypeToNotificationBuilder(String notificationType) {
        NotificationBuilder builder = this.mNotificationTypeToNotificationBuilderMap.get(notificationType);
        assert (builder != null);
        return builder;
    }

    private Map<String, Serializable> logRecordToMap(LogRecord record, String recordAsString) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("LogRecord.toString", (Serializable)((Object)recordAsString));
        m.put("LogRecord.Level", record.getLevel());
        m.put("LogRecord.LoggerName", (Serializable)((Object)record.getLoggerName()));
        m.put("LogRecord.Message", (Serializable)((Object)record.getMessage()));
        m.put("LogRecord.Millis", Long.valueOf(record.getMillis()));
        m.put("LogRecord.SequenceNumber", Long.valueOf(record.getSequenceNumber()));
        m.put("LogRecord.SourceClassName", (Serializable)((Object)record.getSourceClassName()));
        m.put("LogRecord.SourceMethodName", (Serializable)((Object)record.getSourceMethodName()));
        m.put("LogRecord.ThreadID", Integer.valueOf(record.getThreadID()));
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            Throwable mapped = new ThrowableMapper(thrown).map();
            m.put("LogRecord.Thrown", mapped);
            Throwable rootCause = ExceptionUtil.getRootCause(thrown);
            if (rootCause != thrown) {
                Throwable mappedRootCause = new ThrowableMapper(rootCause).map();
                m.put("LogRecord.ThrownRootCause", mappedRootCause);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void privateLoggingHook(LogRecord logRecord, Formatter formatter) {
        if ((long)logRecord.getThreadID() == this.mMyThreadID) {
            this.debug((Object)"privateLoggingHook: recusive call!!!");
            throw new RuntimeException("Recursive call");
        }
        LoggingImpl loggingImpl = this;
        synchronized (loggingImpl) {
            this.mMyThreadID = Thread.currentThread().getId();
            Level level = logRecord.getLevel();
            try {
                if (this.getLogLevelListenerCount(level) != 0) {
                    String notifType = this.logLevelToNotificationType(level);
                    NotificationBuilder builder = this.notificationTypeToNotificationBuilder(notifType);
                    String logRecordAsString = formatter.format(logRecord);
                    Map<String, Serializable> userData = this.logRecordToMap(logRecord, logRecordAsString);
                    Notification notif = builder.buildNewWithMap(logRecordAsString, userData);
                    this.debug((Object)("privateLoggingHook: sending: " + notif));
                    this.sendNotification(notif);
                }
            }
            finally {
                this.mMyThreadID = -1L;
            }
        }
    }

    public void testEmitLogMessage(String level, String message) {
        throw new RuntimeException("Not implemented.");
    }
}

