/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.mbean;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.core.JEEMXValidator;
import com.bes.admin.jeemx.extra.JeemxPref;
import com.bes.admin.jeemx.impl.util.InjectedValues;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComplianceMonitor
implements NotificationListener {
    private static ComplianceMonitor INSTANCE = null;
    private final DomainRoot mDomainRoot;
    private final MBeanServer mServer;
    private volatile boolean mStarted = false;
    private volatile String mValidationLevel;
    private volatile boolean mUnregisterNonCompliant;
    private volatile boolean mLogInaccessibleAttributes;
    private final ValidatorThread mValidatorThread;
    private final Logger mLogger = Logger.getLogger(ComplianceMonitor.class.getName());

    private ComplianceMonitor(DomainRoot domainRoot) {
        this.mDomainRoot = domainRoot;
        this.mServer = (MBeanServer)domainRoot.extra().mbeanServerConnection();
        JeemxPref jeemxPrefs = InjectedValues.getInstance().getJEEMXPrefs();
        if (jeemxPrefs == null) {
            this.mValidationLevel = "full";
            this.mUnregisterNonCompliant = false;
            this.mLogInaccessibleAttributes = true;
        } else {
            this.mValidationLevel = jeemxPrefs.getValidationLevel();
            this.mUnregisterNonCompliant = Boolean.valueOf(jeemxPrefs.getUnregisterNonCompliant());
            this.mLogInaccessibleAttributes = Boolean.valueOf(jeemxPrefs.getLogInaccessibleAttributes());
        }
        this.mValidatorThread = new ValidatorThread(this.mServer, this.mValidationLevel, this.mUnregisterNonCompliant, this.mLogInaccessibleAttributes);
        this.mLogger.log(Level.FINE, "jeemx.JEEMXComplianceMonitor.level", new Object[]{this.mValidationLevel, this.mUnregisterNonCompliant, this.mLogInaccessibleAttributes});
    }

    public Map<ObjectName, JEEMXValidator.ProblemList> getComplianceFailures() {
        return this.mValidatorThread.getComplianceFailures();
    }

    private void listen() {
        try {
            JMXUtil.listenToMBeanServerDelegate(this.mServer, this, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<ObjectName> existing = JMXUtil.queryLocalMBeans(this.mServer, this.mDomainRoot.objectName().getDomain(), System.getProperty("com.bes.instanceName"));
        for (ObjectName objectName : existing) {
            this.validate(objectName);
        }
    }

    boolean shouldValidate() {
        return !"off".equals(this.mValidationLevel);
    }

    private void validate(ObjectName objectName) {
        if (this.shouldValidate()) {
            this.mValidatorThread.add(objectName);
        }
    }

    public static synchronized ComplianceMonitor getInstance(DomainRoot domainRoot) {
        if (INSTANCE == null) {
            INSTANCE = new ComplianceMonitor(domainRoot);
            INSTANCE.listen();
        }
        return INSTANCE;
    }

    public static synchronized void removeInstance() {
        if (INSTANCE != null) {
            INSTANCE.destroy();
            INSTANCE = null;
        }
    }

    public void start() {
        if (this.shouldValidate() && !this.mStarted) {
            this.mValidatorThread.start();
        }
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        MBeanServerNotification notif;
        ObjectName objectName;
        if (notifIn instanceof MBeanServerNotification && notifIn.getType().equals("JMX.mbean.registered") && (objectName = (notif = (MBeanServerNotification)notifIn).getMBeanName()).getDomain().equals(this.mDomainRoot.objectName().getDomain())) {
            this.validate(objectName);
        }
    }

    protected void destroy() {
        this.mValidatorThread.quit();
        this.mStarted = false;
        this.mValidationLevel = null;
    }

    private static void debug(Object o) {
        System.out.println(o.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValidatorThread
    extends Thread {
        private final MBeanServer mServer;
        private final LinkedBlockingQueue<ObjectName> mMBeans = new LinkedBlockingQueue();
        private final AtomicInteger mComplianceFailures = new AtomicInteger();
        private final boolean mUnregisterNonCompliant;
        private volatile String mValidationLevel;
        private volatile boolean mLogInaccessibleAttributes;
        private final Logger mLogger = Logger.getLogger(ValidatorThread.class.getName());
        private static final ObjectName QUIT = JMXUtil.newObjectName("quit:type=quit");
        private final ConcurrentHashMap<ObjectName, JEEMXValidator.ProblemList> mFailures;

        ValidatorThread(MBeanServer server, String validationLevel, boolean unregisterNonCompliant, boolean logInaccessibleAttributes) {
            super("ComplianceMonitor.ValidatorThread");
            this.mServer = server;
            this.mValidationLevel = validationLevel;
            this.mUnregisterNonCompliant = unregisterNonCompliant;
            this.mLogInaccessibleAttributes = logInaccessibleAttributes;
            this.mFailures = new ConcurrentHashMap();
        }

        public Map<ObjectName, JEEMXValidator.ProblemList> getComplianceFailures() {
            return this.mFailures;
        }

        void quit() {
            this.add(QUIT);
        }

        public void add(ObjectName objectName) {
            this.mMBeans.add(objectName);
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                this.mLogger.log(Level.SEVERE, "jeemx.JEEMXComplianceMonitor.threadquit", t);
            }
        }

        protected void doRun() throws InterruptedException {
            while (true) {
                ObjectName next = this.mMBeans.take();
                ArrayList<ObjectName> toValidate = new ArrayList<ObjectName>();
                toValidate.add(next);
                this.mMBeans.drainTo(toValidate);
                if (this.mMBeans.contains(QUIT) || QUIT.equals(next)) break;
                JEEMXValidator validator = new JEEMXValidator(this.mServer, this.mValidationLevel, this.mUnregisterNonCompliant, this.mLogInaccessibleAttributes);
                try {
                    ObjectName[] objectNames = new ObjectName[toValidate.size()];
                    toValidate.toArray(objectNames);
                    JEEMXValidator.ValidationResult result = validator.validate(objectNames);
                    if (result.numFailures() == 0) continue;
                    this.mFailures.putAll(result.failures());
                    this.mComplianceFailures.addAndGet(result.numFailures());
                    this.mLogger.log(Level.FINE, "jeemx.validatingMbean", result.toString());
                }
                catch (Throwable t) {
                    this.mLogger.log(Level.WARNING, "jeemx.exception.validatingMbean", new Object[]{next, t});
                }
            }
        }
    }
}

