/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.mbean;

import com.bes.admin.jeemx.base.BulkAccess;
import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.base.Pathnames;
import com.bes.admin.jeemx.base.Query;
import com.bes.admin.jeemx.base.Sample;
import com.bes.admin.jeemx.base.SystemStatus;
import com.bes.admin.jeemx.base.Tools;
import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.JEEMXValidator;
import com.bes.admin.jeemx.extra.AbstractJEEMXFactory;
import com.bes.admin.jeemx.impl.mbean.BulkAccessImpl;
import com.bes.admin.jeemx.impl.mbean.ComplianceMonitor;
import com.bes.admin.jeemx.impl.mbean.JEEMXImplBase;
import com.bes.admin.jeemx.impl.mbean.MonitoringRootImpl;
import com.bes.admin.jeemx.impl.mbean.PathnamesImpl;
import com.bes.admin.jeemx.impl.mbean.QueryMgrImpl;
import com.bes.admin.jeemx.impl.mbean.SampleImpl;
import com.bes.admin.jeemx.impl.mbean.ToolsImpl;
import com.bes.admin.jeemx.impl.util.ImplUtil;
import com.bes.admin.jeemx.impl.util.Issues;
import com.bes.admin.jeemx.impl.util.ObjectNameBuilder;
import com.bes.admin.jeemx.monitoring.MonitoringRoot;
import com.bes.admin.jeemx.util.CollectionUtil;
import com.bes.admin.jeemx.util.FeatureAvailability;
import com.bes.admin.jeemx.util.MapUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainRootImpl
extends JEEMXImplBase {
    private volatile ComplianceMonitor mCompliance;
    private static Long startTime = System.currentTimeMillis();

    public DomainRootImpl() {
        super(null, DomainRoot.class);
    }

    public void stopDomain() {
        this.getDomainRootProxy().getRuntime().stopDomain();
    }

    public ObjectName getQueryMgr() {
        return this.child(Query.class);
    }

    public ObjectName getJ2EEDomain() {
        return this.child("J2EEDomain");
    }

    public ObjectName getMonitoringRoot() {
        return this.child(MonitoringRoot.class);
    }

    public ObjectName getPathnames() {
        return this.child(Pathnames.class);
    }

    public ObjectName getSystemStatus() {
        return this.child(SystemStatus.class);
    }

    public ObjectName getBulkAccess() {
        return this.child(BulkAccess.class);
    }

    @Override
    protected ObjectName preRegisterHook(MBeanServer server, ObjectName selfObjectName) throws Exception {
        Set<ObjectName> existing = JMXUtil.queryAllInDomain(server, selfObjectName.getDomain());
        if (existing.size() != 0) {
            ImplUtil.getLogger().info("MBeans exist in JEEMX domain prior to DomainRoot (violates Parent requirement): " + CollectionUtil.toString(existing, ", "));
        }
        return selfObjectName;
    }

    @Override
    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
    }

    @Override
    protected void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            this.mCompliance = ComplianceMonitor.getInstance(this.getDomainRootProxy());
            this.mCompliance.start();
        }
    }

    public Map<ObjectName, List<String>> getComplianceFailures() {
        Map<ObjectName, JEEMXValidator.ProblemList> failures = this.mCompliance.getComplianceFailures();
        Map<ObjectName, List<String>> result = MapUtil.newMap();
        for (ObjectName failed : failures.keySet()) {
            JEEMXValidator.ProblemList problems = failures.get(failed);
            result.put(failed, problems.getProblems());
        }
        return result;
    }

    public String getAppserverDomainName() {
        return AbstractJEEMXFactory.getInstance().getAppserverDomainName();
    }

    @Override
    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.getMBeanServer(), self);
        ObjectName childObjectName = null;
        JEEMXImplBase mbean = null;
        MBeanServer server = this.getMBeanServer();
        childObjectName = objectNames.buildChildObjectName(Pathnames.class);
        mbean = new PathnamesImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Query.class);
        mbean = new QueryMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Tools.class);
        mbean = new ToolsImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(BulkAccess.class);
        mbean = new BulkAccessImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Sample.class);
        mbean = new SampleImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(MonitoringRoot.class);
        mbean = new MonitoringRootImpl(self);
        this.registerChild(mbean, childObjectName);
        Class<? extends JEEMXProxy> userExtInf = AbstractJEEMXFactory.getInstance().getUserExtensionInfClass();
        Class<?> userExtClz = AbstractJEEMXFactory.getInstance().getUserExtensionImplClass();
        try {
            if (userExtInf != null && userExtClz != null) {
                childObjectName = objectNames.buildChildObjectName("user-extension", null);
                Constructor<?> constructor = userExtClz.getConstructor(ObjectName.class);
                if (constructor != null) {
                    mbean = constructor.newInstance(self);
                    this.registerChild(mbean, childObjectName);
                }
            }
        }
        catch (Exception e) {
            ImplUtil.getLogger().warning("Failed to register user extension:" + userExtInf.getName() + " ,caused by " + e.getMessage());
        }
    }

    public boolean getJEEMXReady() {
        this.waitJEEMXReady();
        return true;
    }

    public void waitJEEMXReady() {
        FeatureAvailability.getInstance().waitForFeature("JEEMXReady", this.getClass().getName());
    }

    public String getDebugPort() {
        Issues.getJEEMXIssues().notDone("DomainRootImpl.getDebugPort");
        return "9999";
    }

    public String getApplicationServerFullVersion() {
        return AbstractJEEMXFactory.getInstance().getApplicationServerFullVersion();
    }

    public String getInstanceRoot() {
        return AbstractJEEMXFactory.getInstance().getInstanceRoot();
    }

    public String getDomainDir() {
        return AbstractJEEMXFactory.getInstance().getDomainDir();
    }

    public String getConfigDir() {
        return AbstractJEEMXFactory.getInstance().getConfigDir();
    }

    public String getInstallDir() {
        return AbstractJEEMXFactory.getInstance().getInstallDir();
    }

    public Object[] getUptimeMillis() {
        Long elapsed = System.currentTimeMillis() - startTime;
        return new Object[]{elapsed, String.valueOf(elapsed)};
    }
}

