/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.mbean;

import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParentChildren
implements Comparable<ParentChildren> {
    final JEEMXProxy mParent;
    final List<ParentChildren> mChildren;

    public ParentChildren(JEEMXProxy parent, List<ParentChildren> children) {
        this.mParent = parent;
        this.mChildren = children;
    }

    public void sortChildren() {
        Collections.sort(this.mChildren);
    }

    @Override
    public int compareTo(ParentChildren rhs) {
        int cmp = this.mParent.type().compareTo(rhs.mParent.type());
        if (cmp == 0) {
            cmp = this.mParent.nameProp().compareTo(rhs.mParent.nameProp());
        }
        if (cmp == 0) {
            cmp = this.mChildren.size() - rhs.mChildren.size();
        }
        return cmp;
    }

    public JEEMXProxy parent() {
        return this.mParent;
    }

    public List<ParentChildren> children() {
        return this.mChildren;
    }

    public List<String> toLines(boolean details) {
        this.sortChildren();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ParentChildren.descriptionFor(this.mParent));
        for (ParentChildren child : this.mChildren) {
            List<String> moreLines = ParentChildren.indentAll(child.toLines(details));
            lines.addAll(moreLines);
        }
        return lines;
    }

    public List<JEEMXProxy> asList() {
        ArrayList<JEEMXProxy> items = new ArrayList<JEEMXProxy>();
        items.add(this.mParent);
        for (ParentChildren child : this.mChildren) {
            items.addAll(child.asList());
        }
        return items;
    }

    public static ParentChildren hierarchy(JEEMXProxy top) {
        ArrayList<JEEMXProxy> children = new ArrayList<JEEMXProxy>();
        Map<String, Map<String, JEEMXProxy>> childrenMaps = top.childrenMaps();
        for (Map<String, JEEMXProxy> childrenOfType : childrenMaps.values()) {
            for (JEEMXProxy jeemx : childrenOfType.values()) {
                children.add(jeemx);
            }
        }
        ArrayList<ParentChildren> pcList = new ArrayList<ParentChildren>();
        for (JEEMXProxy child : children) {
            ParentChildren pc = ParentChildren.hierarchy(child);
            pcList.add(pc);
        }
        ParentChildren result = new ParentChildren(top, pcList);
        result.sortChildren();
        return result;
    }

    public static String descriptionFor(JEEMXProxy proxy) {
        String desc = proxy.type();
        String name = proxy.nameProp();
        if (name != null) {
            desc = desc + "=" + name;
        }
        return desc;
    }

    private static List<String> indentAll(List<String> lines) {
        ArrayList<String> linesIndented = new ArrayList<String>();
        String INDENT = "   ";
        for (String line : lines) {
            linesIndented.add("   " + line);
        }
        return linesIndented;
    }

    public static String getHierarchyString(JEEMXProxy top) {
        ParentChildren pc = ParentChildren.hierarchy(top);
        return StringUtil.toLines(pc.toLines(true));
    }
}

