/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.mbean;

import com.bes.admin.jeemx.base.Pathnames;
import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.PathnameParser;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.core.proxy.JEEMXProxyHandler;
import com.bes.admin.jeemx.impl.mbean.JEEMXImplBase;
import com.bes.admin.jeemx.impl.util.ImplUtil;
import com.bes.admin.jeemx.util.CollectionUtil;
import com.bes.admin.jeemx.util.ExceptionUtil;
import com.bes.admin.jeemx.util.ListUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.admin.jeemx.util.stringifier.SmartStringifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathnamesImpl
extends JEEMXImplBase {
    private static final int MAX_CACHE_SIZE = 1024;
    private final ConcurrentMap<String, ObjectName> mPathnameCache = new ConcurrentHashMap<String, ObjectName>();

    public PathnamesImpl(ObjectName parentObjectName) {
        super(parentObjectName, Pathnames.class);
    }

    public ObjectName resolvePath(String path) {
        ObjectName result = (ObjectName)this.mPathnameCache.get(path);
        if (result != null) {
            return result;
        }
        if (path.equals("/")) {
            return this.getDomainRoot();
        }
        PathnameParser parser = new PathnameParser(path);
        String parentPath = parser.parentPath();
        String props = Util.makeProp("pp", Util.quoteIfNeeded(parentPath));
        ObjectName pattern = JMXUtil.newObjectNamePattern(this.getObjectName().getDomain(), props);
        Set<ObjectName> s = this.getMBeanServer().queryNames(pattern, null);
        ObjectName objectName = null;
        String type = parser.type();
        String name = parser.name();
        for (ObjectName child : s) {
            boolean singleton;
            if (!type.equals(Util.getTypeProp(child))) continue;
            String nameProp = Util.getNameProp(child);
            if (nameProp == null) {
                if (name != null) continue;
                objectName = child;
                break;
            }
            if (name != null && name.equals(nameProp)) {
                objectName = child;
                break;
            }
            MBeanInfo mbeanInfo = this.getProxyFactory().getMBeanInfo(child);
            if (mbeanInfo == null || !(singleton = JEEMXProxyHandler.singleton(mbeanInfo)) || name != null) continue;
            objectName = child;
            break;
        }
        if (this.mPathnameCache.keySet().size() > 1024) {
            this.mPathnameCache.clear();
        }
        if (objectName != null) {
            this.mPathnameCache.put(path, objectName);
        }
        return objectName;
    }

    private JEEMXProxy resolveToProxy(String path) {
        ObjectName objectName = this.resolvePath(path);
        if (objectName == null) {
            return null;
        }
        return this.getProxyFactory().getProxy(objectName, JEEMXProxy.class);
    }

    public ObjectName[] resolvePaths(String[] paths) {
        ObjectName[] objectNames = new ObjectName[paths.length];
        int i = 0;
        for (String path : paths) {
            try {
                objectNames[i] = this.resolvePath(path);
            }
            catch (Exception e) {
                objectNames[i] = null;
            }
            ++i;
        }
        return objectNames;
    }

    public ObjectName[] ancestors(String path) {
        ObjectName objectName = this.resolvePath(path);
        if (objectName == null) {
            return null;
        }
        return this.ancestors(objectName);
    }

    public ObjectName[] ancestors(ObjectName mbean) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        MBeanServer server = this.getMBeanServer();
        ObjectName cur = mbean;
        while (cur != null) {
            objectNames.add(cur);
            cur = (ObjectName)JMXUtil.getAttribute(server, cur, "Parent");
        }
        List reversed = ListUtil.reverse(objectNames);
        ObjectName[] ancestors = new ObjectName[reversed.size()];
        reversed.toArray(ancestors);
        return ancestors;
    }

    private boolean isInstanceNotFound(Throwable t) {
        return ExceptionUtil.getRootCause(t) instanceof InstanceNotFoundException;
    }

    private void listChildren(JEEMXProxy top, List<JEEMXProxy> list, boolean recursive) {
        Set<JEEMXProxy> children = null;
        try {
            children = top.childrenSet();
            if (children == null) {
                return;
            }
        }
        catch (Exception e) {
            if (!this.isInstanceNotFound(e)) {
                ImplUtil.getLogger().log(Level.WARNING, "Can't get childrenSet() from MBean: " + top.objectName(), ExceptionUtil.getRootCause(e));
            }
            return;
        }
        for (JEEMXProxy child : children) {
            try {
                list.add(child);
                if (!recursive) continue;
                this.listChildren(child, list, true);
            }
            catch (Exception e) {
                if (this.isInstanceNotFound(e)) continue;
                ImplUtil.getLogger().log(Level.WARNING, "Problem with MBean: " + child.objectName(), ExceptionUtil.getRootCause(e));
            }
        }
    }

    private List<JEEMXProxy> listChildren(String path, boolean recursive) {
        JEEMXProxy topProxy = this.resolveToProxy(path);
        if (topProxy == null) {
            return null;
        }
        ArrayList<JEEMXProxy> list = new ArrayList<JEEMXProxy>();
        this.listChildren(topProxy, list, recursive);
        return list;
    }

    public String[] getAllPathnames() {
        try {
            String[] allButRoot = this.listPaths("/", true);
            String[] all = new String[allButRoot.length + 1];
            all[0] = "/";
            System.arraycopy(allButRoot, 0, all, 1, allButRoot.length);
            return all;
        }
        catch (Throwable t) {
            ImplUtil.getLogger().log(Level.WARNING, "PathnamesImpl.getAllPathnames(): unexpected Throwable", ExceptionUtil.getRootCause(t));
            t.printStackTrace();
            return new String[]{"/"};
        }
    }

    public ObjectName[] listObjectNames(String path, boolean recursive) {
        List<JEEMXProxy> list = this.listChildren(path, recursive);
        List<ObjectName> objectNames = Util.toObjectNameList(list);
        return CollectionUtil.toArray(objectNames, ObjectName.class);
    }

    public String[] listPaths(String path, boolean recursive) {
        List<JEEMXProxy> list = this.listChildren(path, recursive);
        ArrayList<String> paths = new ArrayList<String>();
        for (JEEMXProxy jeemx : list) {
            try {
                paths.add(jeemx.path());
            }
            catch (Exception e) {
                ImplUtil.getLogger().log(Level.WARNING, "Can't get path() for MBean: " + jeemx.objectName(), e);
            }
        }
        return CollectionUtil.toArray(paths, String.class);
    }

    public String dump(String path) {
        ObjectName top = this.resolvePath(path);
        if (top == null) {
            return null;
        }
        JEEMXProxy topProxy = this.getProxyFactory().getProxy(top, JEEMXProxy.class);
        ArrayList<JEEMXProxy> list = new ArrayList<JEEMXProxy>();
        list.add(topProxy);
        this.listChildren(topProxy, list, true);
        String NL = "\n";
        StringBuffer buf = new StringBuffer();
        for (JEEMXProxy jeemx : list) {
            String p = jeemx.path();
            buf.append(p);
            buf.append("\n");
            Map<String, Object> attributesMap = jeemx.attributesMap();
            for (String name : attributesMap.keySet()) {
                buf.append("\t");
                buf.append(name);
                buf.append(" = ");
                buf.append("" + SmartStringifier.toString(attributesMap.get(name)));
                buf.append("\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

