/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.mbean;

import com.bes.admin.jeemx.base.Sample;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.impl.mbean.JEEMXImplBase;
import com.bes.admin.jeemx.util.CollectionUtil;
import com.bes.admin.jeemx.util.ListUtil;
import com.bes.admin.jeemx.util.MapUtil;
import com.bes.admin.jeemx.util.OpenMBeanUtil;
import com.bes.admin.jeemx.util.SetUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class SampleImpl
extends JEEMXImplBase {
    private final Map<String, Serializable> mAttributes = Collections.synchronizedMap(new HashMap());
    private MBeanInfo mExtendedMBeanInfo = null;
    private static final int MEGABYTE = 0x100000;

    public void emitNotifications(Serializable data, int numNotifs, long interval) {
        if (numNotifs <= 0) {
            throw new IllegalArgumentException("" + numNotifs);
        }
        new EmitterThread(data, numNotifs, interval).start();
    }

    public SampleImpl(ObjectName parentObjectName) {
        super(parentObjectName, Sample.class);
    }

    public void addAttribute(String name, Serializable value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.mAttributes.remove(name);
        this.mExtendedMBeanInfo = null;
    }

    private synchronized MBeanInfo createMBeanInfo(MBeanInfo baseMBeanInfo) {
        MBeanAttributeInfo[] dynamicAttrInfos = new MBeanAttributeInfo[this.mAttributes.keySet().size()];
        int i = 0;
        for (String name : this.mAttributes.keySet()) {
            Serializable value = this.mAttributes.get(name);
            String type = value == null ? String.class.getName() : value.getClass().getName();
            dynamicAttrInfos[i] = new MBeanAttributeInfo(name, type, "dynamically-added Attribute", true, true, false);
            ++i;
        }
        MBeanAttributeInfo[] attrInfos = JMXUtil.mergeMBeanAttributeInfos(dynamicAttrInfos, baseMBeanInfo.getAttributes());
        return JMXUtil.newMBeanInfo(baseMBeanInfo, attrInfos);
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mExtendedMBeanInfo == null) {
            this.mExtendedMBeanInfo = this.createMBeanInfo(super.getMBeanInfo());
        }
        return this.mExtendedMBeanInfo;
    }

    protected Serializable getAttributeManually(String name) {
        if (!this.mAttributes.containsKey(name)) {
            throw new RuntimeException(new AttributeNotFoundException(name));
        }
        return this.mAttributes.get(name);
    }

    protected void setAttributeManually(Attribute attr) {
        this.mAttributes.put(attr.getName(), (Serializable)Serializable.class.cast(attr.getValue()));
    }

    public void uploadBytes(byte[] bytes) {
    }

    public byte[] downloadBytes(int numBytes) {
        if (numBytes < 0 || numBytes > 0xA00000) {
            throw new IllegalArgumentException("Illegal count: " + numBytes);
        }
        byte[] bytes = new byte[numBytes];
        return bytes;
    }

    public ObjectName[] getAllJEEMX() {
        List<ObjectName> all = Util.toObjectNameList(this.getDomainRootProxy().getQueryMgr().queryAll());
        return CollectionUtil.toArray(all, ObjectName.class);
    }

    public Object[] getAllSortsOfStuff() {
        List stuff = ListUtil.newList();
        Map<String, Object> values = MapUtil.newMap();
        values.put("ByteField", new Byte(0));
        values.put("ShortField", new Short(0));
        values.put("IntegerField", new Integer(0));
        values.put("LongField", new Long(0L));
        values.put("FloatField", new Float(0.0));
        values.put("DoubleField", new Double(0.0));
        values.put("BigDecimalField", new BigDecimal("999999999999999999999999999999.999999999999999999999999999999"));
        values.put("BigIntegerField", new BigInteger("999999999999999999999999999999999999999999999999999999999999"));
        values.put("CharacterField", Character.valueOf('x'));
        values.put("StringField", "hello");
        values.put("BooleanField", true);
        values.put("DateField", new Date());
        values.put("ObjectNameField", this.getObjectName());
        CompositeData data = null;
        try {
            data = OpenMBeanUtil.mapToCompositeData("com.bes.test.Sample1", "test", values);
            stuff.add(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        stuff.add(data);
        stuff.addAll(values.values());
        stuff.add(MapUtil.newMap());
        stuff.add(ListUtil.newList());
        stuff.add(SetUtil.newSet());
        TabularDataSupport table = null;
        try {
            String[] indexNames = CollectionUtil.toArray(values.keySet(), String.class);
            CompositeType rowType = data.getCompositeType();
            TabularType tabularType = new TabularType("com.bes.test.Sample2", "test", rowType, indexNames);
            table = new TabularDataSupport(tabularType);
            table.put(data);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        stuff.add(table);
        Object[] result = CollectionUtil.toArray(stuff, Object.class);
        return result;
    }

    private final class EmitterThread
    extends Thread {
        private final Serializable mData;
        private final int mNumNotifs;
        private final long mIntervalMillis;

        public EmitterThread(Serializable data, int numNotifs, long intervalMillis) {
            this.mData = data;
            this.mNumNotifs = numNotifs;
            this.mIntervalMillis = intervalMillis;
        }

        public void run() {
            for (int i = 0; i < this.mNumNotifs; ++i) {
                SampleImpl.this.sendNotification("Sample", "UserData", this.mData);
                try {
                    Thread.sleep(this.mIntervalMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

