/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.util;

import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ImplUtil {
    private static void debug(String s) {
        System.out.println(s);
    }

    public static Logger getLogger() {
        return Logger.getLogger(ImplUtil.class.getName());
    }

    public static void unregisterJEEMXMBeans(JEEMXProxy top) {
        if (top == null) {
            throw new IllegalArgumentException();
        }
        MBeanServer mbeanServer = (MBeanServer)top.extra().mbeanServerConnection();
        Set<JEEMXProxy> children = top.extra().childrenSet();
        if (children != null) {
            for (JEEMXProxy jeemx : children) {
                ImplUtil.unregisterJEEMXMBeans(jeemx);
            }
        }
        ImplUtil.unregisterOneMBean(mbeanServer, top.objectName());
    }

    public static void unregisterJEEMXMBeans(MBeanServer mbs, ObjectName objectName) {
        ImplUtil.unregisterJEEMXMBeans(ProxyFactory.getInstance(mbs).getProxy(objectName, JEEMXProxy.class));
    }

    public static boolean unregisterOneMBean(MBeanServer mbeanServer, ObjectName objectName) {
        boolean success = false;
        try {
            mbeanServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }
}

