/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.impl.util;

import com.bes.admin.jeemx.core.JEEMXProxy;
import com.bes.admin.jeemx.core.Util;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.admin.jeemx.util.stringifier.SmartStringifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectNameBuilder {
    private final MBeanServer mMBeanServer;
    private final String mJMXDomain;
    private final ObjectName mParent;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public ObjectNameBuilder(MBeanServer mbeanServer, String jmxDomain) {
        this.mMBeanServer = mbeanServer;
        this.mJMXDomain = jmxDomain;
        this.mParent = null;
    }

    public ObjectNameBuilder(MBeanServer mbeanServer, ObjectName parent) {
        this.mMBeanServer = mbeanServer;
        if (parent == null) {
            throw new IllegalArgumentException("Null ObjecName for parent");
        }
        this.mParent = parent;
        this.mJMXDomain = parent.getDomain();
    }

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    public String getJMXDomain() {
        return this.mJMXDomain;
    }

    private ObjectName newObjectName(String props) {
        return Util.newObjectName(this.getJMXDomain(), props);
    }

    public static String makeWild(String props) {
        return Util.concatenateProps(props, ",*");
    }

    public static List<ObjectName> getAncestors(MBeanServer server, ObjectName start) {
        JEEMXProxy jeemx = ProxyFactory.getInstance(server).getProxy(start, JEEMXProxy.class);
        ArrayList<ObjectName> ancestors = new ArrayList<ObjectName>();
        JEEMXProxy parent = null;
        while ((parent = jeemx.parent()) != null) {
            ancestors.add(parent.extra().objectName());
            jeemx = parent;
        }
        Collections.reverse(ancestors);
        ancestors.add(start);
        return ancestors;
    }

    public ObjectName buildChildObjectName(ObjectName parent, String type, String childName) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, parent, type, childName);
    }

    public ObjectName buildChildObjectName(String type, String childName) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.mParent, type, childName);
    }

    public ObjectName buildChildObjectName(Class<?> intf) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.mParent, intf);
    }

    public ObjectName buildChildObjectName(Class<?> intf, String name) {
        return ObjectNameBuilder.buildChildObjectName(this.mMBeanServer, this.mParent, intf, name);
    }

    public static ObjectName buildChildObjectName(MBeanServer server, ObjectName parent, String type, String childName) {
        String props = Util.makeRequiredProps(type, childName);
        JEEMXProxy parentProxy = ProxyFactory.getInstance(server).getProxy(parent, JEEMXProxy.class);
        String parentPath = parentProxy.path();
        String parentPathProp = Util.makeProp("pp", Util.quoteIfNeeded(parentPath));
        props = Util.concatenateProps(parentPathProp, props);
        return JMXUtil.newObjectName(parent.getDomain(), props);
    }

    public static ObjectName buildChildObjectName(MBeanServer server, ObjectName parent, Class<?> intf, String name) {
        String type = Util.deduceType(intf);
        return ObjectNameBuilder.buildChildObjectName(server, parent, type, name);
    }

    public static ObjectName buildChildObjectName(MBeanServer server, ObjectName parent, Class<?> intf) {
        return ObjectNameBuilder.buildChildObjectName(server, parent, intf, null);
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }
}

