/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.intf.config;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public class JEEMXConfigHelper {
    private final JEEMXConfigProxy mJEEMX;

    public JEEMXConfigHelper(JEEMXConfigProxy jeemx) {
        this.mJEEMX = jeemx;
    }

    public Set<String> attributeNamesByDescriptorField(String fieldName, String value) {
        HashSet<String> attrNames = new HashSet<String>();
        for (MBeanAttributeInfo attrInfo : this.mJEEMX.extra().mbeanInfo().getAttributes()) {
            Descriptor desc = attrInfo.getDescriptor();
            if (!value.equals(desc.getFieldValue(fieldName))) continue;
            attrNames.add(attrInfo.getName());
        }
        return attrNames;
    }

    public Set<String> simpleAttributes() {
        String elementKind = "element";
        Set<String> elementNames = this.attributeNamesByDescriptorField("jeemx.configbean.kind", "element");
        Set<String> remaining = this.mJEEMX.attributeNames();
        remaining.removeAll(elementNames);
        return remaining;
    }

    public Map<String, Object> simpleAttributesMap() {
        return this.mJEEMX.attributesMap(this.simpleAttributes());
    }

    public final Descriptor attributeDescriptor(String attrName) {
        MBeanAttributeInfo info = this.mJEEMX.extra().attributeInfo(attrName);
        return info == null ? null : info.getDescriptor();
    }

    public final Object attributeDescriptorField(String attrName, String fieldName) {
        Descriptor desc = this.attributeDescriptor(attrName);
        return desc == null ? null : desc.getFieldValue(fieldName);
    }

    public String units(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "jeemx.configbean.units");
    }

    public Long min(String attrName) {
        return (Long)this.attributeDescriptorField(attrName, "jeemx.configbean.min");
    }

    public Long max(String attrName) {
        return (Long)this.attributeDescriptorField(attrName, "jeemx.configbean.max");
    }

    public String dataType(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "jeemx.configbean.dataType");
    }

    public String regexPattern(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "jeemx.configbean.pattern");
    }

    public boolean key(String attrName) {
        return Boolean.parseBoolean("" + this.attributeDescriptorField(attrName, "jeemx.configbean.key"));
    }

    public boolean notNull(String attrName) {
        return Boolean.parseBoolean("" + this.attributeDescriptorField(attrName, "jeemx.configbean.notNull"));
    }

    public Boolean required(String attrName) {
        return this.notNull(attrName) || this.key(attrName) || Boolean.parseBoolean("" + this.attributeDescriptorField(attrName, "jeemx.configbean.required"));
    }

    public String xmlName(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "jeemx.configbean.xmlName");
    }

    public String defaultValue(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "jeemx.configbean.defaultValue");
    }
}

