/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.logging;

import com.bes.admin.jeemx.logging.LogQueryEntry;
import com.bes.admin.jeemx.logging.LogQueryEntryImpl;
import com.bes.admin.jeemx.logging.LogQueryResult;
import com.bes.admin.jeemx.util.ArrayUtil;
import com.bes.admin.jeemx.util.ObjectUtil;
import com.bes.external.arc.Stability;
import com.bes.external.arc.Taxonomy;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.EXPERIMENTAL)
public final class LogQueryResultImpl
implements LogQueryResult {
    private String[] mFieldNames;
    private LogQueryEntry[] mEntries;
    private static final String FIELD_DELIM = "\t";
    private static final String NEWLINE = System.getProperty("line.separator");

    public LogQueryResultImpl(String[] fieldNames, LogQueryEntry[] entries) {
        this.mFieldNames = fieldNames;
        this.mEntries = entries;
    }

    public LogQueryResultImpl(List<Serializable[]> records) {
        this.mFieldNames = (String[])records.get(0);
        this.mEntries = new LogQueryEntry[records.size() - 1];
        for (int i = 0; i < this.mEntries.length; ++i) {
            this.mEntries[i] = new LogQueryEntryImpl(records.get(i + 1));
        }
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    @Override
    public LogQueryEntry[] getEntries() {
        return this.mEntries;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.getFieldNames()) {
            builder.append(s);
            builder.append(FIELD_DELIM);
        }
        builder.replace(builder.length() - 1, builder.length(), NEWLINE);
        for (LogQueryEntry entry : this.getEntries()) {
            Object[] fields;
            for (Object o : fields = entry.getFields()) {
                builder.append(o.toString());
                builder.append(FIELD_DELIM);
            }
            builder.replace(builder.length() - 1, builder.length(), NEWLINE);
        }
        return builder.toString();
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.getFieldNames(), this.getEntries());
    }

    public boolean equals(Object rhs) {
        boolean equal = rhs instanceof LogQueryResult;
        if (equal) {
            LogQueryResult r = (LogQueryResult)rhs;
            equal = ArrayUtil.arraysEqual(this.getFieldNames(), r.getFieldNames()) && ArrayUtil.arraysEqual(this.getEntries(), r.getEntries());
        }
        return equal;
    }
}

