/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util;

import com.bes.admin.jeemx.util.ClassUtil;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayConversion {
    private ArrayConversion() {
    }

    private static Object[] convert(Object simpleArray) {
        if (!ClassUtil.objectIsPrimitiveArray(simpleArray)) {
            throw new IllegalArgumentException();
        }
        String className = simpleArray.getClass().getName();
        Class theClass = ClassUtil.getArrayElementClass(simpleArray.getClass());
        int numItems = Array.getLength(simpleArray);
        Class elementClass = ClassUtil.PrimitiveClassToObjectClass(theClass);
        Object[] result = (Object[])Array.newInstance(elementClass, numItems);
        for (int i = 0; i < numItems; ++i) {
            result[i] = Array.get(simpleArray, i);
        }
        return result;
    }

    public static Object[] toAppropriateType(Object array) {
        return ArrayConversion.convert(array);
    }

    public static Boolean[] toBooleans(boolean[] array) {
        return (Boolean[])ArrayConversion.convert(array);
    }

    public static Character[] toCharacters(char[] array) {
        return (Character[])ArrayConversion.convert(array);
    }

    public static Byte[] toBytes(byte[] array) {
        return (Byte[])ArrayConversion.convert(array);
    }

    public static Short[] toShorts(short[] array) {
        return (Short[])ArrayConversion.convert(array);
    }

    public static Integer[] toIntegers(int[] array) {
        return (Integer[])ArrayConversion.convert(array);
    }

    public static Long[] toLongs(long[] array) {
        return (Long[])ArrayConversion.convert(array);
    }

    public static Float[] toFloats(float[] array) {
        return (Float[])ArrayConversion.convert(array);
    }

    public static Double[] toDoubles(double[] array) {
        return (Double[])ArrayConversion.convert(array);
    }

    public static Object[] createObjectArrayType(Class elementType, int size) {
        Object[] result = (Object[])Array.newInstance(elementType, size);
        return result;
    }

    public static Object[] subArray(Object[] in, int start, int end) {
        int count = 1 + (end - start);
        Object[] result = (Object[])Array.newInstance(ClassUtil.getArrayElementClass(in.getClass()), count);
        for (int i = 0; i < count; ++i) {
            result[i] = in[i + start];
        }
        return result;
    }

    public static <T> Set<T> toSet(T[] array) {
        Set theSet = null;
        if (array.length == 0) {
            theSet = Collections.emptySet();
        } else if (array.length == 1) {
            theSet = Collections.singleton(array[0]);
        } else {
            theSet = new HashSet();
            for (int i = 0; i < array.length; ++i) {
                theSet.add(array[i]);
            }
        }
        return theSet;
    }

    public static boolean hasIdenticalElementClasses(Object[] a) {
        boolean isUniform = true;
        if (a.length > 0) {
            Class<?> matchType = a[0].getClass();
            for (int i = 1; i < a.length; ++i) {
                if (a[i].getClass() == matchType) continue;
                isUniform = false;
                break;
            }
        }
        return isUniform;
    }

    public static Object[] specializeArray(Object[] a) {
        Object[] result = a;
        if (ArrayConversion.hasIdenticalElementClasses(a) && a.length != 0 && a.getClass() == Object[].class) {
            result = ArrayConversion.createObjectArrayType(a[0].getClass(), a.length);
            System.arraycopy(a, 0, result, 0, a.length);
        }
        return result;
    }

    public static Object[] setToArray(Set<?> s, boolean specialize) {
        Object[] result = ArrayConversion.setToArray(s);
        if (specialize && result.length != 0) {
            result = ArrayConversion.specializeArray(result);
        }
        return result;
    }

    public static Object[] setToArray(Set<?> s) {
        Object[] out = new Object[s.size()];
        ArrayConversion.setToArray(s, out);
        return out;
    }

    public static Object[] setToArray(Set<?> s, Object[] out) {
        if (out.length != s.size()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        for (Object o : s) {
            out[i] = o;
            ++i;
        }
        return out;
    }

    public static <T> Set<T> arrayToSet(T[] names) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < names.length; ++i) {
            set.add(names[i]);
        }
        return set;
    }
}

