/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util;

import com.bes.admin.jeemx.util.DebugOut;
import com.bes.admin.jeemx.util.DebugSink;
import com.bes.admin.jeemx.util.DebugSinkImpl;
import com.bes.admin.jeemx.util.StringUtil;

public class DebugOutImpl
implements DebugOut {
    private final String mID;
    private boolean mDebug;
    private DebugSink mSink;

    public DebugOutImpl(String id, boolean debug, DebugSink sink) {
        this.mID = id;
        this.mDebug = debug;
        this.mSink = sink == null ? new DebugSinkImpl(System.out) : sink;
    }

    public DebugOutImpl(String id, boolean debug) {
        this(id, debug, null);
    }

    public String getID() {
        return this.mID;
    }

    public boolean getDebug() {
        return this.mDebug;
    }

    public void print(Object o) {
        this.mSink.print("" + o);
    }

    public void println(Object o) {
        this.mSink.println("" + o);
    }

    public String toString(Object ... args) {
        return StringUtil.toString(", ", args);
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public void debug(Object ... args) {
        if (this.getDebug()) {
            this.mSink.println(this.toString(args));
        }
    }

    public void debugMethod(String methodName, Object ... args) {
        if (this.getDebug()) {
            this.debug(DebugOutImpl.methodString(methodName, args));
        }
    }

    public void debugMethod(String msg, String methodName, Object ... args) {
        if (this.getDebug()) {
            this.debug(DebugOutImpl.methodString(methodName, args) + ": " + msg);
        }
    }

    public static String methodString(String name, Object ... args) {
        String result = null;
        if (args == null || args.length == 0) {
            result = name + "()";
        } else {
            String argsString = StringUtil.toString(", ", args);
            result = StringUtil.toString("", name, "(", argsString, ")");
        }
        return result;
    }
}

