/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util;

import com.bes.admin.jeemx.util.Output;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public final class FileOutput
implements Output {
    private PrintStream mOut = null;
    private final File mFile;
    private final boolean mAppend;

    public FileOutput(File f) {
        this(f, false);
    }

    public FileOutput(File f, boolean append) {
        this.mFile = f;
        this.mAppend = append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.mOut == null) {
            FileOutput fileOutput = this;
            synchronized (fileOutput) {
                if (this.mOut == null) {
                    try {
                        if (!this.mAppend && this.mFile.exists()) {
                            this.mFile.delete();
                        }
                        this.mOut = new PrintStream(new FileOutputStream(this.mFile, this.mAppend));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Can't create file: " + this.mFile + ", exception = " + e);
                    }
                }
            }
        }
    }

    public void print(Object o) {
        this.lazyInit();
        this.mOut.print(o.toString());
    }

    public void println(Object o) {
        this.lazyInit();
        this.mOut.println(o.toString());
    }

    public void printError(Object o) {
        this.lazyInit();
        this.println("ERROR: " + o);
    }

    public boolean getDebug() {
        this.lazyInit();
        return false;
    }

    public void printDebug(Object o) {
        this.lazyInit();
        this.println("DEBUG: " + o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mOut != null) {
            try {
                this.mOut.close();
            }
            finally {
                this.mOut = null;
            }
        }
    }
}

