/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util;

import com.bes.admin.jeemx.util.JEEMXDebug;
import com.bes.admin.jeemx.util.Output;
import com.bes.admin.jeemx.util.StringUtil;

public final class JEEMXDebugHelper {
    private final Output mOutput;
    private final String mName;
    volatile boolean mEchoToStdOut;

    public JEEMXDebugHelper(String name) {
        this.mOutput = JEEMXDebug.getInstance().getOutput(name);
        this.mName = name;
        this.mEchoToStdOut = false;
    }

    public JEEMXDebugHelper() {
        this("debug");
    }

    public boolean getEchoToStdOut(boolean echo) {
        return this.mEchoToStdOut;
    }

    public void setEchoToStdOut(boolean echo) {
        this.mEchoToStdOut = echo;
    }

    public boolean getDebug() {
        return JEEMXDebug.getInstance().getDebug(this.mName);
    }

    public void setDebug(boolean debug) {
        JEEMXDebug.getInstance().setDebug(this.mName, debug);
    }

    private void printlnWithTime(String s) {
        long now = System.currentTimeMillis();
        String msg = now + ": " + s;
        this.mOutput.println(msg);
        if (this.mEchoToStdOut) {
            System.out.println(msg);
        }
    }

    public void println(Object o) {
        if (this.getDebug()) {
            this.printlnWithTime("" + StringUtil.toString(o));
        }
    }

    public void println() {
        this.println((Object)"");
    }

    public void println(Object ... items) {
        if (this.getDebug() && items != null) {
            String msg = null;
            msg = items.length == 1 ? StringUtil.toString(items[0]) : StringUtil.toString("", items);
            this.printlnWithTime(msg);
        }
    }

    public void dumpStack(String msg) {
        if (this.getDebug()) {
            this.println();
            this.println((Object)("STACK DUMP FOLLOWS: " + msg));
            this.println((Object)StringUtil.toString(new Exception("not a real exception")));
            this.println();
        }
    }
}

