/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetUtil {
    private SetUtil() {
    }

    public static <T> T getSingleton(Set<T> s) {
        if (s.size() != 1) {
            throw new IllegalArgumentException(s.toString());
        }
        return s.iterator().next();
    }

    public static <T> void addArray(Set<T> set, T[] array) {
        for (T item : array) {
            set.add(item);
        }
    }

    public static <T> Set<T> newSet() {
        return new HashSet();
    }

    public static <T> Set<T> newSet(Collection<T> c) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(c);
        return set;
    }

    public static <T> Set<T> newSet(T item) {
        HashSet<T> set = new HashSet<T>();
        set.add(item);
        return set;
    }

    public static <T> HashSet<T> copySet(Set<? extends T> s1) {
        HashSet<? extends T> set = new HashSet<T>();
        set.addAll(s1);
        return set;
    }

    public static <T> Set<? extends T> newSet(T m1, T m2) {
        HashSet<T> set = new HashSet<T>();
        set.add(m1);
        set.add(m2);
        return set;
    }

    public static <T> Set<T> newSet(T m1, T m2, T m3, T m4) {
        HashSet<T> set = new HashSet<T>();
        set.add(m1);
        set.add(m2);
        set.add(m3);
        set.add(m4);
        return set;
    }

    public static <T> Set<T> newSet(T[] objects) {
        return SetUtil.newSet(objects, 0, objects.length);
    }

    public static <T, TT extends T> Set<T> newSet(Set<T> s1, Set<TT> s2) {
        HashSet<Object> both = new HashSet<Object>();
        both.addAll(s1);
        both.addAll(s2);
        return both;
    }

    public static <T> Set<T> newSet(T[] objects, int startIndex, int numItems) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < numItems; ++i) {
            set.add(objects[startIndex + i]);
        }
        return set;
    }

    public static String[] toStringArray(Set<?> s) {
        String[] strings = new String[s.size()];
        int i = 0;
        for (Object o : s) {
            strings[i] = "" + o;
            ++i;
        }
        return strings;
    }

    public static String[] toSortedStringArray(Set<?> s) {
        Object[] strings = SetUtil.toStringArray(s);
        Arrays.sort(strings);
        return strings;
    }

    public static Set<String> newStringSet(String ... args) {
        return SetUtil.newUnmodifiableSet(args);
    }

    public static <T> Set<T> newUnmodifiableSet(T ... args) {
        HashSet<T> set = new HashSet<T>();
        for (T s : args) {
            set.add(s);
        }
        return set;
    }

    public static Set<String> newUnmodifiableStringSet(String ... args) {
        return Collections.unmodifiableSet(SetUtil.newStringSet(args));
    }

    public static <T> Set<T> newTypedSet(T ... args) {
        HashSet<T> set = new HashSet<T>();
        for (T o : args) {
            set.add(o);
        }
        return set;
    }

    public static <T> Set<T> newSingletonSet(T m1) {
        HashSet<T> set = new HashSet<T>();
        set.add(m1);
        return set;
    }

    public static <T> Set<T> intersectSets(Set<T> set1, Set<T> set2) {
        Set<Set<T>> result = SetUtil.newSet(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> Set<T> removeSet(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(set1);
        result.removeAll(set2);
        return result;
    }

    public static <T> Set<T> newNotCommonSet(Set<T> set1, Set<T> set2) {
        Set<T> result = SetUtil.newSet(set1, set2);
        Set<T> common = SetUtil.intersectSets(set1, set2);
        result.removeAll(common);
        return result;
    }

    public static String findIgnoreCase(Set<String> candidates, String target) {
        String match = null;
        for (String candidate : candidates) {
            if (!candidate.equalsIgnoreCase(target)) continue;
            match = candidate;
            break;
        }
        return match;
    }
}

