/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util.jmx;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseableRMIServerSocketFactory
implements RMIServerSocketFactory,
Closeable {
    private static final Logger logger = Logger.getLogger(CloseableRMIServerSocketFactory.class.getName());
    private Map<Socket, Object> incomingSockets = new WeakHashMap<Socket, Object>();
    private int backlog = 5;
    private InetAddress bindAddress = null;

    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.bindAddress != null) {
            return new ServerSocket(port, this.backlog, this.bindAddress){

                public Socket accept() throws IOException {
                    Socket accept = super.accept();
                    CloseableRMIServerSocketFactory.this.addIncomingSocket(accept);
                    return accept;
                }
            };
        }
        return new ServerSocket(port, this.backlog){

            public Socket accept() throws IOException {
                Socket accept = super.accept();
                CloseableRMIServerSocketFactory.this.addIncomingSocket(accept);
                return accept;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Map<Socket, Object> map = this.incomingSockets;
        synchronized (map) {
            Iterator<Socket> it = this.incomingSockets.keySet().iterator();
            while (it.hasNext()) {
                Socket next = it.next();
                if (next.isClosed()) continue;
                try {
                    next.close();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to close rmi socket, caused by:", e);
                }
                it.remove();
            }
            this.incomingSockets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIncomingSocket(Socket socket) {
        Map<Socket, Object> map = this.incomingSockets;
        synchronized (map) {
            Iterator<Socket> it = this.incomingSockets.keySet().iterator();
            while (it.hasNext()) {
                Socket next = it.next();
                if (!next.isClosed()) continue;
                it.remove();
            }
            this.incomingSockets.put(socket, null);
        }
    }

    public InetAddress getBindAdress() {
        return this.bindAddress;
    }

    public void setBindAdress(InetAddress bindAdress) {
        this.bindAddress = bindAdress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CloseableRMIServerSocketFactory)) {
            return false;
        }
        CloseableRMIServerSocketFactory factory = (CloseableRMIServerSocketFactory)obj;
        boolean eq = this.backlog == factory.backlog;
        eq = eq && (this.bindAddress == null && factory.bindAddress == null || this.bindAddress != null && this.bindAddress.equals(factory.bindAddress));
        return eq;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.backlog;
        if (this.bindAddress != null) {
            result = result * 31 + this.bindAddress.hashCode();
        }
        return result;
    }
}

