/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util.jmx;

import com.bes.admin.jeemx.util.jmx.JMXUtil;
import com.bes.admin.jeemx.util.jmx.NotificationListenerBase;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;

public abstract class MBeanRegistrationListener
extends NotificationListenerBase {
    private final ObjectName mRegUnregFilter;
    private final String mDefaultDomain;

    protected MBeanRegistrationListener(String name, MBeanServerConnection conn, ObjectName constrain) throws IOException {
        super(name, conn, JMXUtil.getMBeanServerDelegateObjectName());
        this.mRegUnregFilter = constrain;
        this.mDefaultDomain = conn.getDefaultDomain();
    }

    protected MBeanRegistrationListener(String name, MBeanServerConnection conn) throws IOException {
        this(name, conn, null);
    }

    protected abstract void mbeanRegistered(ObjectName var1);

    protected abstract void mbeanUnregistered(ObjectName var1);

    public void handleNotification(Notification notifIn, Object handback) {
        boolean matchesFilter;
        if (!(notifIn instanceof MBeanServerNotification)) {
            throw new IllegalArgumentException(notifIn.toString());
        }
        MBeanServerNotification notif = (MBeanServerNotification)notifIn;
        ObjectName objectName = notif.getMBeanName();
        String type = notif.getType();
        boolean bl = matchesFilter = this.mRegUnregFilter == null || JMXUtil.matchesPattern(this.mDefaultDomain, this.mRegUnregFilter, objectName);
        if (matchesFilter) {
            if (type.equals("JMX.mbean.registered")) {
                this.mbeanRegistered(objectName);
            } else if (type.equals("JMX.mbean.unregistered")) {
                this.mbeanUnregistered(objectName);
            }
        }
    }
}

