/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util.jmx;

import com.bes.admin.jeemx.util.SetUtil;
import com.bes.admin.jeemx.util.jmx.JMXUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotificationListenerBase
implements NotificationListener {
    private final String mName;
    private final MBeanServerConnection mConn;
    private final Set<ObjectName> mListenees;
    private final ObjectName mPattern;
    private final NotificationFilter mFilter;
    private final Object mHandback;
    private RegistrationListener mDelegateListener;
    private volatile boolean mSetupListening;

    protected NotificationListenerBase(String name, MBeanServerConnection conn, ObjectName pattern) throws IOException {
        this(name, conn, pattern, null);
    }

    protected NotificationListenerBase(String name, MBeanServerConnection conn, ObjectName pattern, NotificationFilter filter) throws IOException {
        this.mName = name;
        this.mConn = conn;
        this.mPattern = pattern;
        this.mFilter = filter;
        this.mHandback = null;
        this.mDelegateListener = null;
        this.mSetupListening = false;
        this.mListenees = Collections.synchronizedSet(new HashSet());
        if (!conn.isRegistered(JMXUtil.getMBeanServerDelegateObjectName())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public abstract void handleNotification(Notification var1, Object var2);

    protected synchronized void listenToMBean(ObjectName objectName) throws InstanceNotFoundException, IOException {
        if (!this.mListenees.contains(objectName)) {
            this.mListenees.add(objectName);
            this.getMBeanServerConnection().addNotificationListener(objectName, this, this.mFilter, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startListening() throws InstanceNotFoundException, IOException {
        if (this.mSetupListening) {
            throw new IllegalStateException("setupListening() must be called exactly once");
        }
        if (this.mPattern.isPattern()) {
            this.mDelegateListener = new RegistrationListener();
            JMXUtil.listenToMBeanServerDelegate(this.mConn, this.mDelegateListener, null, null);
        }
        Set<ObjectName> s = null;
        s = this.mPattern.isPattern() ? JMXUtil.queryNames(this.getConn(), this.mPattern, null) : SetUtil.newSet(this.mPattern);
        NotificationListenerBase notificationListenerBase = this;
        synchronized (notificationListenerBase) {
            for (ObjectName objectName : s) {
                this.listenToMBean(objectName);
            }
        }
        this.mSetupListening = true;
    }

    public final NotificationFilter getNotificationFilter(ObjectName objectName) {
        return this.mFilter;
    }

    protected synchronized void listenToIfMatch(ObjectName objectName) throws IOException, InstanceNotFoundException {
        String defaultDomain;
        if (!this.mListenees.contains(objectName) && JMXUtil.matchesPattern(defaultDomain = this.getConn().getDefaultDomain(), this.mPattern, objectName)) {
            this.listenToMBean(objectName);
        }
    }

    public synchronized void cleanup() {
        try {
            if (this.mDelegateListener != null) {
                this.getConn().removeNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this.mDelegateListener, null, null);
                this.mDelegateListener = null;
            }
            for (ObjectName objectName : this.mListenees) {
                this.getConn().removeNotificationListener(objectName, this, this.mFilter, null);
            }
        }
        catch (JMException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mListenees.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<ObjectName> getListenees() {
        HashSet<ObjectName> objectNames = new HashSet<ObjectName>();
        Set<ObjectName> set = this.mListenees;
        synchronized (set) {
            objectNames.addAll(this.mListenees);
        }
        return objectNames;
    }

    public final MBeanServerConnection getMBeanServerConnection() {
        return this.getConn();
    }

    protected final MBeanServerConnection getConn() {
        return this.mConn;
    }

    protected final void checkAlive() throws IOException {
        if (!this.isAlive()) {
            throw new IOException("MBeanServerConnection failed");
        }
    }

    public boolean isAlive() {
        boolean isAlive = true;
        if (!(this.mConn instanceof MBeanServer)) {
            try {
                this.mConn.isRegistered(JMXUtil.getMBeanServerDelegateObjectName());
            }
            catch (Exception e) {
                isAlive = false;
            }
        }
        return isAlive;
    }

    private final class RegistrationListener
    implements NotificationListener {
        public void handleNotification(Notification notifIn, Object handback) {
            if (notifIn instanceof MBeanServerNotification) {
                MBeanServerNotification notif = (MBeanServerNotification)notifIn;
                ObjectName objectName = notif.getMBeanName();
                String type = notif.getType();
                try {
                    if (type.equals("JMX.mbean.registered")) {
                        NotificationListenerBase.this.listenToIfMatch(objectName);
                    } else if (type.equals("JMX.mbean.unregistered")) {
                        NotificationListenerBase.this.mListenees.remove(objectName);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

