/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util.jmx;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMISocketFactory;

public class TimeoutRMISocketFactory
extends RMISocketFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JMX_RMI_CLIENT_TIMEOUT = "com.bes.mq.jmx.rmi.client.timeout";
    private int timeout = Integer.valueOf(System.getProperty("com.bes.mq.jmx.rmi.client.timeout", "5000"));
    private int backlog = 5;
    private InetAddress bindAddress = null;

    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.bindAddress != null) {
            return new ServerSocket(port, this.backlog, this.bindAddress);
        }
        return new ServerSocket(port, this.backlog);
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket(host, port);
        try {
            socket.setSoTimeout(this.timeout);
        }
        catch (SocketException e) {
            // empty catch block
        }
        return socket;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeoutRMISocketFactory)) {
            return false;
        }
        TimeoutRMISocketFactory mqFactory = (TimeoutRMISocketFactory)obj;
        boolean eq = this.timeout == mqFactory.timeout;
        eq = eq && this.backlog == mqFactory.backlog;
        eq = eq && (this.bindAddress == null && mqFactory.bindAddress == null || this.bindAddress != null && this.bindAddress.equals(mqFactory.bindAddress));
        return eq;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + this.timeout;
        result = result * 31 + this.backlog;
        if (this.bindAddress != null) {
            result = result * 31 + this.bindAddress.hashCode();
        }
        return result;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout > 0) {
            this.timeout = timeout;
        }
    }

    public InetAddress getBindAdress() {
        return this.bindAddress;
    }

    public void setBindAdress(InetAddress bindAdress) {
        this.bindAddress = bindAdress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }
}

