/*
 * Decompiled with CFR 0.152.
 */
package com.bes.admin.jeemx.util.jmx.stringifier;

import com.bes.admin.jeemx.util.StringUtil;
import com.bes.admin.jeemx.util.stringifier.SmartStringifier;
import com.bes.admin.jeemx.util.stringifier.Stringifier;
import java.util.Date;
import javax.management.MBeanServerNotification;
import javax.management.Notification;

public class NotificationStringifier
implements Stringifier {
    public static final NotificationStringifier DEFAULT = new NotificationStringifier();
    protected Options mOptions;

    public NotificationStringifier() {
        this.mOptions = new Options();
    }

    public NotificationStringifier(Options options) {
        this.mOptions = options;
    }

    protected void append(StringBuffer b, Object o) {
        if (b.length() != 0) {
            b.append(this.mOptions.mDelim);
        }
        b.append(SmartStringifier.toString(o));
    }

    public String stringify(Object o) {
        Notification notif = (Notification)o;
        return this._stringify(notif).toString();
    }

    public static String toString(Object o) {
        return DEFAULT.stringify(o);
    }

    protected StringBuffer _stringify(Notification notif) {
        StringBuffer b = new StringBuffer();
        if (this.mOptions.mIncludeSequenceNumber) {
            this.append(b, "#" + notif.getSequenceNumber());
        }
        if (this.mOptions.mIncludeTimeStamp) {
            this.append(b, new Date(notif.getTimeStamp()));
        }
        if (this.mOptions.mIncludeObjectName) {
            this.append(b, StringUtil.quote(notif.getSource()));
        }
        if (this.mOptions.mIncludeType) {
            this.append(b, notif.getType());
        }
        if (this.mOptions.mIncludeUserData) {
            this.append(b, StringUtil.quote(notif.getUserData()));
        }
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification n = (MBeanServerNotification)notif;
            this.append(b, StringUtil.quote(n.getMBeanName()));
        }
        return b;
    }

    public static final class Options {
        public boolean mIncludeObjectName = true;
        public boolean mIncludeTimeStamp = true;
        public boolean mIncludeType = true;
        public boolean mIncludeSequenceNumber = true;
        public boolean mIncludeUserData = false;
        public String mDelim = ", ";
    }
}

