/*
 * Decompiled with CFR 0.152.
 */
package com.bes.external.jeemx;

import com.bes.external.jeemx.JEEMXUtil;
import com.bes.external.jeemx.MBeanListener;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JEEMXBes {
    public static final String DEFAULT_JMX_DOMAIN = "jeemx";
    public static final JEEMXBes DEFAULT = new JEEMXBes("jeemx");
    private final String mJMXDomain;
    private final ObjectName mDomainRoot;

    public JEEMXBes(String jmxDomain) {
        this.mJMXDomain = jmxDomain;
        this.mDomainRoot = this.newObjectName("", "domain-root", null);
    }

    public static String getBesVersion() {
        String version = System.getProperty("bes.version");
        return version;
    }

    public String jeemxJMXDomain() {
        return this.mJMXDomain;
    }

    public String jeemxSupportDomain() {
        return this.jeemxJMXDomain() + "-support";
    }

    public String dasName() {
        return "server";
    }

    public String dasConfig() {
        return this.dasName() + "-config";
    }

    public ObjectName domainRoot() {
        return this.mDomainRoot;
    }

    public ObjectName monitoringRoot() {
        return this.newObjectName("/", "mon", null);
    }

    public ObjectName serverMon(String serverName) {
        return this.newObjectName("/mon", "server-mon", serverName);
    }

    public ObjectName serverMonForDAS() {
        return this.serverMon("server");
    }

    public ObjectName newObjectName(String pp, String type, String name) {
        String props = JEEMXBes.prop("pp", pp) + "," + JEEMXBes.prop("type", type);
        if (name != null) {
            props = props + "," + JEEMXBes.prop("name", name);
        }
        return this.newObjectName(props);
    }

    public ObjectName newObjectName(String s) {
        String name = s;
        if (!name.startsWith(this.jeemxJMXDomain())) {
            name = this.jeemxJMXDomain() + ":" + name;
        }
        return JEEMXUtil.newObjectName(name);
    }

    private static String prop(String key, String value) {
        return key + "=" + value;
    }

    public ObjectName getBootJEEMXMBeanObjectName() {
        return JEEMXUtil.newObjectName(this.jeemxSupportDomain() + ":type=boot-jeemx");
    }

    public void invokeBootJEEMX(MBeanServerConnection conn) {
        try {
            conn.invoke(this.getBootJEEMXMBeanObjectName(), "bootJEEMX", null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void invokeWaitJEEMXReady(MBeanServerConnection conn, ObjectName objectName) {
        try {
            conn.invoke(objectName, "waitJEEMXReady", null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends MBeanListener.Callback> MBeanListener<T> listenForDomainRoot(MBeanServerConnection server, T callback) {
        MBeanListener<T> listener = new MBeanListener<T>(server, this.domainRoot(), callback);
        listener.startListening();
        return listener;
    }

    public ObjectName waitJEEMXReady(MBeanServerConnection server) {
        WaitForDomainRootListenerCallback callback = new WaitForDomainRootListenerCallback(server);
        this.listenForDomainRoot(server, callback);
        callback.await();
        return callback.getRegistered();
    }

    public <T extends MBeanListener.Callback> MBeanListener<T> listenForBootJEEMX(MBeanServerConnection server, T callback) {
        MBeanListener<T> listener = new MBeanListener<T>(server, this.getBootJEEMXMBeanObjectName(), callback);
        listener.startListening();
        return listener;
    }

    public ObjectName bootJEEMX(MBeanServerConnection conn) throws IOException {
        ObjectName domainRoot = this.domainRoot();
        if (!conn.isRegistered(domainRoot)) {
            BootJEEMXCallback callback = new BootJEEMXCallback(conn);
            this.listenForBootJEEMX(conn, callback);
            callback.await();
            this.invokeBootJEEMX(conn);
            WaitForDomainRootListenerCallback drCallback = new WaitForDomainRootListenerCallback(conn);
            this.listenForDomainRoot(conn, drCallback);
            drCallback.await();
            JEEMXBes.invokeWaitJEEMXReady(conn, domainRoot);
        } else {
            JEEMXBes.invokeWaitJEEMXReady(conn, domainRoot);
        }
        return domainRoot;
    }

    public ObjectName bootJEEMX(MBeanServer server) {
        try {
            return this.bootJEEMX((MBeanServerConnection)server);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class BootJEEMXCallback
    extends MBeanListener.CallbackImpl {
        private final MBeanServerConnection mConn;

        public BootJEEMXCallback(MBeanServerConnection conn) {
            this.mConn = conn;
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
            this.mLatch.countDown();
        }
    }

    private static final class WaitForDomainRootListenerCallback
    extends MBeanListener.CallbackImpl {
        private final MBeanServerConnection mConn;

        public WaitForDomainRootListenerCallback(MBeanServerConnection conn) {
            this.mConn = conn;
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
            JEEMXBes.invokeWaitJEEMXReady(this.mConn, objectName);
            this.mLatch.countDown();
        }
    }
}

