/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.api;

import com.bes.mq.admin.facade.api.Omit;
import com.bes.mq.admin.facade.api.Pojo;
import com.bes.mq.admin.facade.api.PropertyBagPojo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Utils {
    static final Pattern TOKENIZER;

    public static Byte[] wrap(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        Byte[] wrapBytes = new Byte[bytes.length];
        for (int i = 0; i < wrapBytes.length; ++i) {
            wrapBytes[i] = bytes[i];
        }
        return wrapBytes;
    }

    public static byte[] unwrap(Byte[] bytes) {
        if (bytes == null) {
            bytes = new Byte[]{};
        }
        byte[] wrapBytes = new byte[bytes.length];
        for (int i = 0; i < wrapBytes.length; ++i) {
            wrapBytes[i] = bytes[i];
        }
        return wrapBytes;
    }

    public static boolean toBoolean(String value) {
        if (value != null) {
            String v = value.trim();
            return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
        }
        return false;
    }

    public static int toInt(String value) {
        return Utils.isEmpty(value) ? 0 : Integer.valueOf(value);
    }

    public static long toLong(String value) {
        return Utils.isEmpty(value) ? 0L : Long.valueOf(value);
    }

    public static double toDouble(String value) {
        return Utils.isEmpty(value) ? 0.0 : Double.valueOf(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static Map<String, Object> pojo2map(Pojo pojo, List<String> ... permitFieldListArray) throws IllegalArgumentException, IllegalAccessException {
        List<String> permitFieldList = null;
        if (permitFieldListArray.length > 0) {
            permitFieldList = permitFieldListArray[0];
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clz = pojo.getClass(); Pojo.class.isAssignableFrom(clz) && PropertyBagPojo.class != clz; clz = clz.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = clz.getDeclaredFields()) {
                Class<?> type;
                boolean isOmit;
                if (Modifier.isStatic(field.getModifiers())) continue;
                boolean bl = isOmit = field.getAnnotation(Omit.class) != null;
                if (isOmit || !(type = field.getType()).isPrimitive() && type != String.class) continue;
                field.setAccessible(true);
                String name = field.getName();
                if (permitFieldList != null && !permitFieldList.contains(name)) continue;
                Object value = field.get(pojo);
                if (type == String.class && (value == null || ((String)String.class.cast(value)).length() == 0)) continue;
                String xmlName = Utils.camelCaseToXML(name);
                String strValue = String.valueOf(value);
                map.put(xmlName, strValue);
            }
        }
        return map;
    }

    public static int extractMB(String content) {
        int result = 0;
        String number = content.replaceAll("[^\\d]", "");
        if (!number.isEmpty()) {
            result = Integer.parseInt(number);
            char c = content.charAt(content.length() - 1);
            if ('k' == c || 'K' == c) {
                result /= 1024;
            } else if ('m' != c && 'M' != c) {
                result = 'g' == c || 'G' == c ? (result *= 1024) : (result /= 0x100000);
            }
        }
        return result;
    }

    public static String camelCaseToXML(String camelCase) {
        StringBuilder buf = new StringBuilder(camelCase.length() + 5);
        for (String t : TOKENIZER.split(camelCase)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    static {
        String pattern = Utils.or(Utils.split("x", "X"), Utils.split("X", "Xx"), Utils.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

