/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.admin.jeemx.core.proxy.ProxyFactory;
import com.bes.mq.admin.facade.api.BrokerCommunicationException;
import com.bes.mq.admin.facade.api.BrokerInfo;
import com.bes.mq.admin.facade.api.bridge.BridgeFacade;
import com.bes.mq.admin.facade.api.broker.BrokerFacade;
import com.bes.mq.admin.facade.api.cluster.ClusterConnectorFacade;
import com.bes.mq.admin.facade.api.cluster.FilterDestinationFacade;
import com.bes.mq.admin.facade.api.connection.ConnectionFactoryFacade;
import com.bes.mq.admin.facade.api.connection.PooledConnectionFactoryFacade;
import com.bes.mq.admin.facade.api.connector.ConnectorFacade;
import com.bes.mq.admin.facade.api.destinations.DestinationsFacade;
import com.bes.mq.admin.facade.api.ext.ExtensionFacade;
import com.bes.mq.admin.facade.api.jmx.JmxFacade;
import com.bes.mq.admin.facade.api.jndi.JndiFacade;
import com.bes.mq.admin.facade.api.jvm.JvmOptionsFacade;
import com.bes.mq.admin.facade.api.log.LogServiceFacade;
import com.bes.mq.admin.facade.api.monitor.MonitorFacade;
import com.bes.mq.admin.facade.api.policy.PoliciesFacade;
import com.bes.mq.admin.facade.api.rest.RestServiceFacade;
import com.bes.mq.admin.facade.api.security.SecuritySeviceFacade;
import com.bes.mq.admin.facade.api.store.StoreFacade;
import com.bes.mq.admin.facade.api.store.TempStoreFacade;
import com.bes.mq.admin.facade.api.usage.UsageFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.admin.facade.impl.jeemx.JMXAdminFacadeFactory;
import com.bes.mq.admin.facade.impl.jeemx.bridge.BridgeFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.broker.BrokerFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.cluster.ClusterConnectorFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.cluster.FilterDestinationFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.connection.ConnectionFactoryFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.connection.PooledConnectionFactoryFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.connector.ConnectorFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.destinations.DestinationsFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.ext.ExtensionFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.jmx.JmxFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.jndi.JndiFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.jvm.JvmOptionsFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.log.LogServiceFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.monitor.MonitorFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.policy.PoliciesFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.rest.RestServiceFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.security.SecuritySeviceFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.store.StoreFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.store.TempStoreFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.tools.MBeanServerConnectionFactory;
import com.bes.mq.admin.facade.impl.jeemx.usage.UsageFacadeImpl;
import com.bes.mq.admin.node.NodeFacade;
import com.bes.mq.admin.node.impl.ssh.SSHNodeFacade;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;

public class JEEMXBasedAdminFacadeFactory
implements JMXAdminFacadeFactory,
InvocationHandler {
    private static final Logger logger = JEEMXUtils.getLogger();
    private static final String INIT_RETRY_TIMES = "com.bes.mq.jeemx.initRetryTimes";
    private static final String INIT_RETRY_INTERVAL = "com.bes.mq.jeemx.initRetryInterval";
    private static final String CALL_RETRY_TIMES = "com.bes.mq.jeemx.callRetryTimes";
    private static final String CALL_RETRY_INTERVAL = "com.bes.mq.jeemx.callRetryInterval";
    private int initRetryTimes = Integer.valueOf(System.getProperty("com.bes.mq.jeemx.initRetryTimes", "1"));
    private int initRetryInterval = Integer.valueOf(System.getProperty("com.bes.mq.jeemx.initRetryInterval", "500"));
    private int callRetryTimes = Integer.valueOf(System.getProperty("com.bes.mq.jeemx.callRetryTimes", "2"));
    private int callRetryInterval = Integer.valueOf(System.getProperty("com.bes.mq.jeemx.callRetryInterval", "500"));
    private BrokerFacade brokerFacade = null;
    private DestinationsFacade destinationsFacade = null;
    private ExtensionFacade extensionFacade = null;
    private PoliciesFacade policiesFacade = null;
    private JvmOptionsFacade jvmOptionsFacade = null;
    private UsageFacade usageFacade = null;
    private ConnectorFacade connectorFacade = null;
    private StoreFacade storeFacade = null;
    private TempStoreFacade tempStoreFacade = null;
    private BridgeFacade bridgeFacade = null;
    private ClusterConnectorFacade clusterConnectorFacade = null;
    private FilterDestinationFacade filterDestinationFacade = null;
    private SecuritySeviceFacade securitySeviceFacade = null;
    private LogServiceFacade logServiceFacade = null;
    private RestServiceFacade restServiceFacade = null;
    private ConnectionFactoryFacade connectionFactory = null;
    private PooledConnectionFactoryFacade pooledConnectionFactory = null;
    private MonitorFacade monitorFacade = null;
    private JmxFacade jmxFacade = null;
    private JndiFacade jndiFacade = null;
    private volatile boolean init = false;
    private MBeanServerConnection connection = null;
    private BrokerInfo brokerInfo = null;
    private JEEMXHelper jeemxHelper = null;
    private NodeFacade nodeFacade = new SSHNodeFacade();
    private static Set<String> excludes = new HashSet<String>();
    private MBeanServer MBeanServer = null;

    public MBeanServer getmBeanServer() {
        return this.MBeanServer;
    }

    @Override
    public void setMBeanServer(MBeanServer MBeanServer2) {
        this.MBeanServer = MBeanServer2;
    }

    public static JMXAdminFacadeFactory newFactory(BrokerInfo brokerInfo) {
        JEEMXBasedAdminFacadeFactory factory = new JEEMXBasedAdminFacadeFactory(brokerInfo);
        return (JMXAdminFacadeFactory)Proxy.newProxyInstance(JMXAdminFacadeFactory.class.getClassLoader(), new Class[]{JMXAdminFacadeFactory.class}, (InvocationHandler)factory);
    }

    private JEEMXBasedAdminFacadeFactory(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
    }

    private void initialize() throws Exception {
        if (this.init) {
            return;
        }
        String host = this.brokerInfo.getHost();
        int port = this.brokerInfo.getPort();
        String username = this.brokerInfo.getUsername();
        String password = this.brokerInfo.getPassword();
        ProxyFactory proxyFactory = null;
        if (this.MBeanServer != null) {
            this.connection = this.MBeanServer;
            proxyFactory = ProxyFactory.getInstance(this.connection);
        } else if (this.brokerInfo.isEmbed()) {
            Class<?> clazz = Class.forName("com.bes.admin.jeemx.extra.AbstractJEEMXFactory");
            Method getInsMethod = clazz.getMethod("getInstance", new Class[0]);
            Method getMSMethod = clazz.getMethod("getMBeanServer", new Class[0]);
            Object jeemFactory = getInsMethod.invoke(clazz, new Object[0]);
            this.connection = (MBeanServer)getMSMethod.invoke(jeemFactory, new Object[0]);
            proxyFactory = ProxyFactory.getInstance(this.connection);
        } else {
            this.connection = MBeanServerConnectionFactory.getMBeanServerConnection(host, port, username, password, true);
            proxyFactory = ProxyFactory.getInstance(this.connection, false);
        }
        DomainRoot domainRoot = proxyFactory.getDomainRootProxy();
        this.jeemxHelper = new JEEMXHelper(domainRoot);
        this.initFacades();
        this.init = true;
    }

    private void initFacades() {
        this.brokerFacade = new BrokerFacadeImpl(this.jeemxHelper);
        this.destinationsFacade = new DestinationsFacadeImpl(this.jeemxHelper);
        this.extensionFacade = new ExtensionFacadeImpl(this.jeemxHelper);
        this.policiesFacade = new PoliciesFacadeImpl(this.jeemxHelper);
        this.jvmOptionsFacade = new JvmOptionsFacadeImpl(this.jeemxHelper);
        this.usageFacade = new UsageFacadeImpl(this.jeemxHelper);
        this.connectorFacade = new ConnectorFacadeImpl(this.jeemxHelper);
        this.storeFacade = new StoreFacadeImpl(this.jeemxHelper);
        this.tempStoreFacade = new TempStoreFacadeImpl(this.jeemxHelper);
        this.bridgeFacade = new BridgeFacadeImpl(this.jeemxHelper);
        this.clusterConnectorFacade = new ClusterConnectorFacadeImpl(this.jeemxHelper);
        this.filterDestinationFacade = new FilterDestinationFacadeImpl(this.jeemxHelper);
        this.securitySeviceFacade = new SecuritySeviceFacadeImpl(this.jeemxHelper);
        this.connectionFactory = new ConnectionFactoryFacadeImpl(this.jeemxHelper);
        this.pooledConnectionFactory = new PooledConnectionFactoryFacadeImpl(this.jeemxHelper);
        this.monitorFacade = new MonitorFacadeImpl(this.jeemxHelper, this.connection);
        this.logServiceFacade = new LogServiceFacadeImpl(this.jeemxHelper);
        this.restServiceFacade = new RestServiceFacadeImpl(this.jeemxHelper);
        this.jmxFacade = new JmxFacadeImpl(this.jeemxHelper);
        this.jndiFacade = new JndiFacadeImpl(this.jeemxHelper);
    }

    @Override
    public void clear() {
        if (this.init) {
            try {
                this.jeemxHelper.clear();
                MBeanServerConnectionFactory.clear(this.connection);
                this.init = false;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error occurred while closing facade factory, caused by: " + e.getMessage());
            }
        }
    }

    @Override
    public BrokerFacade getBrokerFacade() {
        return this.brokerFacade;
    }

    @Override
    public DestinationsFacade getDestinationsFacade() {
        return this.destinationsFacade;
    }

    @Override
    public ExtensionFacade getExtensionFacade() {
        return this.extensionFacade;
    }

    @Override
    public PoliciesFacade getPoliciesFacade() {
        return this.policiesFacade;
    }

    @Override
    public JvmOptionsFacade getJvmOptionsFacade() {
        return this.jvmOptionsFacade;
    }

    @Override
    public UsageFacade getUsageFacade() {
        return this.usageFacade;
    }

    @Override
    public ConnectorFacade getConnectorFacade() {
        return this.connectorFacade;
    }

    @Override
    public StoreFacade getStoreFacade() {
        return this.storeFacade;
    }

    @Override
    public TempStoreFacade getTempStoreFacade() {
        return this.tempStoreFacade;
    }

    @Override
    public ConnectionFactoryFacade getConnectionFactoryFacade() {
        return this.connectionFactory;
    }

    @Override
    public PooledConnectionFactoryFacade getPooledConnectionFactoryFacade() {
        return this.pooledConnectionFactory;
    }

    @Override
    public BridgeFacade getBridgeFacade() {
        return this.bridgeFacade;
    }

    @Override
    public ClusterConnectorFacade getClusterConnectorFacade() {
        return this.clusterConnectorFacade;
    }

    @Override
    public FilterDestinationFacade getFilterDestinationFacade() {
        return this.filterDestinationFacade;
    }

    @Override
    public SecuritySeviceFacade getSecuritySeviceFacade() {
        return this.securitySeviceFacade;
    }

    @Override
    public MonitorFacade getMonitorFacade() {
        return this.monitorFacade;
    }

    @Override
    public LogServiceFacade getLogSeviceFacade() {
        return this.logServiceFacade;
    }

    @Override
    public RestServiceFacade getRestSeviceFacade() {
        return this.restServiceFacade;
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String msg;
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (excludes.contains(method.getName())) {
            return method.invoke((Object)this, args);
        }
        JEEMXBasedAdminFacadeFactory jEEMXBasedAdminFacadeFactory = this;
        synchronized (jEEMXBasedAdminFacadeFactory) {
            int retry = this.initRetryTimes;
            while (retry-- > 0) {
                try {
                    this.initialize();
                    break;
                }
                catch (IOException e) {
                    msg = "Failed to initialize facade factory, caused by: " + e.getMessage();
                    logger.log(Level.FINER, msg);
                    if (retry == 0) {
                        throw new BrokerCommunicationException(e);
                    }
                    Thread.sleep(this.initRetryInterval);
                }
            }
        }
        int retry = this.callRetryTimes;
        Object ret = null;
        while (retry-- > 0) {
            try {
                ret = method.invoke((Object)this, args);
                break;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IOException) {
                    msg = String.format("Failed to invoke method %s factory, caused by: " + e.getMessage(), method.getName());
                    logger.log(Level.FINER, msg);
                    try {
                        this.clear();
                        this.initialize();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    if (retry == 0) {
                        throw new BrokerCommunicationException(e);
                    }
                }
                Thread.sleep(this.callRetryInterval);
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setHost("localhost");
        brokerInfo.setPort(3100);
        JMXAdminFacadeFactory factory = JEEMXBasedAdminFacadeFactory.newFactory(brokerInfo);
        System.out.println(factory.getBrokerFacade().getRuntimeInfo());
        factory.getBrokerFacade().restartBroker();
        factory = JEEMXBasedAdminFacadeFactory.newFactory(brokerInfo);
        System.out.println(factory.getBrokerFacade().getRuntimeInfo());
    }

    @Override
    public JmxFacade getJmxFacade() {
        return this.jmxFacade;
    }

    @Override
    public void updateSecurityInfo(String user, String password) {
        this.brokerInfo.setUsername(user);
        this.brokerInfo.setPassword(password);
    }

    @Override
    public JndiFacade getJndiFacade() {
        return this.jndiFacade;
    }

    @Override
    public NodeFacade getNodeFacade() {
        return this.nodeFacade;
    }

    static {
        excludes.add("initialize");
        excludes.add("initFacades");
        excludes.add("clear");
        excludes.add("updateSecurityInfo");
        excludes.add("setMBeanServer");
        excludes.add("getNodeFacade");
    }
}

