/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx;

import com.bes.admin.jeemx.base.DomainRoot;
import com.bes.mq.jeemx.config.intf.Authentication;
import com.bes.mq.jeemx.config.intf.Authorizations;
import com.bes.mq.jeemx.config.intf.Broker;
import com.bes.mq.jeemx.config.intf.ClusterConnector;
import com.bes.mq.jeemx.config.intf.ClusterConnectors;
import com.bes.mq.jeemx.config.intf.ConnectionFactories;
import com.bes.mq.jeemx.config.intf.ConnectionPools;
import com.bes.mq.jeemx.config.intf.Destinations;
import com.bes.mq.jeemx.config.intf.DynamicallyIncludedDestinations;
import com.bes.mq.jeemx.config.intf.ExcludedDestinations;
import com.bes.mq.jeemx.config.intf.JavaConfig;
import com.bes.mq.jeemx.config.intf.JmsBridges;
import com.bes.mq.jeemx.config.intf.JmxService;
import com.bes.mq.jeemx.config.intf.JndiService;
import com.bes.mq.jeemx.config.intf.MessageStores;
import com.bes.mq.jeemx.config.intf.MqServer;
import com.bes.mq.jeemx.config.intf.Policies;
import com.bes.mq.jeemx.config.intf.SecurityService;
import com.bes.mq.jeemx.config.intf.StaticallyIncludedDestinations;
import com.bes.mq.jeemx.config.intf.SystemUsage;
import com.bes.mq.jeemx.config.intf.TransportConnectors;
import com.bes.mq.jeemx.config.intf.ext.BESMQExtension;
import java.util.HashMap;

public class JEEMXHelper {
    private DomainRoot domainRoot = null;
    private BESMQExtension extension = null;
    private MqServer mqServer = null;
    private Broker broker = null;
    private Destinations destinations = null;
    private MessageStores stores = null;
    private SystemUsage systemUsage = null;
    private TransportConnectors transportConnectors = null;
    private JavaConfig javaConfig = null;
    private ConnectionFactories connectionFactories = null;
    private ConnectionPools connectionPools = null;
    private Policies policies = null;
    private JmsBridges jmsBridges = null;
    private ClusterConnectors clusterConnectors = null;
    private Authentication authentication = null;
    private Authorizations authorizations = null;
    private SecurityService securityService = null;
    private JmxService jmxService = null;
    private JndiService jndiService = null;

    public JEEMXHelper(DomainRoot dr) {
        this.domainRoot = dr;
    }

    public synchronized void clear() {
        this.domainRoot = null;
        this.extension = null;
        this.mqServer = null;
        this.broker = null;
        this.destinations = null;
        this.stores = null;
        this.systemUsage = null;
        this.transportConnectors = null;
        this.javaConfig = null;
        this.connectionFactories = null;
        this.connectionPools = null;
        this.policies = null;
        this.jmsBridges = null;
        this.clusterConnectors = null;
        this.authentication = null;
        this.authorizations = null;
        this.jmxService = null;
        this.jndiService = null;
    }

    public synchronized BESMQExtension getExtension() {
        if (this.extension == null) {
            this.extension = this.getDomainRoot().getUserExtension().as(BESMQExtension.class);
        }
        return this.extension;
    }

    public synchronized DomainRoot getDomainRoot() {
        if (this.domainRoot == null) {
            throw new IllegalStateException("JEEMXHelper isn't initialized");
        }
        return this.domainRoot;
    }

    public synchronized MqServer getMqServer() {
        if (this.mqServer == null) {
            this.mqServer = this.getDomainRoot().getDomain().as(MqServer.class);
        }
        return this.mqServer;
    }

    public synchronized Broker getBroker() {
        if (this.broker == null) {
            this.broker = this.getMqServer().getBroker();
        }
        return this.broker;
    }

    public synchronized Destinations getDestinations() {
        if (this.destinations == null) {
            this.destinations = this.getBroker().getDestinations();
            if (this.destinations == null) {
                this.getBroker().createChild("destinations", null);
                this.destinations = this.getBroker().getDestinations();
            }
        }
        return this.destinations;
    }

    public synchronized JavaConfig getJavaConfig() {
        if (this.javaConfig == null) {
            this.javaConfig = this.getBroker().getJavaConfig();
            if (this.javaConfig == null) {
                this.getBroker().createChild("java-config", null);
                this.javaConfig = this.getBroker().getJavaConfig();
            }
        }
        return this.javaConfig;
    }

    public synchronized SystemUsage getSystemUsage() {
        if (this.systemUsage == null) {
            this.systemUsage = this.getBroker().getSystemUsage();
            if (this.systemUsage == null) {
                this.getBroker().createChild("system-usage", null);
                this.systemUsage = this.getBroker().getSystemUsage();
            }
        }
        return this.systemUsage;
    }

    public synchronized TransportConnectors getTransportConnectors() {
        if (this.transportConnectors == null) {
            this.transportConnectors = this.getBroker().getTransportConnectors();
            if (this.transportConnectors == null) {
                this.getBroker().createChild("transport-connectors", null);
                this.transportConnectors = this.getBroker().getTransportConnectors();
            }
        }
        return this.transportConnectors;
    }

    public synchronized MessageStores getMessageStores() {
        if (this.stores == null) {
            this.stores = this.getBroker().getMessageStores();
            if (this.stores == null) {
                this.getBroker().createChild("message-stores", null);
                this.stores = this.getBroker().getMessageStores();
            }
        }
        return this.stores;
    }

    public synchronized ConnectionFactories getConnectionFactories() {
        if (this.connectionFactories == null) {
            this.connectionFactories = this.getBroker().getConnectionResource().getConnectionFactories();
            if (this.connectionFactories == null) {
                this.getBroker().createChild("connection-factories", null);
                this.connectionFactories = this.getBroker().getConnectionResource().getConnectionFactories();
            }
        }
        return this.connectionFactories;
    }

    public synchronized Policies getPolicies() {
        if (this.policies == null) {
            this.policies = this.getBroker().getPolicies();
            if (this.policies == null) {
                this.policies = this.getBroker().createChild("policies", null).as(Policies.class);
            }
        }
        return this.policies;
    }

    public synchronized JmsBridges getJmsBridges() {
        if (this.jmsBridges == null) {
            this.jmsBridges = this.getBroker().getJmsBridges();
            if (this.jmsBridges == null) {
                this.getBroker().createChild("jms-bridges", null);
                this.jmsBridges = this.getBroker().getJmsBridges();
            }
        }
        return this.jmsBridges;
    }

    public synchronized ClusterConnectors getClusterConnectors() {
        if (this.clusterConnectors == null) {
            this.clusterConnectors = this.getBroker().getClusterConnectors();
            if (this.clusterConnectors == null) {
                this.getBroker().createChild("cluster-connectors", null);
                this.clusterConnectors = this.getBroker().getClusterConnectors();
            }
        }
        return this.clusterConnectors;
    }

    public synchronized StaticallyIncludedDestinations getStaticallyIncludedDestinations(ClusterConnector clusterConnector) {
        StaticallyIncludedDestinations staticallyIncludedDestinations = clusterConnector.getStaticallyIncludedDestinations();
        if (staticallyIncludedDestinations == null) {
            clusterConnector.createChild("statically-included-destinations", null);
            staticallyIncludedDestinations = clusterConnector.getStaticallyIncludedDestinations();
        }
        return staticallyIncludedDestinations;
    }

    public synchronized DynamicallyIncludedDestinations getDynamicallyIncludedDestinations(ClusterConnector clusterConnector) {
        DynamicallyIncludedDestinations dynamicallyIncludedDestinations = clusterConnector.getDynamicallyIncludedDestinations();
        if (dynamicallyIncludedDestinations == null) {
            clusterConnector.createChild("dynamically-included-destinations", null);
            dynamicallyIncludedDestinations = clusterConnector.getDynamicallyIncludedDestinations();
        }
        return dynamicallyIncludedDestinations;
    }

    public synchronized ExcludedDestinations getExcludedDestinations(ClusterConnector clusterConnector) {
        ExcludedDestinations excludedDestinations = clusterConnector.getExcludedDestinations();
        if (excludedDestinations == null) {
            clusterConnector.createChild("excluded-destinations", null);
            excludedDestinations = clusterConnector.getExcludedDestinations();
        }
        return excludedDestinations;
    }

    public synchronized SecurityService getSecurityService() {
        if (this.securityService == null) {
            this.securityService = this.getBroker().getSecurityService();
            if (this.securityService == null) {
                this.securityService = this.getBroker().createChild("security-service", null).as(SecurityService.class);
            }
        }
        return this.securityService;
    }

    public synchronized Authorizations getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = this.getSecurityService().getAuthorizations();
            if (this.authorizations == null) {
                this.authorizations = this.getSecurityService().createChild("authorizations", null).as(Authorizations.class);
            }
        }
        return this.authorizations;
    }

    public synchronized Authentication getAuthentication() {
        if (this.authentication == null) {
            this.authentication = this.getSecurityService().getAuthentication();
            if (this.authentication == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("enable", false);
                this.authentication = this.getSecurityService().createChild("authentication", map).as(Authentication.class);
            }
        }
        return this.authentication;
    }

    public synchronized JmxService getJmxService() {
        if (this.jmxService == null) {
            this.jmxService = this.getBroker().getJmxService();
            if (this.jmxService == null) {
                this.getBroker().createChild("jmx-service", null);
                this.jmxService = this.getBroker().getJmxService();
            }
        }
        return this.jmxService;
    }

    public synchronized JndiService getJndiService() {
        if (this.jndiService == null) {
            this.jndiService = this.getBroker().getJndiService();
            if (this.jndiService == null) {
                this.getBroker().createChild("jndi-service", null);
                this.jndiService = this.getBroker().getJndiService();
            }
        }
        return this.jndiService;
    }

    public ConnectionPools getConnectionPools() {
        if (this.connectionPools == null) {
            this.connectionPools = this.getBroker().getConnectionResource().getConnectionPools();
            if (this.connectionPools == null) {
                this.getBroker().createChild("connection-pools", null);
                this.connectionPools = this.getBroker().getConnectionResource().getConnectionPools();
            }
        }
        return this.connectionPools;
    }
}

