/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.admin.jeemx.intf.config.PropertiesAccess;
import com.bes.admin.jeemx.intf.config.Property;
import com.bes.mq.admin.facade.api.PropertyBagPojo;
import com.bes.mq.admin.facade.api.PropertyPojo;
import com.bes.mq.admin.facade.api.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class JEEMXUtils {
    private static final Logger logger = Logger.getLogger(JEEMXUtils.class.getPackage().getName());

    public static Logger getLogger() {
        return logger;
    }

    public static void applyPropertyBag(JEEMXConfigProxy proxy, PropertyBagPojo pojo) throws IllegalArgumentException, IllegalAccessException {
        if (proxy == null || pojo == null || pojo.getProperties().size() == 0) {
            return;
        }
        List<PropertyPojo> properties = pojo.getProperties();
        for (PropertyPojo pp : properties) {
            proxy.createChild("property", Utils.pojo2map(pp, new List[0]));
        }
    }

    public static void updatePropertyBag(PropertiesAccess proxy, PropertyBagPojo pojo) throws IllegalArgumentException, IllegalAccessException {
        List<PropertyPojo> now = pojo.getProperties();
        ArrayList<Property> old = new ArrayList<Property>(proxy.getProperty().values());
        Iterator<PropertyPojo> nowIt = now.iterator();
        Iterator oldIt = old.iterator();
        block0: while (oldIt.hasNext()) {
            Property oldProp = (Property)oldIt.next();
            nowIt = now.iterator();
            while (nowIt.hasNext()) {
                PropertyPojo nowProp = nowIt.next();
                if (!oldProp.getName().equals(nowProp.getName())) continue;
                oldProp.setValue(nowProp.getValue());
                oldIt.remove();
                nowIt.remove();
                continue block0;
            }
        }
        nowIt = now.iterator();
        while (nowIt.hasNext()) {
            proxy.createChild("property", Utils.pojo2map(nowIt.next(), new List[0]));
        }
        oldIt = old.iterator();
        while (oldIt.hasNext()) {
            proxy.removeChild("property", ((Property)oldIt.next()).getName());
        }
    }

    public static void fillPropertyBag(PropertyBagPojo pojo, PropertiesAccess proxy) {
        Collection<Property> values = proxy.getProperty().values();
        ArrayList<PropertyPojo> lists = new ArrayList<PropertyPojo>();
        for (Property p : values) {
            String name = p.getName();
            String value = p.getValue();
            String description = p.getDescription();
            PropertyPojo propertyPojo = new PropertyPojo(name, value, description);
            lists.add(propertyPojo);
        }
        Collections.sort(lists);
        for (PropertyPojo pp : lists) {
            pojo.addProperty(pp);
        }
    }
}

