/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.bridge;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.bridge.BridgeFacade;
import com.bes.mq.admin.facade.api.bridge.pojo.InboundBridgePojo;
import com.bes.mq.admin.facade.api.bridge.pojo.InboundQueueBridgePojo;
import com.bes.mq.admin.facade.api.bridge.pojo.InboundTopicBridgePojo;
import com.bes.mq.admin.facade.api.bridge.pojo.JmsBridgePojo;
import com.bes.mq.admin.facade.api.bridge.pojo.OutboundBridgePojo;
import com.bes.mq.admin.facade.api.bridge.pojo.OutboundJndiPropertiesPojo;
import com.bes.mq.admin.facade.api.bridge.pojo.OutboundQueueBridgePojo;
import com.bes.mq.admin.facade.api.bridge.pojo.OutboundTopicBridgePojo;
import com.bes.mq.admin.facade.api.destinations.pojo.Type;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.Broker;
import com.bes.mq.jeemx.config.intf.InboundBridges;
import com.bes.mq.jeemx.config.intf.InboundQueueBridge;
import com.bes.mq.jeemx.config.intf.InboundTopicBridge;
import com.bes.mq.jeemx.config.intf.JmsBridge;
import com.bes.mq.jeemx.config.intf.JmsBridges;
import com.bes.mq.jeemx.config.intf.OutboundBridges;
import com.bes.mq.jeemx.config.intf.OutboundJndiProperties;
import com.bes.mq.jeemx.config.intf.OutboundQueueBridge;
import com.bes.mq.jeemx.config.intf.OutboundTopicBridge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BridgeFacadeImpl
extends BaseFacade
implements BridgeFacade {
    public BridgeFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void createJmsBridge(JmsBridgePojo pojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(pojo, new List[0]);
        JmsBridges jmsBridges = this.jeemxHelper.getJmsBridges();
        JEEMXConfigProxy proxy = jmsBridges.createChild("jms-bridge", pojo2map);
        JmsBridge jmsbridge = proxy.as(JmsBridge.class);
        List<InboundBridgePojo> inboundBridgePojos = pojo.getInboundBridgePojo();
        if (!inboundBridgePojos.isEmpty()) {
            JEEMXConfigProxy createChild = jmsbridge.createChild("inbound-bridges", null);
            InboundBridges inboundBridges = createChild.as(InboundBridges.class);
            for (InboundBridgePojo inBridgePojo : inboundBridgePojos) {
                Map<String, Object> inAttr = Utils.pojo2map(inBridgePojo, new List[0]);
                if (inBridgePojo instanceof InboundQueueBridgePojo) {
                    if (inAttr.containsKey("consumer-name")) {
                        inAttr.remove("consumer-name");
                    }
                    inboundBridges.createChild("inbound-queue-bridge", inAttr);
                    continue;
                }
                inboundBridges.createChild("inbound-topic-bridge", inAttr);
            }
        } else {
            jmsbridge.createChild("inbound-bridges", null);
        }
        List<OutboundBridgePojo> outboundBridgePojos = pojo.getOutboundBridgePojo();
        if (!outboundBridgePojos.isEmpty()) {
            JEEMXConfigProxy createChild = jmsbridge.createChild("outbound-bridges", null);
            OutboundBridges outboundBridges = createChild.as(OutboundBridges.class);
            for (OutboundBridgePojo outBridgePojo : outboundBridgePojos) {
                Map<String, Object> outAttr = Utils.pojo2map(outBridgePojo, new List[0]);
                if (outBridgePojo instanceof OutboundQueueBridgePojo) {
                    if (outAttr.containsKey("consumer-name")) {
                        outAttr.remove("consumer-name");
                    }
                    outboundBridges.createChild("outbound-queue-bridge", outAttr);
                    continue;
                }
                outboundBridges.createChild("outbound-topic-bridge", outAttr);
            }
        } else {
            jmsbridge.createChild("outbound-bridges", null);
        }
        OutboundJndiPropertiesPojo outboundJndiPropertiesPojo = pojo.getOutboundJndiPropertiesPojo();
        if (outboundJndiPropertiesPojo != null) {
            JEEMXConfigProxy createChild = jmsbridge.createChild("outbound-jndi-properties", null);
            OutboundJndiProperties outboundJndi = createChild.as(OutboundJndiProperties.class);
            JEEMXUtils.applyPropertyBag(outboundJndi, outboundJndiPropertiesPojo);
        } else {
            jmsbridge.createChild("outbound-jndi-properties", null);
        }
    }

    @Override
    public void deleteJmsBridge(String name) throws Exception {
        JmsBridges jmsBridges = this.jeemxHelper.getJmsBridges();
        jmsBridges.removeChild("jms-bridge", name);
    }

    @Override
    public JmsBridgePojo getJmsBridge(String jmsBridgeName) throws Exception {
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        JmsBridgePojo pojo = this.createJmsBridgePojo(jmsBridge);
        return pojo;
    }

    @Override
    public void updateJmsBridge(JmsBridgePojo jmsBridgePojo) throws Exception {
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgePojo.getName());
        if (jmsBridge == null) {
            return;
        }
        OutboundJndiProperties outboundJndiProperties = jmsBridge.getOutboundJndiProperties();
        InboundBridges inProxy = jmsBridge.getInboundBridges();
        OutboundBridges outProxy = jmsBridge.getOutboundBridges();
        jmsBridge.setLocalClientId(jmsBridgePojo.getLocalClientId());
        jmsBridge.setLocalConnectionFactoryName(jmsBridgePojo.getLocalConnectionFactoryName());
        jmsBridge.setOutboundClientId(jmsBridgePojo.getOutboundClientId());
        jmsBridge.setOutboundConnectionFactoryJndiName(jmsBridgePojo.getOutboundConnectionFactoryJndiName());
        jmsBridge.setMaxReconnectAttempts(String.valueOf(jmsBridgePojo.getMaxReconnectAttempts()));
        jmsBridge.setMaxReconnectDelay(String.valueOf(jmsBridgePojo.getMaxReconnectDelay()));
        jmsBridge.setInitialReconnectDelay(String.valueOf(jmsBridgePojo.getInitialReconnectDelay()));
        jmsBridge.setBackOffMultiplier(String.valueOf(jmsBridgePojo.getBackOffMultiplier()));
        if ("".equals(jmsBridgePojo.getOutboundPassword())) {
            jmsBridge.setOutboundPassword(null);
        } else {
            jmsBridge.setOutboundPassword(jmsBridgePojo.getOutboundPassword());
        }
        if ("".equals(jmsBridgePojo.getOutboundUsername())) {
            jmsBridge.setOutboundUsername(null);
        } else {
            jmsBridge.setOutboundUsername(jmsBridgePojo.getOutboundUsername());
        }
        if (jmsBridgePojo.getOutboundJndiPropertiesPojo() != null) {
            JEEMXUtils.updatePropertyBag(outboundJndiProperties, jmsBridgePojo.getOutboundJndiPropertiesPojo());
        }
        this.updateInboundBridge(inProxy, jmsBridgePojo);
        this.updateOutboundBridge(outProxy, jmsBridgePojo);
    }

    private void updateInboundBridge(InboundBridges proxy, JmsBridgePojo jmsBridgePojo) throws Exception {
        List<InboundBridgePojo> nowInboundBridgePojos = jmsBridgePojo.getInboundBridgePojo();
        Map<String, InboundQueueBridge> inboundQueueBridges = proxy.getInboundQueueBridge();
        Map<String, InboundTopicBridge> inboundTopicBridges = proxy.getInboundTopicBridge();
        Iterator<InboundBridgePojo> nowIt = nowInboundBridgePojos.iterator();
        while (nowIt.hasNext()) {
            String selector;
            InboundBridgePojo inboundBridgePojo = nowIt.next();
            if (inboundBridgePojo instanceof InboundQueueBridgePojo) {
                InboundQueueBridge inboundQueueBridge = inboundQueueBridges.get(inboundBridgePojo.getInboundJndiName());
                if (inboundQueueBridge == null) continue;
                inboundQueueBridge.setLocalName(inboundBridgePojo.getLocalName());
                selector = inboundBridgePojo.getSelector();
                if (selector != null && !"".equals(selector)) {
                    inboundQueueBridge.setSelector(selector);
                } else {
                    inboundQueueBridge.setSelector(null);
                }
                nowIt.remove();
                inboundQueueBridges.remove(inboundBridgePojo.getInboundJndiName());
                continue;
            }
            InboundTopicBridge inboundTopicBridge = inboundTopicBridges.get(inboundBridgePojo.getInboundJndiName());
            if (inboundTopicBridge == null) continue;
            inboundTopicBridge.setLocalName(inboundBridgePojo.getLocalName());
            selector = inboundBridgePojo.getSelector();
            if (selector != null && !"".equals(selector)) {
                inboundTopicBridge.setSelector(selector);
            } else {
                inboundTopicBridge.setSelector(null);
            }
            String consumerName = ((InboundTopicBridgePojo)inboundBridgePojo).getConsumerName();
            if (consumerName != null && !"".equals(consumerName)) {
                inboundTopicBridge.setConsumerName(consumerName);
            } else {
                inboundTopicBridge.setConsumerName(null);
            }
            nowIt.remove();
            inboundTopicBridges.remove(inboundBridgePojo.getInboundJndiName());
        }
        for (InboundBridgePojo inboundBridgePojo : nowInboundBridgePojos) {
            if (inboundBridgePojo instanceof InboundQueueBridgePojo) {
                proxy.createChild("inbound-queue-bridge", Utils.pojo2map(inboundBridgePojo, new List[0]));
                continue;
            }
            proxy.createChild("inbound-topic-bridge", Utils.pojo2map(inboundBridgePojo, new List[0]));
        }
        Iterator<String> queueIterator = inboundQueueBridges.keySet().iterator();
        while (queueIterator.hasNext()) {
            proxy.removeChild("inbound-queue-bridge", queueIterator.next());
        }
        Iterator<String> topicIterator = inboundTopicBridges.keySet().iterator();
        while (topicIterator.hasNext()) {
            proxy.removeChild("inbound-topic-bridge", topicIterator.next());
        }
    }

    private void updateOutboundBridge(OutboundBridges proxy, JmsBridgePojo jmsBridgePojo) throws Exception {
        List<OutboundBridgePojo> nowOutboundBridgePojos = jmsBridgePojo.getOutboundBridgePojo();
        Map<String, OutboundQueueBridge> outboundQueueBridges = proxy.getOutboundQueueBridge();
        Map<String, OutboundTopicBridge> outboundTopicBridges = proxy.getOutboundTopicBridge();
        Iterator<OutboundBridgePojo> nowIt = nowOutboundBridgePojos.iterator();
        while (nowIt.hasNext()) {
            String selector;
            OutboundBridgePojo outboundBridgePojo = nowIt.next();
            if (outboundBridgePojo instanceof OutboundQueueBridgePojo) {
                OutboundQueueBridge outboundQueueBridge = outboundQueueBridges.get(outboundBridgePojo.getLocalName());
                if (outboundQueueBridge == null) continue;
                outboundQueueBridge.setOutboundJndiName(outboundBridgePojo.getOutboundJndiName());
                selector = outboundBridgePojo.getSelector();
                if (selector != null && !"".equals(selector)) {
                    outboundQueueBridge.setSelector(selector);
                } else {
                    outboundQueueBridge.setSelector(null);
                }
                nowIt.remove();
                outboundQueueBridges.remove(outboundBridgePojo.getLocalName());
                continue;
            }
            OutboundTopicBridge outboundTopicBridge = outboundTopicBridges.get(outboundBridgePojo.getLocalName());
            if (outboundTopicBridge == null) continue;
            outboundTopicBridge.setOutboundJndiName(outboundBridgePojo.getOutboundJndiName());
            selector = outboundBridgePojo.getSelector();
            if (selector != null && !"".equals(selector)) {
                outboundTopicBridge.setSelector(selector);
            } else {
                outboundTopicBridge.setSelector(null);
            }
            String consumerName = ((OutboundTopicBridgePojo)outboundBridgePojo).getConsumerName();
            if (consumerName != null && !"".equals(consumerName)) {
                outboundTopicBridge.setConsumerName(consumerName);
            } else {
                outboundTopicBridge.setConsumerName(null);
            }
            nowIt.remove();
            outboundTopicBridges.remove(outboundBridgePojo.getLocalName());
        }
        for (OutboundBridgePojo outboundBridgePojo : nowOutboundBridgePojos) {
            if (outboundBridgePojo instanceof OutboundQueueBridgePojo) {
                proxy.createChild("outbound-queue-bridge", Utils.pojo2map(outboundBridgePojo, new List[0]));
                continue;
            }
            proxy.createChild("outbound-topic-bridge", Utils.pojo2map(outboundBridgePojo, new List[0]));
        }
        Iterator<String> queueIterator = outboundQueueBridges.keySet().iterator();
        while (queueIterator.hasNext()) {
            proxy.removeChild("outbound-queue-bridge", queueIterator.next());
        }
        Iterator<String> topicIterator = outboundTopicBridges.keySet().iterator();
        while (topicIterator.hasNext()) {
            proxy.removeChild("outbound-topic-bridge", topicIterator.next());
        }
    }

    @Override
    public List<JmsBridgePojo> listAllJmsBridge() throws Exception {
        Map<String, JmsBridge> jmsBridges = this.jeemxHelper.getJmsBridges().getJmsBridge();
        ArrayList<JmsBridgePojo> pojos = new ArrayList<JmsBridgePojo>();
        for (JmsBridge next : jmsBridges.values()) {
            JmsBridgePojo pojo = this.createJmsBridgePojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    public List<InboundBridgePojo> listAllInboundQueueBridge(String jmsBridgeName) {
        Map<String, InboundQueueBridge> inboundQueueBridges = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName).getInboundBridges().getInboundQueueBridge();
        ArrayList<InboundBridgePojo> pojos = new ArrayList<InboundBridgePojo>();
        for (InboundQueueBridge next : inboundQueueBridges.values()) {
            InboundQueueBridgePojo pojo = this.createInboundQueueBridgePojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    public List<InboundBridgePojo> listAllInboundTopicBridge(String jmsBridgeName) {
        Map<String, InboundTopicBridge> inboundTopicBridges = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName).getInboundBridges().getInboundTopicBridge();
        ArrayList<InboundBridgePojo> pojos = new ArrayList<InboundBridgePojo>();
        for (InboundTopicBridge next : inboundTopicBridges.values()) {
            InboundTopicBridgePojo pojo = this.createInboundTopicBridgePojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    @Override
    public List<InboundBridgePojo> listAllInboundBridge(String jmsBridgeName) throws Exception {
        ArrayList<InboundBridgePojo> pojos = new ArrayList<InboundBridgePojo>();
        pojos.addAll(this.listAllInboundQueueBridge(jmsBridgeName));
        pojos.addAll(this.listAllInboundTopicBridge(jmsBridgeName));
        Collections.sort(pojos);
        return pojos;
    }

    private List<OutboundBridgePojo> listAllOutboundQueueBridge(String jmsBridgeName) {
        Map<String, OutboundQueueBridge> outboundQueueBridges = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName).getOutboundBridges().getOutboundQueueBridge();
        ArrayList<OutboundBridgePojo> pojos = new ArrayList<OutboundBridgePojo>();
        for (OutboundQueueBridge next : outboundQueueBridges.values()) {
            OutboundQueueBridgePojo pojo = this.createOutboundQueueBridgePojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    private List<OutboundBridgePojo> listAllOutboundTopicBridge(String jmsBridgeName) {
        Map<String, OutboundTopicBridge> outboundTopicBridges = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName).getOutboundBridges().getOutboundTopicBridge();
        ArrayList<OutboundBridgePojo> pojos = new ArrayList<OutboundBridgePojo>();
        for (OutboundTopicBridge next : outboundTopicBridges.values()) {
            OutboundTopicBridgePojo pojo = this.createOutboundTopicBridgePojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    @Override
    public List<OutboundBridgePojo> listAllOutboundBridge(String jmsBridgeName) throws Exception {
        ArrayList<OutboundBridgePojo> pojos = new ArrayList<OutboundBridgePojo>();
        pojos.addAll(this.listAllOutboundQueueBridge(jmsBridgeName));
        pojos.addAll(this.listAllOutboundTopicBridge(jmsBridgeName));
        Collections.sort(pojos);
        return pojos;
    }

    private InboundQueueBridgePojo createInboundQueueBridgePojo(InboundQueueBridge next) {
        InboundQueueBridgePojo pojo = new InboundQueueBridgePojo();
        pojo.setLocalName(next.getLocalName());
        pojo.setInboundJndiName(next.getInboundJndiName());
        pojo.setSelector(next.getSelector());
        return pojo;
    }

    private InboundTopicBridgePojo createInboundTopicBridgePojo(InboundTopicBridge next) {
        InboundTopicBridgePojo pojo = new InboundTopicBridgePojo();
        pojo.setLocalName(next.getLocalName());
        pojo.setInboundJndiName(next.getInboundJndiName());
        pojo.setSelector(next.getSelector());
        pojo.setConsumerName(next.getConsumerName());
        return pojo;
    }

    private OutboundQueueBridgePojo createOutboundQueueBridgePojo(OutboundQueueBridge next) {
        OutboundQueueBridgePojo pojo = new OutboundQueueBridgePojo();
        pojo.setLocalName(next.getLocalName());
        pojo.setOutboundJndiName(next.getOutboundJndiName());
        pojo.setSelector(next.getSelector());
        return pojo;
    }

    private OutboundTopicBridgePojo createOutboundTopicBridgePojo(OutboundTopicBridge next) {
        OutboundTopicBridgePojo pojo = new OutboundTopicBridgePojo();
        pojo.setLocalName(next.getLocalName());
        pojo.setOutboundJndiName(next.getOutboundJndiName());
        pojo.setSelector(next.getSelector());
        pojo.setConsumerName(next.getConsumerName());
        return pojo;
    }

    private JmsBridgePojo createJmsBridgePojo(JmsBridge next) throws Exception {
        JmsBridgePojo pojo = new JmsBridgePojo();
        OutboundJndiPropertiesPojo outboundJndiPropertiesPojo = new OutboundJndiPropertiesPojo();
        List<InboundBridgePojo> inboundBridgePojos = this.listAllInboundBridge(next.getName());
        List<OutboundBridgePojo> outboundBridgePojos = this.listAllOutboundBridge(next.getName());
        pojo.setName(next.getName());
        pojo.setLocalConnectionFactoryName(next.getLocalConnectionFactoryName());
        pojo.setOutboundClientId(next.getOutboundClientId());
        pojo.setLocalClientId(next.getLocalClientId());
        pojo.setOutboundConnectionFactoryJndiName(next.getOutboundConnectionFactoryJndiName());
        pojo.setOutboundUsername(next.getOutboundUsername());
        pojo.setOutboundPassword(next.getOutboundPassword());
        pojo.setInboundBridgePojo(inboundBridgePojos);
        pojo.setOutboundBridgePojo(outboundBridgePojos);
        pojo.setMaxReconnectAttempts(Utils.toInt(next.getMaxReconnectAttempts()));
        pojo.setMaxReconnectDelay(Utils.toInt(next.getMaxReconnectDelay()));
        pojo.setInitialReconnectDelay(Utils.toInt(next.getInitialReconnectDelay()));
        pojo.setBackOffMultiplier(Utils.toInt(next.getBackOffMultiplier()));
        JEEMXUtils.fillPropertyBag(outboundJndiPropertiesPojo, next.getOutboundJndiProperties());
        pojo.setOutboundJndiPropertiesPojo(outboundJndiPropertiesPojo);
        return pojo;
    }

    @Override
    public void addInboundBridge(String jmsBridgeName, String type, InboundBridgePojo pojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(pojo, new List[0]);
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        if (jmsBridge.getInboundBridges() == null) {
            jmsBridge.createChild("inbound-bridges", null);
        }
        if (Type.isQueue(type)) {
            jmsBridge.getInboundBridges().createChild("inbound-queue-bridge", pojo2map);
        } else {
            jmsBridge.getInboundBridges().createChild("inbound-topic-bridge", pojo2map);
        }
    }

    @Override
    public void addOutboundBridge(String jmsBridgeName, String type, OutboundBridgePojo pojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(pojo, new List[0]);
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        if (jmsBridge.getOutboundBridges() == null) {
            jmsBridge.createChild("outbound-bridges", null);
        }
        if (Type.isQueue(type)) {
            jmsBridge.getOutboundBridges().createChild("outbound-queue-bridge", pojo2map);
        } else {
            jmsBridge.getOutboundBridges().createChild("outbound-topic-bridge", pojo2map);
        }
    }

    @Override
    public void deleteInboundBridge(String jmsBridgeName, String type, String inboundJndiName) throws Exception {
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        if (Type.isQueue(type)) {
            jmsBridge.getInboundBridges().removeChild("inbound-queue-bridge", inboundJndiName);
        } else {
            jmsBridge.getInboundBridges().removeChild("inbound-topic-bridge", inboundJndiName);
        }
    }

    @Override
    public void deleteOutboundBridge(String jmsBridgeName, String type, String localName) throws Exception {
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        if (Type.isQueue(type)) {
            jmsBridge.getOutboundBridges().removeChild("outbound-queue-bridge", localName);
        } else {
            jmsBridge.getOutboundBridges().removeChild("outbound-topic-bridge", localName);
        }
    }

    @Override
    public boolean isJmsBridgeExist(String jmsBridgeName) throws Exception {
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        return jmsBridge != null;
    }

    @Override
    public boolean isJmsBridgeNotExist(String jmsBridgeName) throws Exception {
        JmsBridge jmsBridge = this.jeemxHelper.getJmsBridges().getJmsBridge().get(jmsBridgeName);
        return jmsBridge == null;
    }

    @Override
    public boolean isInboundJndiNameExist(String inboundJndiName, String jmsBridgeName) throws Exception {
        List<InboundBridgePojo> inboundBridgePojos = this.listAllInboundBridge(jmsBridgeName);
        if (inboundBridgePojos != null) {
            for (InboundBridgePojo inboundBridgePojo : inboundBridgePojos) {
                String InboundJndiName = inboundBridgePojo.getInboundJndiName();
                if (!InboundJndiName.equals(inboundJndiName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLocalDestinationExist(String localName, String jmsBridgeName) throws Exception {
        List<OutboundBridgePojo> outboundBridgePojos = this.listAllOutboundBridge(jmsBridgeName);
        if (outboundBridgePojos != null) {
            for (OutboundBridgePojo outboundBridgePojo : outboundBridgePojos) {
                if (!localName.equals(outboundBridgePojo.getLocalName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInboundJndiNameNotExist(String inboundJndiName, String jmsBridgeName, String type) throws Exception {
        List<InboundBridgePojo> inboundBridgePojos = null;
        inboundBridgePojos = Type.isQueue(type) ? this.listAllInboundQueueBridge(jmsBridgeName) : this.listAllInboundTopicBridge(jmsBridgeName);
        if (inboundBridgePojos != null) {
            for (InboundBridgePojo inboundBridgePojo : inboundBridgePojos) {
                String InboundJndiName = inboundBridgePojo.getInboundJndiName();
                if (!InboundJndiName.equals(inboundJndiName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isLocalDestinationNotExist(String localName, String jmsBridgeName, String type) throws Exception {
        List<OutboundBridgePojo> outboundBridgePojos = null;
        outboundBridgePojos = Type.isQueue(type) ? this.listAllOutboundQueueBridge(jmsBridgeName) : this.listAllOutboundTopicBridge(jmsBridgeName);
        if (outboundBridgePojos != null) {
            for (OutboundBridgePojo outboundBridgePojo : outboundBridgePojos) {
                if (!localName.equals(outboundBridgePojo.getLocalName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isLocalConnectionFactoryNotExist(String localConnectionFactoryName) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return !broker.isConnectionFactoryExist(localConnectionFactoryName);
    }

    @Override
    public List<String> getConnectionFactoryNames() throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.selectConectionFactoryNames();
    }
}

