/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.broker;

import com.bes.admin.jeemx.intf.config.SystemPropertiesAccess;
import com.bes.admin.jeemx.intf.config.SystemProperty;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.broker.BrokerFacade;
import com.bes.mq.admin.facade.api.broker.pojo.BrokerPojo;
import com.bes.mq.admin.facade.api.broker.pojo.Status;
import com.bes.mq.admin.facade.api.broker.pojo.SystemPropertyBagPojo;
import com.bes.mq.admin.facade.api.broker.pojo.SystemPropertyBagPojoSupport;
import com.bes.mq.admin.facade.api.broker.pojo.SystemPropertyPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.Broker;
import com.bes.mq.jeemx.config.intf.ext.BrokerRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BrokerFacadeImpl
extends BaseFacade
implements BrokerFacade {
    public BrokerFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public BrokerPojo getBroker() throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        BrokerPojo pojo = this.createBrokerPojo(broker);
        return pojo;
    }

    private BrokerPojo createBrokerPojo(Broker broker) {
        BrokerPojo pojo = new BrokerPojo();
        pojo.setBrokerName(broker.getBrokerName());
        pojo.setBrokerId(broker.getBrokerId());
        pojo.setSchedulerSupport(Utils.toBoolean(broker.getSchedulerSupport()));
        pojo.setDeleteAllMessagesOnStartup(Utils.toBoolean(broker.getDeleteAllMessagesOnStartup()));
        pojo.setNoSpaceWaitTime(Utils.toInt(broker.getNoSpaceWaitTime()));
        pojo.setOfflineDurableSubscriberTimeout(Utils.toInt(broker.getOfflineDurableSubscriberTimeout()));
        JEEMXUtils.fillPropertyBag(pojo, broker);
        this.fillSystemPropertyBag(pojo, broker);
        return pojo;
    }

    @Override
    public Status getStatus() throws Exception {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        return Status.toStatus(runtime.getBrokerStatus());
    }

    @Override
    public void restartBroker() throws Exception {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        runtime.restartBroker();
    }

    @Override
    public void stopBroker() throws Exception {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        runtime.stopBroker();
    }

    @Override
    public Map<String, String> getRuntimeInfo() {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        Map<String, String> info = runtime.getRuntimeInfo();
        return info;
    }

    @Override
    public void addSystemProperties(SystemPropertyBagPojo pojo) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        this.updateSystemProperties(broker, pojo, false);
    }

    @Override
    public void deleteSystemProperty(String name) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        broker.removeChild("system-property", name);
    }

    @Override
    public SystemPropertyBagPojo listAllSystemProperties() throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        SystemPropertyBagPojoSupport bag = new SystemPropertyBagPojoSupport();
        this.fillSystemPropertyBag(bag, broker);
        return bag;
    }

    @Override
    public void setBrokerAttributes(BrokerPojo pojo) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        broker.setBrokerId(pojo.getBrokerId());
        broker.setSchedulerSupport(String.valueOf(pojo.getSchedulerSupport()));
        broker.setDeleteAllMessagesOnStartup(String.valueOf(pojo.getDeleteAllMessagesOnStartup()));
        broker.setNoSpaceWaitTime(String.valueOf(pojo.getNoSpaceWaitTime()));
        broker.setOfflineDurableSubscriberTimeout(String.valueOf(pojo.getOfflineDurableSubscriberTimeout()));
        JEEMXUtils.updatePropertyBag(broker, pojo);
        this.updateSystemProperties(broker, pojo, true);
    }

    @Override
    public boolean isSystemPropertyExist(String propertyName) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.getSystemProperty().get(propertyName) != null;
    }

    private void fillSystemPropertyBag(SystemPropertyBagPojo pojo, SystemPropertiesAccess proxy) {
        Collection<SystemProperty> values = proxy.getSystemProperty().values();
        ArrayList<SystemPropertyPojo> lists = new ArrayList<SystemPropertyPojo>();
        for (SystemProperty p : values) {
            String name = p.getName();
            String value = p.getValue();
            String description = p.getDescription();
            SystemPropertyPojo propertyPojo = new SystemPropertyPojo(name, value, description);
            lists.add(propertyPojo);
        }
        Collections.sort(lists);
        pojo.setSystemProperties(lists);
    }

    private void updateSystemProperties(SystemPropertiesAccess proxy, SystemPropertyBagPojo pojo, boolean autoDelete) throws Exception {
        List<SystemPropertyPojo> now = pojo.getSystemProperties();
        ArrayList<SystemProperty> old = new ArrayList<SystemProperty>(proxy.getSystemProperty().values());
        Iterator<SystemPropertyPojo> nowIt = now.iterator();
        Iterator oldIt = old.iterator();
        block0: while (oldIt.hasNext()) {
            SystemProperty oldProp = (SystemProperty)oldIt.next();
            nowIt = now.iterator();
            while (nowIt.hasNext()) {
                SystemPropertyPojo nowProp = nowIt.next();
                if (!oldProp.getName().equals(nowProp.getName())) continue;
                oldProp.setValue(nowProp.getValue());
                oldIt.remove();
                nowIt.remove();
                continue block0;
            }
        }
        nowIt = now.iterator();
        while (nowIt.hasNext()) {
            proxy.createChild("system-property", Utils.pojo2map(nowIt.next(), new List[0]));
        }
        if (autoDelete) {
            oldIt = old.iterator();
            while (oldIt.hasNext()) {
                proxy.removeChild("system-property", ((SystemProperty)oldIt.next()).getName());
            }
        }
    }

    @Override
    public List<Map<String, String>> changeToSortList(String fileLook, int sortType) {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        List<Map<String, String>> fileList = runtime.changeToSortList(fileLook, sortType);
        return fileList;
    }

    @Override
    public List<Map<String, String>> changeToRootList() {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        List<Map<String, String>> fileList = runtime.changeToRootList();
        return fileList;
    }

    @Override
    public boolean judgeDirOrFileExists(String location, boolean isDir) {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        boolean exist = runtime.judgeDirOrFileExists(location, isDir);
        return exist;
    }

    @Override
    public String getSystemRoot() {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        String systemRoot = runtime.getSystemRoot();
        return systemRoot;
    }

    @Override
    public String getParentPath(String currentPath) {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        String parentPath = runtime.getParentPath(currentPath);
        return parentPath;
    }

    @Override
    public String[] getRestartReasons() {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        return runtime.getRestartReasons();
    }

    @Override
    public boolean validateJavaVersion(String javaHome) {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        return runtime.validateJavaVersion(javaHome);
    }

    @Override
    public String viewLog(int maxLines) {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        return runtime.viewLog(maxLines);
    }

    @Override
    public void deleteExpiredLogFiles() {
        BrokerRuntime runtime = this.jeemxHelper.getExtension().getBrokerRuntime();
        runtime.deleteExpiredLogFiles();
    }
}

