/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.cluster;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.cluster.ClusterConnectorFacade;
import com.bes.mq.admin.facade.api.cluster.pojo.ClusterConnectorPojo;
import com.bes.mq.admin.facade.api.cluster.pojo.FilterDestinationPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.ClusterConnector;
import com.bes.mq.jeemx.config.intf.ClusterConnectors;
import com.bes.mq.jeemx.config.intf.DynamicallyIncludedDestinations;
import com.bes.mq.jeemx.config.intf.ExcludedDestinations;
import com.bes.mq.jeemx.config.intf.FilterDestinations;
import com.bes.mq.jeemx.config.intf.FilterQueue;
import com.bes.mq.jeemx.config.intf.FilterTopic;
import com.bes.mq.jeemx.config.intf.StaticallyIncludedDestinations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterConnectorFacadeImpl
extends BaseFacade
implements ClusterConnectorFacade {
    private static final String FILTER_MODE_STATIC_INCLUDE = "staticInclude";
    private static final String FILTER_MODE_DYNAMIC_INCLUDE = "dynamicInclude";
    private static final String FILTER_MODE_EXCLUDE = "exclude";
    private static final String DESTINATION_TYPE_QUEUE = "queue";
    private static final String DESTINATION_TYPE_TOPIC = "topic";
    private static final String EXCLUDED_DESTINATIONS = "excluded-destinations";
    private static final String DYNAMICALLY_INCLUDE_DESTINATIONS = "dynamically-included-destinations";
    private static final String STATICALLY_INCLUDE_DESTINATIONS = "statically-included-destinations";

    public ClusterConnectorFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public ClusterConnectorPojo getClusterConnector(String name) throws Exception {
        ClusterConnectors clusterConnectors = this.jeemxHelper.getClusterConnectors();
        ClusterConnector clusterConnector = clusterConnectors.getClusterConnector().get(name);
        if (clusterConnector == null) {
            return null;
        }
        return this.createClusterConnectorPojo(clusterConnector);
    }

    private ClusterConnectorPojo createClusterConnectorPojo(ClusterConnector clusterConnector) {
        ClusterConnectorPojo clusterConnectorPojo = new ClusterConnectorPojo();
        clusterConnectorPojo.setName(clusterConnector.getName());
        clusterConnectorPojo.setUri(clusterConnector.getUri());
        clusterConnectorPojo.setDuplex(Boolean.valueOf(clusterConnector.getDuplex()));
        clusterConnectorPojo.setSyncSendPersistentMessage(Boolean.valueOf(clusterConnector.getSyncSendPersistentMessage()));
        clusterConnectorPojo.setSyncSendNonPersistentMessage(Boolean.valueOf(clusterConnector.getSyncSendNonPersistentMessage()));
        clusterConnectorPojo.setConduitSubscriptions(Boolean.valueOf(clusterConnector.getConduitSubscriptions()));
        clusterConnectorPojo.setDecreaseNetworkConsumerPriority(Boolean.valueOf(clusterConnector.getDecreaseNetworkConsumerPriority()));
        clusterConnectorPojo.setAsyncDispatch(Boolean.valueOf(clusterConnector.getAsyncDispatch()));
        clusterConnectorPojo.setNetworkTtl(Integer.parseInt(clusterConnector.getNetworkTtl()));
        clusterConnectorPojo.setPrefetchSize(Integer.parseInt(clusterConnector.getPrefetchSize()));
        clusterConnectorPojo.setUseCompression(Boolean.valueOf(clusterConnector.getUseCompression()));
        clusterConnectorPojo.setUsername(clusterConnector.getUsername());
        clusterConnectorPojo.setPassword(clusterConnector.getPassword());
        clusterConnectorPojo.setSuppressDuplicateQueueSubscriptions(Boolean.valueOf(clusterConnector.getSuppressDuplicateQueueSubscriptions()));
        clusterConnectorPojo.setSuppressDuplicateTopicSubscriptions(Boolean.valueOf(clusterConnector.getSuppressDuplicateTopicSubscriptions()));
        Map<String, FilterDestinationPojo> excludeDestinationMap = this.getClusterDestinationMap(clusterConnector.getExcludedDestinations(), clusterConnector.getName(), FILTER_MODE_EXCLUDE);
        Map<String, FilterDestinationPojo> staticIncludeDestinationMap = this.getClusterDestinationMap(clusterConnector.getStaticallyIncludedDestinations(), clusterConnector.getName(), FILTER_MODE_STATIC_INCLUDE);
        Map<String, FilterDestinationPojo> dynamicIncludeDestinationMap = this.getClusterDestinationMap(clusterConnector.getDynamicallyIncludedDestinations(), clusterConnector.getName(), FILTER_MODE_DYNAMIC_INCLUDE);
        clusterConnectorPojo.setExcludeDestinationMap(excludeDestinationMap);
        clusterConnectorPojo.setStaticIncludeDestinationMap(staticIncludeDestinationMap);
        clusterConnectorPojo.setDynamicIncludeDestinationMap(dynamicIncludeDestinationMap);
        JEEMXUtils.fillPropertyBag(clusterConnectorPojo, clusterConnector);
        return clusterConnectorPojo;
    }

    private Map<String, FilterDestinationPojo> getClusterDestinationMap(FilterDestinations clusterDestinations, String clusterConnectorName, String filterMode) {
        HashMap<String, FilterDestinationPojo> clusterDestinationMap = new HashMap<String, FilterDestinationPojo>();
        Map<String, FilterQueue> filterQueueDestinationMap = null;
        Map<String, FilterTopic> filterTopicDestinationMap = null;
        if (clusterDestinations != null) {
            FilterDestinationPojo destinationPojo;
            filterQueueDestinationMap = clusterDestinations.getFilterQueue();
            filterTopicDestinationMap = clusterDestinations.getFilterTopic();
            if (filterQueueDestinationMap != null) {
                for (FilterQueue filterQueue : filterQueueDestinationMap.values()) {
                    destinationPojo = new FilterDestinationPojo(clusterConnectorName, filterQueue.getName(), DESTINATION_TYPE_QUEUE, filterMode);
                    clusterDestinationMap.put(destinationPojo.getName() + DESTINATION_TYPE_QUEUE, destinationPojo);
                }
            }
            if (filterTopicDestinationMap != null) {
                for (FilterTopic filterTopic : filterTopicDestinationMap.values()) {
                    destinationPojo = new FilterDestinationPojo(clusterConnectorName, filterTopic.getName(), DESTINATION_TYPE_TOPIC, filterMode);
                    clusterDestinationMap.put(destinationPojo.getName() + DESTINATION_TYPE_TOPIC, destinationPojo);
                }
            }
        }
        return clusterDestinationMap;
    }

    @Override
    public boolean isClusterConnectorExit(String name) {
        ClusterConnectors clusterConnectors = this.jeemxHelper.getClusterConnectors();
        return null != clusterConnectors.getClusterConnector().get(name);
    }

    @Override
    public void createClusterConnector(ClusterConnectorPojo clusterConnectorPojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(clusterConnectorPojo, new List[0]);
        ClusterConnectors clusterConnectors = this.jeemxHelper.getClusterConnectors();
        ClusterConnector clusterConnector = clusterConnectors.createChild("cluster-connector", pojo2map).as(ClusterConnector.class);
        Map<String, FilterDestinationPojo> dynamicIncludeDestinationMap = clusterConnectorPojo.getDynamicIncludeDestinationMap();
        Map<String, FilterDestinationPojo> excludeDestinationMap = clusterConnectorPojo.getExcludeDestinationMap();
        Map<String, FilterDestinationPojo> staticIncludeDestinationMap = clusterConnectorPojo.getStaticIncludeDestinationMap();
        this.createFilterDestinations(dynamicIncludeDestinationMap, DYNAMICALLY_INCLUDE_DESTINATIONS, clusterConnector);
        this.createFilterDestinations(excludeDestinationMap, EXCLUDED_DESTINATIONS, clusterConnector);
        this.createFilterDestinations(staticIncludeDestinationMap, STATICALLY_INCLUDE_DESTINATIONS, clusterConnector);
        JEEMXUtils.applyPropertyBag(clusterConnector, clusterConnectorPojo);
    }

    private void createFilterDestinations(Map<String, FilterDestinationPojo> clusterDestinationMap, String destinationNode, ClusterConnector clusterConnector) throws Exception {
        if (!clusterDestinationMap.isEmpty()) {
            JEEMXConfigProxy proxy = clusterConnector.createChild(destinationNode, null);
            FilterDestinations dynamic = proxy.as(FilterDestinations.class);
            Set<Map.Entry<String, FilterDestinationPojo>> entrySet = clusterDestinationMap.entrySet();
            for (Map.Entry<String, FilterDestinationPojo> entry : entrySet) {
                Map<String, Object> pojo2map2 = Utils.pojo2map(entry.getValue(), new List[0]);
                pojo2map2.remove("destination-type");
                FilterDestinationPojo filterDestinationPojo = entry.getValue();
                if (DESTINATION_TYPE_QUEUE.equals(filterDestinationPojo.getDestinationType())) {
                    dynamic.createChild("filter-queue", pojo2map2);
                    continue;
                }
                dynamic.createChild("filter-topic", pojo2map2);
            }
        }
    }

    @Override
    public void deleteClusterConnector(String name) {
        ClusterConnectors clusterConnectors = this.jeemxHelper.getClusterConnectors();
        clusterConnectors.removeChild("cluster-connector", name);
    }

    @Override
    public List<ClusterConnectorPojo> listAllClusterConnector() {
        ArrayList<ClusterConnectorPojo> clusterConnectorPojoList = new ArrayList<ClusterConnectorPojo>();
        Map<String, ClusterConnector> clusterConnectorMap = this.jeemxHelper.getClusterConnectors().getClusterConnector();
        Iterator<ClusterConnector> iterator = clusterConnectorMap.values().iterator();
        ClusterConnectorPojo clusterConnectorPojo = null;
        while (iterator.hasNext()) {
            clusterConnectorPojo = this.createClusterConnectorPojo(iterator.next());
            clusterConnectorPojoList.add(clusterConnectorPojo);
        }
        Collections.sort(clusterConnectorPojoList);
        return clusterConnectorPojoList;
    }

    @Override
    public void updateClusterConnector(ClusterConnectorPojo clusterConnectorPojo) throws Exception {
        ClusterConnector clusterConnector = this.jeemxHelper.getClusterConnectors().getClusterConnector().get(clusterConnectorPojo.getName());
        clusterConnector.setSyncSendPersistentMessage(String.valueOf(clusterConnectorPojo.isSyncSendPersistentMessage()));
        clusterConnector.setSyncSendNonPersistentMessage(String.valueOf(clusterConnectorPojo.isSyncSendNonPersistentMessage()));
        clusterConnector.setConduitSubscriptions(String.valueOf(clusterConnectorPojo.isConduitSubscriptions()));
        if (clusterConnectorPojo.getPassword() != null) {
            clusterConnector.setPassword(clusterConnectorPojo.getPassword());
        }
        if (clusterConnectorPojo.getUsername() != null) {
            clusterConnector.setUsername(clusterConnectorPojo.getUsername());
        }
        clusterConnector.setDecreaseNetworkConsumerPriority(String.valueOf(clusterConnectorPojo.isDecreaseNetworkConsumerPriority()));
        clusterConnector.setAsyncDispatch(String.valueOf(clusterConnectorPojo.isAsyncDispatch()));
        clusterConnector.setDuplex(String.valueOf(clusterConnectorPojo.isDuplex()));
        clusterConnector.setNetworkTtl(String.valueOf(clusterConnectorPojo.getNetworkTtl()));
        clusterConnector.setPrefetchSize(String.valueOf(clusterConnectorPojo.getPrefetchSize()));
        clusterConnector.setSuppressDuplicateQueueSubscriptions(String.valueOf(clusterConnectorPojo.isSuppressDuplicateQueueSubscriptions()));
        clusterConnector.setSuppressDuplicateTopicSubscriptions(String.valueOf(clusterConnectorPojo.isSuppressDuplicateTopicSubscriptions()));
        clusterConnector.setUri(clusterConnectorPojo.getUri());
        clusterConnector.setUseCompression(String.valueOf(clusterConnectorPojo.isUseCompression()));
        ExcludedDestinations excludedDestinations = clusterConnector.getExcludedDestinations();
        this.updateFilterDestinations(excludedDestinations, EXCLUDED_DESTINATIONS, clusterConnector, clusterConnectorPojo.getExcludeDestinationMap());
        DynamicallyIncludedDestinations dynamicallyIncludedDestinations = clusterConnector.getDynamicallyIncludedDestinations();
        this.updateFilterDestinations(dynamicallyIncludedDestinations, DYNAMICALLY_INCLUDE_DESTINATIONS, clusterConnector, clusterConnectorPojo.getDynamicIncludeDestinationMap());
        StaticallyIncludedDestinations staticallyIncludedDestinations = clusterConnector.getStaticallyIncludedDestinations();
        this.updateFilterDestinations(staticallyIncludedDestinations, STATICALLY_INCLUDE_DESTINATIONS, clusterConnector, clusterConnectorPojo.getStaticIncludeDestinationMap());
        JEEMXUtils.updatePropertyBag(clusterConnector, clusterConnectorPojo);
    }

    private void updateFilterDestinations(FilterDestinations clusterDestinations, String destinationNode, ClusterConnector clusterConnector, Map<String, FilterDestinationPojo> filterMap) throws IllegalArgumentException, IllegalAccessException {
        Collection<FilterDestinationPojo> newValues = filterMap.values();
        if (clusterDestinations != null) {
            Map<String, FilterQueue> oldQueueMap = clusterDestinations.getFilterQueue();
            Map<String, FilterTopic> oldTopicMap = clusterDestinations.getFilterTopic();
            Collection<FilterQueue> oldQueueValues = oldQueueMap.values();
            Iterator<FilterQueue> oldQueueIterator = oldQueueValues.iterator();
            block0: while (oldQueueIterator.hasNext()) {
                FilterQueue oldNext = oldQueueIterator.next();
                Iterator<FilterDestinationPojo> newIterator = newValues.iterator();
                while (newIterator.hasNext()) {
                    FilterDestinationPojo newNext = newIterator.next();
                    if (!DESTINATION_TYPE_QUEUE.equals(newNext.getDestinationType()) || !oldNext.getName().equals(newNext.getName())) continue;
                    oldQueueIterator.remove();
                    newIterator.remove();
                    continue block0;
                }
            }
            Collection<FilterTopic> oldTopicValues = oldTopicMap.values();
            Iterator<FilterTopic> oldTopicIterator = oldTopicValues.iterator();
            block2: while (oldTopicIterator.hasNext()) {
                FilterTopic oldNext = oldTopicIterator.next();
                Iterator<FilterDestinationPojo> newIterator = newValues.iterator();
                while (newIterator.hasNext()) {
                    FilterDestinationPojo newNext = newIterator.next();
                    if (!DESTINATION_TYPE_TOPIC.equals(newNext.getDestinationType()) || !oldNext.getName().equals(newNext.getName())) continue;
                    oldTopicIterator.remove();
                    newIterator.remove();
                    continue block2;
                }
            }
            for (FilterDestinationPojo nowNext : newValues) {
                Map<String, Object> pojo2map = Utils.pojo2map(nowNext, new List[0]);
                pojo2map.remove("destination-type");
                if (DESTINATION_TYPE_QUEUE.equals(nowNext.getDestinationType())) {
                    clusterDestinations.createChild("filter-queue", pojo2map);
                    continue;
                }
                clusterDestinations.createChild("filter-topic", pojo2map);
            }
            Iterator<FilterQueue> oldQueueIt = oldQueueValues.iterator();
            while (oldQueueIt.hasNext()) {
                clusterDestinations.removeChild("filter-queue", oldQueueIt.next().getName());
            }
            Iterator<FilterTopic> oldTopicIt = oldTopicValues.iterator();
            while (oldTopicIt.hasNext()) {
                clusterDestinations.removeChild("filter-topic", oldTopicIt.next().getName());
            }
        } else {
            JEEMXConfigProxy proxy = clusterConnector.createChild(destinationNode, null);
            proxy.as(ExcludedDestinations.class);
            for (Map.Entry<String, FilterDestinationPojo> newEntry : filterMap.entrySet()) {
                FilterDestinationPojo filterDestinationPojo = newEntry.getValue();
                Map<String, Object> pojo2map = Utils.pojo2map(newEntry.getValue(), new List[0]);
                pojo2map.remove("destination-type");
                if (DESTINATION_TYPE_QUEUE.equals(filterDestinationPojo.getDestinationType())) {
                    proxy.createChild("filter-queue", pojo2map);
                    continue;
                }
                proxy.createChild("filter-topic", pojo2map);
            }
        }
    }
}

