/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.cluster;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.cluster.FilterDestinationFacade;
import com.bes.mq.admin.facade.api.cluster.pojo.ClusterConnectorPojo;
import com.bes.mq.admin.facade.api.cluster.pojo.FilterDestinationPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.ClusterConnector;
import com.bes.mq.jeemx.config.intf.DynamicallyIncludedDestinations;
import com.bes.mq.jeemx.config.intf.ExcludedDestinations;
import com.bes.mq.jeemx.config.intf.FilterDestinations;
import com.bes.mq.jeemx.config.intf.FilterQueue;
import com.bes.mq.jeemx.config.intf.FilterTopic;
import com.bes.mq.jeemx.config.intf.StaticallyIncludedDestinations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterDestinationFacadeImpl
extends BaseFacade
implements FilterDestinationFacade {
    private static final String FILTER_MODE_STATIC_INCLUDE = "staticInclude";
    private static final String FILTER_MODE_DYNAMIC_INCLUDE = "dynamicInclude";
    private static final String FILTER_MODE_EXCLUDE = "exclude";
    private static final String DESTINATION_TYPE_QUEUE = "queue";
    private static final String DESTINATION_TYPE_TOPIC = "topic";

    public FilterDestinationFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public boolean isFilterDestinationAlreadyExist(ClusterConnectorPojo clusterConnectorPojo, String destinationName, String destinationType, String filterMode) {
        boolean isExist = false;
        Map<String, FilterDestinationPojo> staticIncludeDestinationMap = clusterConnectorPojo.getStaticIncludeDestinationMap();
        Map<String, FilterDestinationPojo> dynamicIncludeDestinationMap = clusterConnectorPojo.getDynamicIncludeDestinationMap();
        Map<String, FilterDestinationPojo> excludeDestinationMap = clusterConnectorPojo.getExcludeDestinationMap();
        String name = destinationName + destinationType;
        if (FILTER_MODE_EXCLUDE.equals(filterMode)) {
            isExist = excludeDestinationMap.containsKey(name) && excludeDestinationMap.get(name).getDestinationType().equals(destinationType);
        } else if (FILTER_MODE_STATIC_INCLUDE.equals(filterMode)) {
            isExist = staticIncludeDestinationMap.containsKey(name) && staticIncludeDestinationMap.get(name).getDestinationType().equals(destinationType);
        } else if (FILTER_MODE_DYNAMIC_INCLUDE.equals(filterMode)) {
            isExist = dynamicIncludeDestinationMap.containsKey(name) && dynamicIncludeDestinationMap.get(name).getDestinationType().equals(destinationType);
        }
        return isExist;
    }

    @Override
    public void createFilterDestination(FilterDestinationPojo destinationPojo) throws Exception {
        ArrayList<String> permitFieldList = new ArrayList<String>();
        permitFieldList.add("name");
        Map<String, Object> pojo2map = Utils.pojo2map(destinationPojo, permitFieldList);
        ClusterConnector clusterConnector = this.jeemxHelper.getClusterConnectors().getClusterConnector().get(destinationPojo.getClusterConnector());
        if (FILTER_MODE_STATIC_INCLUDE.equals(destinationPojo.getFilterMode())) {
            if (DESTINATION_TYPE_QUEUE.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getStaticallyIncludedDestinations(clusterConnector).createChild("filter-queue", pojo2map);
            } else if (DESTINATION_TYPE_TOPIC.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getStaticallyIncludedDestinations(clusterConnector).createChild("filter-topic", pojo2map);
            }
        } else if (FILTER_MODE_DYNAMIC_INCLUDE.equals(destinationPojo.getFilterMode())) {
            if (DESTINATION_TYPE_QUEUE.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getDynamicallyIncludedDestinations(clusterConnector).createChild("filter-queue", pojo2map);
            } else if (DESTINATION_TYPE_TOPIC.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getDynamicallyIncludedDestinations(clusterConnector).createChild("filter-topic", pojo2map);
            }
        } else if (FILTER_MODE_EXCLUDE.equals(destinationPojo.getFilterMode())) {
            if (DESTINATION_TYPE_QUEUE.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getExcludedDestinations(clusterConnector).createChild("filter-queue", pojo2map);
            } else if (DESTINATION_TYPE_TOPIC.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getExcludedDestinations(clusterConnector).createChild("filter-topic", pojo2map);
            }
        }
    }

    @Override
    public void deleteFilterDestination(FilterDestinationPojo destinationPojo) throws Exception {
        ClusterConnector clusterConnector = this.jeemxHelper.getClusterConnectors().getClusterConnector().get(destinationPojo.getClusterConnector());
        if (FILTER_MODE_STATIC_INCLUDE.equals(destinationPojo.getFilterMode())) {
            if (DESTINATION_TYPE_QUEUE.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getStaticallyIncludedDestinations(clusterConnector).removeChild("filter-queue", destinationPojo.getName());
            } else if (DESTINATION_TYPE_TOPIC.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getStaticallyIncludedDestinations(clusterConnector).removeChild("filter-topic", destinationPojo.getName());
            }
        } else if (FILTER_MODE_DYNAMIC_INCLUDE.equals(destinationPojo.getFilterMode())) {
            if (DESTINATION_TYPE_QUEUE.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getDynamicallyIncludedDestinations(clusterConnector).removeChild("filter-queue", destinationPojo.getName());
            } else if (DESTINATION_TYPE_TOPIC.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getDynamicallyIncludedDestinations(clusterConnector).removeChild("filter-topic", destinationPojo.getName());
            }
        } else if (FILTER_MODE_EXCLUDE.equals(destinationPojo.getFilterMode())) {
            if (DESTINATION_TYPE_QUEUE.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getExcludedDestinations(clusterConnector).removeChild("filter-queue", destinationPojo.getName());
            } else if (DESTINATION_TYPE_TOPIC.equals(destinationPojo.getDestinationType())) {
                this.jeemxHelper.getExcludedDestinations(clusterConnector).removeChild("filter-topic", destinationPojo.getName());
            }
        }
    }

    @Override
    public Map<String, List<FilterDestinationPojo>> listFilterDestination(String clusterConnector) {
        HashMap<String, List<FilterDestinationPojo>> filterDestinationsMap = new HashMap<String, List<FilterDestinationPojo>>();
        ClusterConnector connector = this.jeemxHelper.getClusterConnectors().getClusterConnector().get(clusterConnector);
        StaticallyIncludedDestinations staticallyIncludedDestinations = connector.getStaticallyIncludedDestinations();
        this.fillDestinationsMap(filterDestinationsMap, staticallyIncludedDestinations, clusterConnector, FILTER_MODE_STATIC_INCLUDE);
        DynamicallyIncludedDestinations dynamicallyIncludedDestinations = connector.getDynamicallyIncludedDestinations();
        this.fillDestinationsMap(filterDestinationsMap, dynamicallyIncludedDestinations, clusterConnector, FILTER_MODE_DYNAMIC_INCLUDE);
        ExcludedDestinations excludedDestinations = connector.getExcludedDestinations();
        this.fillDestinationsMap(filterDestinationsMap, excludedDestinations, clusterConnector, FILTER_MODE_EXCLUDE);
        return filterDestinationsMap;
    }

    private void fillDestinationsMap(Map<String, List<FilterDestinationPojo>> filterDestinationsMap, FilterDestinations clusterDestinations, String clusterConnector, String filterMode) {
        ArrayList<FilterDestinationPojo> filterDestinationPojoList = new ArrayList<FilterDestinationPojo>();
        if (clusterDestinations != null) {
            for (FilterQueue filterQueue : clusterDestinations.getFilterQueue().values()) {
                filterDestinationPojoList.add(new FilterDestinationPojo(clusterConnector, filterQueue.getName(), DESTINATION_TYPE_QUEUE, filterMode));
            }
            for (FilterTopic filterTopic : clusterDestinations.getFilterTopic().values()) {
                filterDestinationPojoList.add(new FilterDestinationPojo(clusterConnector, filterTopic.getName(), DESTINATION_TYPE_TOPIC, filterMode));
            }
        }
        if (!filterDestinationPojoList.isEmpty()) {
            filterDestinationsMap.put(filterMode, filterDestinationPojoList);
        }
    }
}

