/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.connection;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.connection.ConnectionFactoryFacade;
import com.bes.mq.admin.facade.api.connection.pojo.ConnectionFactoryPojo;
import com.bes.mq.admin.facade.api.connection.pojo.PrefetchPolicyPojo;
import com.bes.mq.admin.facade.api.connection.pojo.RedeliveryPolicyPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.Broker;
import com.bes.mq.jeemx.config.intf.ConnectionFactories;
import com.bes.mq.jeemx.config.intf.ConnectionFactory;
import com.bes.mq.jeemx.config.intf.PrefetchPolicy;
import com.bes.mq.jeemx.config.intf.RedeliveryPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectionFactoryFacadeImpl
extends BaseFacade
implements ConnectionFactoryFacade {
    public ConnectionFactoryFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public List<ConnectionFactoryPojo> listAllConnectionFactory() throws Exception {
        Map<String, ConnectionFactory> factories = this.jeemxHelper.getConnectionFactories().getConnectionFactory();
        ArrayList<ConnectionFactoryPojo> pojos = new ArrayList<ConnectionFactoryPojo>(factories.size());
        for (ConnectionFactory next : factories.values()) {
            ConnectionFactoryPojo pojo = this.createConnectionFactoryPojo(next);
            pojos.add(pojo);
        }
        return pojos;
    }

    private ConnectionFactoryPojo createConnectionFactoryPojo(ConnectionFactory next) {
        ConnectionFactoryPojo pojo = new ConnectionFactoryPojo();
        pojo.setCloseTimeout(Utils.toInt(next.getCloseTimeout()));
        pojo.setPassword(next.getPassword());
        pojo.setUsername(next.getUsername());
        pojo.setAsyncDispatch(Utils.toBoolean(next.getAsyncDispatch()));
        PrefetchPolicy prefetchPolicy = next.getPrefetchPolicy();
        if (prefetchPolicy != null) {
            pojo.setPrefetchPolicyPojo(this.createPrefetchPolicyPojo(prefetchPolicy));
        }
        pojo.setExclusiveConsumer(Utils.toBoolean(next.getExclusiveConsumer()));
        pojo.setJndiName(next.getJndiName());
        RedeliveryPolicy redeliveryPolicy = next.getRedeliveryPolicy();
        if (redeliveryPolicy != null) {
            pojo.setRedeliveryPolicyPojo(this.createRedeliveryPolicyPojo(redeliveryPolicy));
        }
        pojo.setName(next.getName());
        pojo.setDeliveryMode(Utils.toInt(next.getDeliveryMode()));
        pojo.setProducerWindowSize(Utils.toInt(next.getProducerWindowSize()));
        pojo.setAsyncSendAck(Utils.toBoolean(next.getAsyncSendAck()));
        pojo.setSendTimeout(Utils.toInt(next.getSendTimeout()));
        pojo.setType(next.getType());
        pojo.setBrokerUrl(next.getBrokerUrl());
        pojo.setSyncSendPersistentMessage(Utils.toBoolean(next.isSyncSendPersistentMessage()));
        pojo.setSyncSendNonPersistentMessage(Utils.toBoolean(next.isSyncSendNonPersistentMessage()));
        pojo.setUseCompression(Utils.toBoolean(next.getUseCompression()));
        JEEMXUtils.fillPropertyBag(pojo, next);
        return pojo;
    }

    @Override
    public void createConnectionFactory(ConnectionFactoryPojo connectionFactoryPojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(connectionFactoryPojo, new List[0]);
        ConnectionFactories connectionFactories = this.jeemxHelper.getConnectionFactories();
        JEEMXConfigProxy proxy = connectionFactories.createChild("connection-factory", pojo2map);
        ConnectionFactory factory = proxy.as(ConnectionFactory.class);
        PrefetchPolicy prefetchPolicy = factory.getPrefetchPolicy();
        PrefetchPolicyPojo prefetchPolicyPojo = connectionFactoryPojo.getPrefetchPolicyPojo();
        if (prefetchPolicy != null) {
            prefetchPolicy.setDurableTopicPrefetch(String.valueOf(prefetchPolicyPojo.getDurableTopicPrefetch()));
            prefetchPolicy.setTopicPrefetch(String.valueOf(prefetchPolicyPojo.getTopicPrefetch()));
            prefetchPolicy.setQueuePrefetch(String.valueOf(prefetchPolicyPojo.getQueuePrefetch()));
        } else {
            Map<String, Object> prefetchMap = Utils.pojo2map(prefetchPolicyPojo, new List[0]);
            proxy.createChild("prefetch-policy", prefetchMap);
        }
        RedeliveryPolicy redeliveryPolicy = factory.getRedeliveryPolicy();
        RedeliveryPolicyPojo redeliveryPolicyPojo = connectionFactoryPojo.getRedeliveryPolicyPojo();
        if (redeliveryPolicy != null) {
            redeliveryPolicy.setRedeliveryInterval(String.valueOf(redeliveryPolicyPojo.getRedeliveryInterval()));
            redeliveryPolicy.setMaxRedeliveries(String.valueOf(redeliveryPolicyPojo.getMaxRedeliveries()));
            redeliveryPolicy.setMaxRedeliveryInterval(String.valueOf(redeliveryPolicyPojo.getRedeliveryInterval()));
            redeliveryPolicy.setBackOffMultiplier(String.valueOf(redeliveryPolicyPojo.getBackOffMultiplier()));
        } else {
            Map<String, Object> redeliveryMap = Utils.pojo2map(redeliveryPolicyPojo, new List[0]);
            proxy.createChild("redelivery-policy", redeliveryMap);
        }
        JEEMXUtils.applyPropertyBag(proxy, connectionFactoryPojo);
    }

    @Override
    public void deleteConnectionFactory(String name) throws Exception {
        ConnectionFactories connectionFactories = this.jeemxHelper.getConnectionFactories();
        connectionFactories.removeChild("connection-factory", name);
    }

    @Override
    public boolean isConnectionFactoryExist(String name) throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory(name);
        return connectionFactory != null;
    }

    private PrefetchPolicyPojo createPrefetchPolicyPojo(PrefetchPolicy prefetchPolicy) {
        PrefetchPolicyPojo pojo = new PrefetchPolicyPojo();
        pojo.setDurableTopicPrefetch(Utils.toInt(prefetchPolicy.getDurableTopicPrefetch()));
        pojo.setQueuePrefetch(Utils.toInt(prefetchPolicy.getQueuePrefetch()));
        pojo.setTopicPrefetch(Utils.toInt(prefetchPolicy.getTopicPrefetch()));
        return pojo;
    }

    private RedeliveryPolicyPojo createRedeliveryPolicyPojo(RedeliveryPolicy redeliveryPolicy) {
        RedeliveryPolicyPojo pojo = new RedeliveryPolicyPojo();
        pojo.setMaxRedeliveries(Utils.toInt(redeliveryPolicy.getMaxRedeliveries()));
        pojo.setRedeliveryInterval(Utils.toInt(redeliveryPolicy.getRedeliveryInterval()));
        pojo.setMaxRedeliveryInterval(Utils.toInt(redeliveryPolicy.getMaxRedeliveryInterval()));
        pojo.setBackOffMultiplier(Utils.toInt(redeliveryPolicy.getBackOffMultiplier()));
        return pojo;
    }

    @Override
    public void updateConnectionFactory(ConnectionFactoryPojo pojo) throws Exception {
        Map<String, ConnectionFactory> factories = this.jeemxHelper.getConnectionFactories().getConnectionFactory();
        Iterator<ConnectionFactory> iterator = factories.values().iterator();
        ConnectionFactory connectionFactory = null;
        while (iterator.hasNext()) {
            connectionFactory = iterator.next();
            if (!connectionFactory.getName().equals(pojo.getName())) continue;
            connectionFactory.setCloseTimeout(String.valueOf(pojo.getCloseTimeout()));
            connectionFactory.setAsyncDispatch(String.valueOf(pojo.isAsyncDispatch()));
            connectionFactory.setExclusiveConsumer(String.valueOf(pojo.getExclusiveConsumer()));
            connectionFactory.setJndiName(pojo.getJndiName());
            connectionFactory.setDeliveryMode(String.valueOf(pojo.getDeliveryMode()));
            JEEMXUtils.updatePropertyBag(connectionFactory, pojo);
            connectionFactory.setAsyncSendAck(String.valueOf(pojo.isAsyncSendAck()));
            connectionFactory.setSendTimeout(String.valueOf(pojo.getSendTimeout()));
            connectionFactory.setType(pojo.getType());
            connectionFactory.setSyncSendPersistentMessage(String.valueOf(pojo.isSyncSendPersistentMessage()));
            connectionFactory.setSyncSendNonPersistentMessage(String.valueOf(pojo.isSyncSendNonPersistentMessage()));
            connectionFactory.setUseCompression(String.valueOf(pojo.getUseCompression()));
            connectionFactory.setProducerWindowSize(String.valueOf(pojo.getProducerWindowSize()));
            PrefetchPolicyPojo prefetchPolicyPojo = pojo.getPrefetchPolicyPojo();
            connectionFactory.getPrefetchPolicy().setDurableTopicPrefetch(String.valueOf(prefetchPolicyPojo.getDurableTopicPrefetch()));
            connectionFactory.getPrefetchPolicy().setTopicPrefetch(String.valueOf(prefetchPolicyPojo.getTopicPrefetch()));
            connectionFactory.getPrefetchPolicy().setQueuePrefetch(String.valueOf(prefetchPolicyPojo.getQueuePrefetch()));
            RedeliveryPolicyPojo redeliveryPolicyPojo = pojo.getRedeliveryPolicyPojo();
            connectionFactory.getRedeliveryPolicy().setMaxRedeliveries(String.valueOf(redeliveryPolicyPojo.getMaxRedeliveries()));
            connectionFactory.getRedeliveryPolicy().setRedeliveryInterval(String.valueOf(redeliveryPolicyPojo.getRedeliveryInterval()));
            connectionFactory.getRedeliveryPolicy().setMaxRedeliveryInterval(String.valueOf(redeliveryPolicyPojo.getMaxRedeliveryInterval()));
            connectionFactory.getRedeliveryPolicy().setBackOffMultiplier(String.valueOf(redeliveryPolicyPojo.getBackOffMultiplier()));
            if (pojo.getPassword() != null) {
                connectionFactory.setPassword(pojo.getPassword());
            }
            if (pojo.getUsername() != null) {
                connectionFactory.setUsername(pojo.getUsername());
            }
            connectionFactory.setBrokerUrl(pojo.getBrokerUrl());
            break;
        }
    }

    private ConnectionFactory getConnectionFactory(String name) {
        Map<String, ConnectionFactory> factories = this.jeemxHelper.getConnectionFactories().getConnectionFactory();
        return factories.get(name);
    }

    @Override
    public ConnectionFactoryPojo getConnectionFactoryPojo(String name) throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory(name);
        if (connectionFactory == null) {
            return null;
        }
        return this.createConnectionFactoryPojo(connectionFactory);
    }

    @Override
    public String getJmsBridgeNamesByConnectionFactoryName(String name) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.getJmsBridgeNamesByConnectionFactoryName(name);
    }

    @Override
    public boolean isJndiNameUsed(String jndiName) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.isJndiNameUsed(jndiName);
    }

    @Override
    public boolean isJndiNameChanged(String connectionFactoryName, String jndiName) throws Exception {
        ConnectionFactory connectionFactory = this.jeemxHelper.getBroker().getConnectionResource().getConnectionFactories().getConnectionFactory().get(connectionFactoryName);
        String jndiNameTemp = connectionFactory.getJndiName();
        return (jndiNameTemp != null || !jndiName.equals("")) && (jndiNameTemp == null || !jndiNameTemp.equals(jndiName));
    }
}

