/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.connection;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.connection.PooledConnectionFactoryFacade;
import com.bes.mq.admin.facade.api.connection.pojo.PooledConnectionFactoryPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.Broker;
import com.bes.mq.jeemx.config.intf.ConnectionPool;
import com.bes.mq.jeemx.config.intf.ConnectionPools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PooledConnectionFactoryFacadeImpl
extends BaseFacade
implements PooledConnectionFactoryFacade {
    public PooledConnectionFactoryFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public List<PooledConnectionFactoryPojo> listAllPooledConnectionFactory() throws Exception {
        Map<String, ConnectionPool> factories = this.jeemxHelper.getConnectionPools().getConnectionPool();
        ArrayList<PooledConnectionFactoryPojo> pojos = new ArrayList<PooledConnectionFactoryPojo>(factories.size());
        for (ConnectionPool next : factories.values()) {
            PooledConnectionFactoryPojo pojo = this.createPooledConnectionFactoryPojo(next);
            pojos.add(pojo);
        }
        return pojos;
    }

    private PooledConnectionFactoryPojo createPooledConnectionFactoryPojo(ConnectionPool next) {
        PooledConnectionFactoryPojo pojo = new PooledConnectionFactoryPojo();
        pojo.setName(next.getName());
        pojo.setJndiName(next.getJndiName());
        pojo.setConnectionFactory(next.getConnectionFactory());
        pojo.setMaxSessionsPerConnection(Utils.toInt(next.getMaxSessionsPerConnection()));
        pojo.setIdleTimeout(Utils.toInt(next.getIdleTimeout()));
        pojo.setBlockClient(Utils.toBoolean(next.getBlockClient()));
        pojo.setMaxConnections(Utils.toInt(next.getMaxConnections()));
        pojo.setCheckPeriod(Utils.toInt(next.getCheckPeriod()));
        pojo.setLeakTimeout(Utils.toInt(next.getLeakTimeout()));
        return pojo;
    }

    @Override
    public void createPooledConnectionFactory(PooledConnectionFactoryPojo PooledConnectionFactoryPojo2) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(PooledConnectionFactoryPojo2, new List[0]);
        ConnectionPools connectionPools = this.jeemxHelper.getConnectionPools();
        connectionPools.createChild("connection-pool", pojo2map);
    }

    @Override
    public void deletePooledConnectionFactory(String name) throws Exception {
        ConnectionPools connectionPools = this.jeemxHelper.getConnectionPools();
        connectionPools.removeChild("connection-pool", name);
    }

    @Override
    public boolean isPooledConnectionFactoryExist(String name) throws Exception {
        ConnectionPool PooledConnectionFactory = this.getPooledConnectionFactory(name);
        return PooledConnectionFactory != null;
    }

    @Override
    public void updatePooledConnectionFactory(PooledConnectionFactoryPojo pojo) throws Exception {
        Map<String, ConnectionPool> factories = this.jeemxHelper.getConnectionPools().getConnectionPool();
        Iterator<ConnectionPool> iterator = factories.values().iterator();
        ConnectionPool pooledConnectionFactory = null;
        while (iterator.hasNext()) {
            pooledConnectionFactory = iterator.next();
            if (!pooledConnectionFactory.getName().equals(pojo.getName())) continue;
            pooledConnectionFactory.setJndiName(pojo.getJndiName());
            pooledConnectionFactory.setConnectionFactory(pojo.getConnectionFactory());
            pooledConnectionFactory.setMaxSessionsPerConnection(String.valueOf(pojo.getMaxSessionsPerConnection()));
            pooledConnectionFactory.setIdleTimeout(String.valueOf(pojo.getIdleTimeout()));
            pooledConnectionFactory.setBlockClient(String.valueOf(pojo.isBlockClient()));
            pooledConnectionFactory.setMaxConnections(String.valueOf(pojo.getMaxConnections()));
            pooledConnectionFactory.setCheckPeriod(String.valueOf(pojo.getCheckPeriod()));
            pooledConnectionFactory.setLeakTimeout(String.valueOf(pojo.getLeakTimeout()));
            break;
        }
    }

    private ConnectionPool getPooledConnectionFactory(String name) {
        Map<String, ConnectionPool> factories = this.jeemxHelper.getConnectionPools().getConnectionPool();
        return factories.get(name);
    }

    @Override
    public PooledConnectionFactoryPojo getPooledConnectionFactoryPojo(String name) throws Exception {
        ConnectionPool PooledConnectionFactory = this.getPooledConnectionFactory(name);
        if (PooledConnectionFactory == null) {
            return null;
        }
        return this.createPooledConnectionFactoryPojo(PooledConnectionFactory);
    }

    @Override
    public boolean isJndiNameUsed(String jndiName) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.isJndiNameUsed(jndiName);
    }

    @Override
    public boolean isJndiNameChanged(String PooledConnectionFactoryName, String jndiName) throws Exception {
        ConnectionPool PooledConnectionFactory = this.jeemxHelper.getBroker().getConnectionResource().getConnectionPools().getConnectionPool().get(PooledConnectionFactoryName);
        String jndiNameTemp = PooledConnectionFactory.getJndiName();
        return (jndiNameTemp != null || !jndiName.equals("")) && (jndiNameTemp == null || !jndiNameTemp.equals(jndiName));
    }

    @Override
    public List<String> getConnectionFactoryNames() throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.selectConectionFactoryNames();
    }
}

