/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.connector;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.connector.ConnectorFacade;
import com.bes.mq.admin.facade.api.connector.pojo.ProtocolType;
import com.bes.mq.admin.facade.api.connector.pojo.TransportConnectorPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.TransportConnector;
import com.bes.mq.jeemx.config.intf.TransportConnectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConnectorFacadeImpl
extends BaseFacade
implements ConnectorFacade {
    public ConnectorFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void createTransportConnector(TransportConnectorPojo pojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(pojo, new List[0]);
        if (ProtocolType.isUdp(pojo.getProtocol())) {
            pojo2map.remove("enable-ssl");
        }
        TransportConnectors transportConnectors = this.jeemxHelper.getTransportConnectors();
        JEEMXConfigProxy proxy = transportConnectors.createChild("transport-connector", pojo2map);
        JEEMXUtils.applyPropertyBag(proxy, pojo);
    }

    @Override
    public void deleteTransportConnector(String name) throws Exception {
        TransportConnectors transportConnectors = this.jeemxHelper.getTransportConnectors();
        transportConnectors.removeChild("transport-connector", name);
    }

    @Override
    public void updateTransportConnector(TransportConnectorPojo transportConnectorPojo) throws Exception {
        TransportConnectors transportConnectors = this.jeemxHelper.getTransportConnectors();
        TransportConnector transportConnector = transportConnectors.getTransportConnector().get(transportConnectorPojo.getName());
        transportConnector.setProtocol(transportConnectorPojo.getProtocol());
        transportConnector.setListenAddress(transportConnectorPojo.getListenAddress());
        transportConnector.setPublishHostname(transportConnectorPojo.getPublishHostname());
        transportConnector.setListenPort(String.valueOf(transportConnectorPojo.getListenPort()));
        transportConnector.setAuditNetworkProducers(String.valueOf(transportConnectorPojo.getAuditNetworkProducers()));
        transportConnector.setAsyncDispatch(String.valueOf(transportConnectorPojo.getAsyncDispatch()));
        transportConnector.setDiscoverable(String.valueOf(transportConnectorPojo.getDiscoverable()));
        transportConnector.setDynamicUpdateClients(String.valueOf(transportConnectorPojo.getDynamicUpdateClients()));
        transportConnector.setMulticastAddress(transportConnectorPojo.getMulticastAddress());
        transportConnector.setMulticastPort(String.valueOf(transportConnectorPojo.getMulticastPort()));
        transportConnector.setMulticastGroup(transportConnectorPojo.getMulticastGroup());
        transportConnector.setCertNickName(transportConnectorPojo.getCertNickName());
        transportConnector.setEnableJms(String.valueOf(transportConnectorPojo.getEnableJms()));
        if (!ProtocolType.isUdp(transportConnectorPojo.getProtocol())) {
            transportConnector.setEnableSsl(String.valueOf(transportConnectorPojo.getEnableSsl()));
        }
        transportConnector.setSocketType(transportConnectorPojo.getSocketType());
        JEEMXUtils.updatePropertyBag(transportConnector, transportConnectorPojo);
    }

    @Override
    public List<TransportConnectorPojo> listAllTransportConnector() throws Exception {
        TransportConnectors connectors = this.jeemxHelper.getTransportConnectors();
        Iterator<TransportConnector> iterator = connectors.getTransportConnector().values().iterator();
        ArrayList<TransportConnectorPojo> pojos = new ArrayList<TransportConnectorPojo>();
        while (iterator.hasNext()) {
            TransportConnector next = iterator.next();
            TransportConnectorPojo pojo = this.createTransportConnectorPojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    @Override
    public TransportConnectorPojo getTransportConnector(String name) throws Exception {
        TransportConnectors transportConnectors = this.jeemxHelper.getTransportConnectors();
        TransportConnector transportConnector = transportConnectors.getTransportConnector().get(name);
        if (transportConnector == null) {
            return null;
        }
        return this.createTransportConnectorPojo(transportConnector);
    }

    public List<Integer> getTransportConnectorPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        TransportConnectors transportConnectors = this.jeemxHelper.getTransportConnectors();
        Map<String, TransportConnector> transportConnectorMap = transportConnectors.getTransportConnector();
        for (TransportConnector transportConnector : transportConnectorMap.values()) {
            ports.add(Utils.toInt(transportConnector.getListenPort()));
        }
        ports.add(Integer.parseInt(this.jeemxHelper.getJmxService().getListenPort()));
        return ports;
    }

    private TransportConnectorPojo createTransportConnectorPojo(TransportConnector next) {
        TransportConnectorPojo pojo = new TransportConnectorPojo();
        pojo.setName(next.getName());
        pojo.setProtocol(next.getProtocol());
        pojo.setListenAddress(next.getListenAddress());
        pojo.setPublishHostname(next.getPublishHostname());
        pojo.setListenPort(Utils.toInt(next.getListenPort()));
        pojo.setAuditNetworkProducers(Utils.toBoolean(next.getAuditNetworkProducers()));
        pojo.setAsyncDispatch(Utils.toBoolean(next.getAsyncDispatch()));
        pojo.setDiscoverable(Utils.toBoolean(next.getDiscoverable()));
        pojo.setDynamicUpdateClients(Utils.toBoolean(next.getDynamicUpdateClients()));
        pojo.setMulticastAddress(next.getMulticastAddress());
        pojo.setMulticastPort(Utils.toInt(next.getMulticastPort()));
        pojo.setMulticastGroup(next.getMulticastGroup());
        pojo.setCertNickName(next.getCertNickName());
        pojo.setEnableJms(Boolean.valueOf(next.getEnableJms()));
        if (!ProtocolType.isUdp(next.getProtocol())) {
            pojo.setEnableSsl(Boolean.valueOf(next.getEnableSsl()));
        }
        if (ProtocolType.isTcp(next.getProtocol()) || ProtocolType.isStomp(next.getProtocol()) || ProtocolType.isMqtt(next.getProtocol())) {
            pojo.setSocketType(next.getSocketType());
        }
        JEEMXUtils.fillPropertyBag(pojo, next);
        return pojo;
    }

    @Override
    public boolean isConnectorExist(String name) throws Exception {
        return this.getTransportConnector(name) != null;
    }

    @Override
    public boolean isPortAlreadyUsed(int port) throws Exception {
        List<Integer> ports = this.getTransportConnectorPorts();
        for (Integer iport : ports) {
            if (iport != port) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectorNotExist(String name) throws Exception {
        return this.getTransportConnector(name) == null;
    }
}

