/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.destinations;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.connection.pojo.ConnectionFactoryPojo;
import com.bes.mq.admin.facade.api.destinations.DestinationsFacade;
import com.bes.mq.admin.facade.api.destinations.pojo.CompositeDestinationPojo;
import com.bes.mq.admin.facade.api.destinations.pojo.CompositeQueuePojo;
import com.bes.mq.admin.facade.api.destinations.pojo.CompositeTopicPojo;
import com.bes.mq.admin.facade.api.destinations.pojo.DestinationPojo;
import com.bes.mq.admin.facade.api.destinations.pojo.ForwardDestinationPojo;
import com.bes.mq.admin.facade.api.destinations.pojo.ForwardQueuePojo;
import com.bes.mq.admin.facade.api.destinations.pojo.ForwardTopicPojo;
import com.bes.mq.admin.facade.api.destinations.pojo.QueuePojo;
import com.bes.mq.admin.facade.api.destinations.pojo.TopicPojo;
import com.bes.mq.admin.facade.api.destinations.pojo.Type;
import com.bes.mq.admin.facade.api.policy.pojo.PolicyPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.connection.ConnectionFactoryFacadeImpl;
import com.bes.mq.admin.facade.impl.jeemx.policy.PoliciesFacadeImpl;
import com.bes.mq.jeemx.config.intf.Broker;
import com.bes.mq.jeemx.config.intf.CompositeQueue;
import com.bes.mq.jeemx.config.intf.CompositeTopic;
import com.bes.mq.jeemx.config.intf.Destinations;
import com.bes.mq.jeemx.config.intf.ForwardQueue;
import com.bes.mq.jeemx.config.intf.ForwardTopic;
import com.bes.mq.jeemx.config.intf.Queue;
import com.bes.mq.jeemx.config.intf.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DestinationsFacadeImpl
extends BaseFacade
implements DestinationsFacade {
    public DestinationsFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void createQueue(QueuePojo queuePojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(queuePojo, new List[0]);
        Destinations destinations = this.jeemxHelper.getDestinations();
        destinations.createChild("queue", pojo2map);
    }

    @Override
    public void createTopic(TopicPojo topicPojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(topicPojo, new List[0]);
        Destinations destinations = this.jeemxHelper.getDestinations();
        destinations.createChild("topic", pojo2map);
    }

    @Override
    public void createCompositeTopic(CompositeTopicPojo pojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(pojo, new List[0]);
        Destinations destinations = this.jeemxHelper.getDestinations();
        JEEMXConfigProxy proxy = destinations.createChild("composite-topic", pojo2map);
        for (ForwardDestinationPojo forward : pojo.getForwardDestinationList()) {
            this.addForwardDestination(proxy, forward);
        }
    }

    @Override
    public void createCompositeQueue(CompositeQueuePojo pojo) throws Exception {
        Map<String, Object> pojo2map = Utils.pojo2map(pojo, new List[0]);
        Destinations destinations = this.jeemxHelper.getDestinations();
        JEEMXConfigProxy proxy = destinations.createChild("composite-queue", pojo2map);
        for (ForwardDestinationPojo forward : pojo.getForwardDestinationList()) {
            this.addForwardDestination(proxy, forward);
        }
    }

    private void addForwardDestination(JEEMXConfigProxy parent, ForwardDestinationPojo pojo) throws Exception {
        Map<String, Object> forwardPojo2map = Utils.pojo2map(pojo, new List[0]);
        if (Type.isQueue(pojo.getType())) {
            parent.createChild("forward-queue", forwardPojo2map);
        } else {
            parent.createChild("forward-topic", forwardPojo2map);
        }
    }

    @Override
    public void addForwardDestination(String compositeDestinationType, String compositeDestinationName, ForwardDestinationPojo pojo) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        JEEMXConfigProxy parent = null;
        parent = Type.isQueue(compositeDestinationType) ? (JEEMXConfigProxy)destinations.getCompositeQueue().get(compositeDestinationName) : (JEEMXConfigProxy)destinations.getCompositeTopic().get(compositeDestinationName);
        this.addForwardDestination(parent, pojo);
    }

    @Override
    public void deleteQueue(String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        destinations.removeChild("queue", name);
    }

    @Override
    public void deleteTopic(String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        destinations.removeChild("topic", name);
    }

    @Override
    public void deleteCompositeQueue(String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        destinations.removeChild("composite-queue", name);
    }

    @Override
    public void deleteCompositeTopic(String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        destinations.removeChild("composite-topic", name);
    }

    @Override
    public void deleteForwardDestination(String compositeDestinationType, String compositeDestinationName, String type, String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        JEEMXConfigProxy parent = null;
        parent = Type.isQueue(compositeDestinationType) ? (JEEMXConfigProxy)destinations.getCompositeQueue().get(compositeDestinationName) : (JEEMXConfigProxy)destinations.getCompositeTopic().get(compositeDestinationName);
        if (Type.isQueue(type)) {
            parent.removeChild("forward-queue", name);
        } else {
            parent.removeChild("forward-topic", name);
        }
    }

    @Override
    public QueuePojo getQueue(String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        Queue queue = destinations.getQueue().get(name);
        if (queue == null) {
            return null;
        }
        return this.createQueuePojo(queue);
    }

    @Override
    public TopicPojo getTopic(String name) throws Exception {
        Destinations destinations = this.jeemxHelper.getDestinations();
        Topic topic = destinations.getTopic().get(name);
        if (topic == null) {
            return null;
        }
        return this.createTopicPojo(topic);
    }

    @Override
    public CompositeQueuePojo getCompositeQueue(String name) {
        Destinations destinations = this.jeemxHelper.getDestinations();
        CompositeQueue queue = destinations.getCompositeQueue().get(name);
        if (queue == null) {
            return null;
        }
        return this.createCompositeQueuePojo(queue);
    }

    @Override
    public CompositeTopicPojo getCompositeTopic(String name) {
        Destinations destinations = this.jeemxHelper.getDestinations();
        CompositeTopic topic = destinations.getCompositeTopic().get(name);
        if (topic == null) {
            return null;
        }
        return this.createCompositeTopicPojo(topic);
    }

    @Override
    public ForwardDestinationPojo getForwardDestination(Type compositeType, String compositeName, Type type, String name) {
        Destinations destinations = this.jeemxHelper.getDestinations();
        if (Type.isQueue(compositeType)) {
            CompositeQueue parent = destinations.getCompositeQueue().get(compositeName);
            return Type.isQueue(type) ? this.createForwardQueuePojo(parent.getForwardQueue().get(name)) : this.createForwardTopicPojo(parent.getForwardTopic().get(name));
        }
        CompositeTopic parent = destinations.getCompositeTopic().get(compositeName);
        return Type.isQueue(type) ? this.createForwardQueuePojo(parent.getForwardQueue().get(name)) : this.createForwardTopicPojo(parent.getForwardTopic().get(name));
    }

    private PolicyPojo getPolicy(String policyRef, String type) throws Exception {
        PoliciesFacadeImpl facade = new PoliciesFacadeImpl(this.jeemxHelper);
        PolicyPojo policyPojo = facade.getPolicyPojo(policyRef, type);
        return policyPojo;
    }

    private QueuePojo createQueuePojo(Queue queue) {
        QueuePojo pojo = new QueuePojo();
        pojo.setName(queue.getName());
        pojo.setJndiName(queue.getJndiName());
        pojo.setPolicyRef(queue.getPolicyRef());
        pojo.setDescription(queue.getDescription());
        pojo.setMirror(Utils.toBoolean(queue.getMirror()));
        pojo.setMirrorName(queue.getMirroredName());
        return pojo;
    }

    private TopicPojo createTopicPojo(Topic topic) {
        TopicPojo pojo = new TopicPojo();
        pojo.setName(topic.getName());
        pojo.setJndiName(topic.getJndiName());
        pojo.setPolicyRef(topic.getPolicyRef());
        pojo.setDescription(topic.getDescription());
        pojo.setVirtual(Utils.toBoolean(topic.getVirtual()));
        pojo.setVirtualName(topic.getVirtualName());
        return pojo;
    }

    private CompositeTopicPojo createCompositeTopicPojo(CompositeTopic topic) {
        CompositeTopicPojo pojo = new CompositeTopicPojo();
        pojo.setName(topic.getName());
        pojo.setJndiName(topic.getJndiName());
        pojo.setForwardOnly(Utils.toBoolean(topic.getForwardOnly()));
        List<ForwardDestinationPojo> forwards = this.createForwardDestinationPojoList(topic);
        pojo.setForwardDestinationList(forwards);
        return pojo;
    }

    private CompositeQueuePojo createCompositeQueuePojo(CompositeQueue queue) {
        CompositeQueuePojo pojo = new CompositeQueuePojo();
        pojo.setName(queue.getName());
        pojo.setJndiName(queue.getJndiName());
        pojo.setForwardOnly(Utils.toBoolean(queue.getForwardOnly()));
        List<ForwardDestinationPojo> forwards = this.createForwardDestinationPojoList(queue);
        pojo.setForwardDestinationList(forwards);
        return pojo;
    }

    private List<ForwardDestinationPojo> createForwardDestinationPojoList(CompositeQueue comp) {
        ArrayList<ForwardDestinationPojo> pojos = new ArrayList<ForwardDestinationPojo>();
        Collection<ForwardQueue> queues = comp.getForwardQueue().values();
        pojos.addAll(this.createForwardQueuePojoList(queues));
        Collection<ForwardTopic> topics = comp.getForwardTopic().values();
        pojos.addAll(this.createForwardTopicPojoList(topics));
        return pojos;
    }

    private List<ForwardDestinationPojo> createForwardDestinationPojoList(CompositeTopic comp) {
        ArrayList<ForwardDestinationPojo> pojos = new ArrayList<ForwardDestinationPojo>();
        Collection<ForwardQueue> queues = comp.getForwardQueue().values();
        pojos.addAll(this.createForwardQueuePojoList(queues));
        Collection<ForwardTopic> topics = comp.getForwardTopic().values();
        pojos.addAll(this.createForwardTopicPojoList(topics));
        return pojos;
    }

    private List<ForwardQueuePojo> createForwardQueuePojoList(Collection<ForwardQueue> queues) {
        ArrayList<ForwardQueuePojo> pojos = new ArrayList<ForwardQueuePojo>();
        for (ForwardQueue next : queues) {
            ForwardQueuePojo queuePojo = this.createForwardQueuePojo(next);
            pojos.add(queuePojo);
        }
        return pojos;
    }

    private List<ForwardTopicPojo> createForwardTopicPojoList(Collection<ForwardTopic> topics) {
        ArrayList<ForwardTopicPojo> pojos = new ArrayList<ForwardTopicPojo>();
        for (ForwardTopic next : topics) {
            ForwardTopicPojo queuePojo = this.createForwardTopicPojo(next);
            pojos.add(queuePojo);
        }
        return pojos;
    }

    private ForwardQueuePojo createForwardQueuePojo(ForwardQueue forwardQueue) {
        if (forwardQueue == null) {
            return null;
        }
        ForwardQueuePojo pojo = new ForwardQueuePojo();
        pojo.setName(forwardQueue.getName());
        pojo.setSelector(forwardQueue.getSelector());
        return pojo;
    }

    private ForwardTopicPojo createForwardTopicPojo(ForwardTopic forwardTopic) {
        if (forwardTopic == null) {
            return null;
        }
        ForwardTopicPojo pojo = new ForwardTopicPojo();
        pojo.setName(forwardTopic.getName());
        pojo.setSelector(forwardTopic.getSelector());
        return pojo;
    }

    @Override
    public List<DestinationPojo> listAllDestination() throws Exception {
        ArrayList<DestinationPojo> pojos = new ArrayList<DestinationPojo>();
        pojos.addAll(this.listAllQueue());
        pojos.addAll(this.listAllTopic());
        return pojos;
    }

    @Override
    public List<CompositeDestinationPojo> listAllCompositeDestination() throws Exception {
        ArrayList<CompositeDestinationPojo> pojos = new ArrayList<CompositeDestinationPojo>();
        pojos.addAll(this.listAllCompositeQueue());
        pojos.addAll(this.listAllCompositeTopic());
        return pojos;
    }

    @Override
    public List<QueuePojo> listAllQueue() throws Exception {
        Map<String, Queue> queues = this.jeemxHelper.getDestinations().getQueue();
        ArrayList<QueuePojo> pojos = new ArrayList<QueuePojo>(queues.size());
        for (Queue next : queues.values()) {
            QueuePojo pojo = this.createQueuePojo(next);
            pojos.add(pojo);
        }
        return pojos;
    }

    @Override
    public List<TopicPojo> listAllTopic() throws Exception {
        Map<String, Topic> topics = this.jeemxHelper.getDestinations().getTopic();
        ArrayList<TopicPojo> pojos = new ArrayList<TopicPojo>(topics.size());
        for (Topic next : topics.values()) {
            TopicPojo pojo = this.createTopicPojo(next);
            pojos.add(pojo);
        }
        return pojos;
    }

    @Override
    public List<CompositeQueuePojo> listAllCompositeQueue() {
        Map<String, CompositeQueue> composQueueMap = this.jeemxHelper.getDestinations().getCompositeQueue();
        ArrayList<CompositeQueuePojo> pojos = new ArrayList<CompositeQueuePojo>(composQueueMap.size());
        for (CompositeQueue next : composQueueMap.values()) {
            CompositeQueuePojo pojo = this.createCompositeQueuePojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    @Override
    public List<CompositeTopicPojo> listAllCompositeTopic() {
        Map<String, CompositeTopic> composTopicMap = this.jeemxHelper.getDestinations().getCompositeTopic();
        ArrayList<CompositeTopicPojo> pojos = new ArrayList<CompositeTopicPojo>(composTopicMap.size());
        for (CompositeTopic next : composTopicMap.values()) {
            CompositeTopicPojo pojo = this.createCompositeTopicPojo(next);
            pojos.add(pojo);
        }
        Collections.sort(pojos);
        return pojos;
    }

    @Override
    public List<ForwardDestinationPojo> listAllForwardDestination(Type compositeType, String compositeName) throws Exception {
        if (Type.isQueue(compositeType)) {
            CompositeQueue compositeQueue = this.jeemxHelper.getDestinations().getCompositeQueue().get(compositeName);
            return this.createForwardDestinationPojoList(compositeQueue);
        }
        CompositeTopic compositeTopic = this.jeemxHelper.getDestinations().getCompositeTopic().get(compositeName);
        return this.createForwardDestinationPojoList(compositeTopic);
    }

    private List<ConnectionFactoryPojo> listAllConnectionFactoryPojo() throws Exception {
        ConnectionFactoryFacadeImpl facade = new ConnectionFactoryFacadeImpl(this.jeemxHelper);
        List<ConnectionFactoryPojo> pojos = facade.listAllConnectionFactory();
        return pojos;
    }

    @Override
    public void updateQueue(QueuePojo pojo) throws Exception {
        Queue queue = this.jeemxHelper.getDestinations().getQueue().get(pojo.getName());
        if (queue == null) {
            return;
        }
        queue.setJndiName(pojo.getJndiName());
        queue.setPolicyRef(pojo.getPolicyRef());
        queue.setMirror(String.valueOf(pojo.isMirror()));
        queue.setDescription(pojo.getDescription());
    }

    @Override
    public void updateTopic(TopicPojo pojo) throws Exception {
        Topic topic = this.jeemxHelper.getDestinations().getTopic().get(pojo.getName());
        if (topic == null) {
            return;
        }
        topic.setJndiName(pojo.getJndiName());
        topic.setPolicyRef(pojo.getPolicyRef());
        topic.setVirtual(String.valueOf(pojo.isVirtual()));
        topic.setDescription(pojo.getDescription());
    }

    @Override
    public void updateCompositeQueue(CompositeQueuePojo pojo) throws Exception {
        CompositeQueue compositeQueue = this.jeemxHelper.getDestinations().getCompositeQueue().get(pojo.getName());
        if (compositeQueue == null) {
            return;
        }
        List<ForwardDestinationPojo> forwardDestinationPojos = pojo.getForwardDestinationList();
        compositeQueue.setJndiName(pojo.getJndiName());
        compositeQueue.setForwardOnly(String.valueOf(pojo.getForwardOnly()));
        this.updateForwardDestination(compositeQueue, forwardDestinationPojos);
    }

    @Override
    public void updateCompositeTopic(CompositeTopicPojo pojo) throws Exception {
        CompositeTopic compositeTopic = this.jeemxHelper.getDestinations().getCompositeTopic().get(pojo.getName());
        if (compositeTopic == null) {
            return;
        }
        List<ForwardDestinationPojo> forwardDestinationPojos = pojo.getForwardDestinationList();
        compositeTopic.setJndiName(pojo.getJndiName());
        compositeTopic.setForwardOnly(String.valueOf(pojo.getForwardOnly()));
        this.updateForwardDestination(compositeTopic, forwardDestinationPojos);
    }

    private void updateForwardDestination(CompositeTopic compositeTopic, List<ForwardDestinationPojo> forwardDestinationPojos) throws Exception {
        Map<String, ForwardQueue> forwardQueues = compositeTopic.getForwardQueue();
        Map<String, ForwardTopic> forwardTopics = compositeTopic.getForwardTopic();
        for (ForwardDestinationPojo forwardDestinationPojo : forwardDestinationPojos) {
            if (Type.isQueue(forwardDestinationPojo.getType())) {
                ForwardQueue forwardQueue = forwardQueues.get(forwardDestinationPojo.getName());
                if (forwardQueue != null) {
                    forwardQueue.setSelector(forwardDestinationPojo.getSelector());
                    forwardQueues.remove(forwardQueue.getName());
                    continue;
                }
                compositeTopic.createChild("forward-queue", Utils.pojo2map(forwardDestinationPojo, new List[0]));
                continue;
            }
            ForwardTopic forwardTopic = forwardTopics.get(forwardDestinationPojo.getName());
            if (forwardTopic != null) {
                forwardTopic.setSelector(forwardDestinationPojo.getSelector());
                forwardTopics.remove(forwardTopic.getName());
                continue;
            }
            compositeTopic.createChild("forward-topic", Utils.pojo2map(forwardDestinationPojo, new List[0]));
        }
        for (ForwardQueue forwardQueue : forwardQueues.values()) {
            compositeTopic.removeChild("forward-queue", forwardQueue.getName());
        }
        for (ForwardTopic forwardTopic : forwardTopics.values()) {
            compositeTopic.removeChild("forward-topic", forwardTopic.getName());
        }
    }

    private void updateForwardDestination(CompositeQueue compositeQueue, List<ForwardDestinationPojo> forwardDestinationPojos) throws Exception {
        Map<String, ForwardQueue> forwardQueues = compositeQueue.getForwardQueue();
        Map<String, ForwardTopic> forwardTopics = compositeQueue.getForwardTopic();
        for (ForwardDestinationPojo forwardDestinationPojo : forwardDestinationPojos) {
            if (Type.isQueue(forwardDestinationPojo.getType())) {
                ForwardQueue forwardQueue = forwardQueues.get(forwardDestinationPojo.getName());
                if (forwardQueue != null) {
                    forwardQueue.setSelector(forwardDestinationPojo.getSelector());
                    forwardQueues.remove(forwardQueue.getName());
                    continue;
                }
                compositeQueue.createChild("forward-queue", Utils.pojo2map(forwardDestinationPojo, new List[0]));
                continue;
            }
            ForwardTopic forwardTopic = forwardTopics.get(forwardDestinationPojo.getName());
            if (forwardTopic != null) {
                forwardTopic.setSelector(forwardDestinationPojo.getSelector());
                forwardTopics.remove(forwardTopic.getName());
                continue;
            }
            compositeQueue.createChild("forward-topic", Utils.pojo2map(forwardDestinationPojo, new List[0]));
        }
        for (ForwardQueue forwardQueue : forwardQueues.values()) {
            compositeQueue.removeChild("forward-queue", forwardQueue.getName());
        }
        for (ForwardTopic forwardTopic : forwardTopics.values()) {
            compositeQueue.removeChild("forward-topic", forwardTopic.getName());
        }
    }

    @Override
    public boolean isJndiNameUsed(String jndiName) throws Exception {
        Broker broker = this.jeemxHelper.getBroker();
        return broker.isJndiNameUsed(jndiName);
    }

    @Override
    public CompositeDestinationPojo getRefDestination(Type type, String name) throws Exception {
        CompositeDestinationPojo ref = null;
        List<CompositeDestinationPojo> destinationPojos = this.listAllCompositeDestination();
        block0: for (CompositeDestinationPojo compDestPojo : destinationPojos) {
            for (ForwardDestinationPojo forwardPojo : compDestPojo.getForwardDestinationList()) {
                if (forwardPojo.getType() != type || !forwardPojo.getName().equals(name)) continue;
                ref = compDestPojo;
                continue block0;
            }
        }
        return ref;
    }

    @Override
    public boolean isQueueOrCompositeQueueExist(String name) throws Exception {
        return this.getQueue(name) != null || this.getCompositeQueue(name) != null;
    }

    @Override
    public boolean isTopicOrCompositeTopicExist(String name) throws Exception {
        return this.getTopic(name) != null || this.getCompositeTopic(name) != null;
    }

    @Override
    public boolean isPolicyNotExist(String policyRef, String type) throws Exception {
        return this.getPolicy(policyRef, type) == null;
    }

    @Override
    public boolean isPolicyTypeError(String policyRef, String type) throws Exception {
        if (type.equals("queue")) {
            return !Type.QUEUE.equals((Object)this.getPolicy(policyRef, type).getType());
        }
        return !Type.TOPIC.equals((Object)this.getPolicy(policyRef, type).getType());
    }

    @Override
    public boolean isJndiNameChanged(String name, String jndiName, boolean isComposite, String type) {
        Topic topic;
        Queue queue;
        CompositeTopic compositeTopic;
        CompositeQueue compositeQueue;
        String jndiNameTemp = null;
        return !(isComposite ? (Type.isQueue(type) ? (jndiNameTemp = (compositeQueue = this.jeemxHelper.getBroker().getDestinations().getCompositeQueue().get(name)).getJndiName()) == null && jndiName.equals("") || jndiNameTemp != null && jndiNameTemp.equals(jndiName) : (jndiNameTemp = (compositeTopic = this.jeemxHelper.getBroker().getDestinations().getCompositeTopic().get(name)).getJndiName()) == null && jndiName.equals("") || jndiNameTemp != null && jndiNameTemp.equals(jndiName)) : (Type.isQueue(type) ? (jndiNameTemp = (queue = this.jeemxHelper.getBroker().getDestinations().getQueue().get(name)).getJndiName()) == null && jndiName.equals("") || jndiNameTemp != null && jndiNameTemp.equals(jndiName) : (jndiNameTemp = (topic = this.jeemxHelper.getBroker().getDestinations().getTopic().get(name)).getJndiName()) == null && jndiName.equals("") || jndiNameTemp != null && jndiNameTemp.equals(jndiName)));
    }
}

