/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.jmx;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.jmx.JmxFacade;
import com.bes.mq.admin.facade.api.jmx.pojo.JmxPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.JmxService;
import com.bes.mq.jeemx.config.intf.TransportConnector;
import java.util.Map;

public class JmxFacadeImpl
extends BaseFacade
implements JmxFacade {
    public JmxFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void update(JmxPojo pojo) throws Exception {
        JmxService jmxService = this.jeemxHelper.getJmxService();
        jmxService.setListenPort(String.valueOf(pojo.getListenPort()));
        jmxService.setListenAddress(pojo.getListenAddress());
        if (pojo.getPublishHostname() != null && !"".equals(pojo.getPublishHostname())) {
            jmxService.setPublishHostname(pojo.getPublishHostname());
        }
    }

    @Override
    public JmxPojo getJmxService() throws Exception {
        JmxService jmxService = this.jeemxHelper.getBroker().getJmxService();
        JmxPojo pojo = new JmxPojo();
        String clientHostname = jmxService.getPublishHostname();
        String address = jmxService.getListenAddress();
        String port = jmxService.getListenPort();
        if (clientHostname != null) {
            pojo.setPublishHostname(clientHostname);
        }
        if (address != null) {
            pojo.setListenAddress(address);
        }
        if (port != null) {
            pojo.setListenPort(Utils.toInt(port));
        }
        return pojo;
    }

    @Override
    public boolean isPortUsed(String port) throws Exception {
        Map<String, TransportConnector> transportConnector = this.jeemxHelper.getTransportConnectors().getTransportConnector();
        for (TransportConnector tc : transportConnector.values()) {
            if (!tc.getListenPort().equals(port)) continue;
            return true;
        }
        return false;
    }
}

