/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.jndi;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.jndi.JndiFacade;
import com.bes.mq.admin.facade.api.jndi.pojo.JndiPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.JndiService;
import com.bes.mq.jeemx.config.intf.TransportConnector;
import java.util.Map;

public class JndiFacadeImpl
extends BaseFacade
implements JndiFacade {
    public JndiFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public JndiPojo getJndiService() throws Exception {
        JndiService jndiService = this.jeemxHelper.getJndiService();
        JndiPojo pojo = new JndiPojo();
        pojo.setListenAddress(jndiService.getListenAddress());
        pojo.setListenPort(Utils.toInt(jndiService.getListenPort()));
        return pojo;
    }

    @Override
    public boolean isPortUsed(String port) throws Exception {
        Map<String, TransportConnector> transportConnector = this.jeemxHelper.getTransportConnectors().getTransportConnector();
        for (TransportConnector tc : transportConnector.values()) {
            if (!tc.getListenPort().equals(port)) continue;
            return true;
        }
        return this.jeemxHelper.getJmxService().getListenPort().equals(port);
    }

    @Override
    public void updateJndi(JndiPojo pojo) throws Exception {
        JndiService jndiService = this.jeemxHelper.getJndiService();
        jndiService.setListenAddress(pojo.getListenAddress());
        jndiService.setListenPort(String.valueOf(pojo.getListenPort()));
    }
}

