/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.jvm;

import com.bes.mq.admin.facade.api.jvm.JvmOptionsFacade;
import com.bes.mq.admin.facade.api.jvm.pojo.JvmPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.JavaConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JvmOptionsFacadeImpl
extends BaseFacade
implements JvmOptionsFacade {
    public JvmOptionsFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void addJvmOptions(List<String> options) throws Exception {
        JavaConfig javaConfig = this.jeemxHelper.getJavaConfig();
        List<String> existOptions = this.convertList(javaConfig.getJvmOptions());
        List<String> finalOptions = this.mergeAddSaveJvmOptions(options, existOptions);
        javaConfig.setJvmOptions(finalOptions.toArray(new String[0]));
    }

    private List<String> mergeAddSaveJvmOptions(List<String> newOptions, List<String> existOptions) throws Exception {
        Pattern xmxXmsXssPattern = Pattern.compile("-(Xmx|Xms|Xss)((\\d)+[m|g|k|M|G|K]?)?");
        Pattern otherOptionPattern = Pattern.compile("(.*)(\\s|:|=)(.*)");
        for (String current : newOptions) {
            Iterator<String> existIt = existOptions.iterator();
            while (existIt.hasNext()) {
                String exist = existIt.next();
                if (current.equals(exist)) {
                    existIt.remove();
                    continue;
                }
                if (xmxXmsXssPattern.matcher(current).matches() && xmxXmsXssPattern.matcher(exist).matches()) {
                    if (!current.substring(0, 4).equals(exist.substring(0, 4))) continue;
                    existIt.remove();
                    continue;
                }
                Matcher currMatcher = otherOptionPattern.matcher(current);
                Matcher existMatcher = otherOptionPattern.matcher(exist);
                if (!currMatcher.matches() || !existMatcher.matches()) continue;
                String currKey = null;
                String existKey = null;
                if (currMatcher.groupCount() == 3) {
                    currKey = currMatcher.group(1);
                }
                if (existMatcher.groupCount() == 3) {
                    existKey = existMatcher.group(1);
                }
                if (currKey == null || !currKey.equals(existKey)) continue;
                existIt.remove();
            }
        }
        ArrayList<String> finalOptions = new ArrayList<String>();
        this.applyFirstPrior(newOptions, finalOptions);
        this.applyFirstPrior(existOptions, finalOptions);
        return finalOptions;
    }

    private void applyFirstPrior(List<String> currents, List<String> finals) {
        for (String current : currents) {
            boolean existed = false;
            block1: for (String optionFirst : SPECAIL_OPTIONS) {
                Pattern regex = Pattern.compile(optionFirst);
                if (!regex.matcher(current).matches()) continue;
                for (String finalOption : finals) {
                    existed = regex.matcher(finalOption).matches();
                    if (!(existed |= !(!"-server".equals(current) && !"-client".equals(current) || !finals.contains("-client") && !finals.contains("-server")))) continue;
                    break block1;
                }
                break;
            }
            if (existed) continue;
            finals.add(current);
        }
    }

    private List<String> convertList(String[] jvmOptions) {
        ArrayList<String> jvmopts = new ArrayList<String>();
        for (String string : jvmOptions) {
            jvmopts.add(string);
        }
        return jvmopts;
    }

    @Override
    public void deleteJvmOptions(List<String> options) {
        JavaConfig config = this.jeemxHelper.getJavaConfig();
        ArrayList<String> jvmopts = new ArrayList<String>(this.convertList(config.getJvmOptions()));
        jvmopts.removeAll(options);
        config.setJvmOptions(jvmopts.toArray(new String[jvmopts.size()]));
    }

    @Override
    public List<String> getJvmOptions() {
        JavaConfig config = this.jeemxHelper.getJavaConfig();
        ArrayList<String> jvmopts = new ArrayList<String>(this.convertList(config.getJvmOptions()));
        return jvmopts;
    }

    @Override
    public String getStartingWith(String string) {
        JavaConfig config = this.jeemxHelper.getJavaConfig();
        return config.getStartingWith(string);
    }

    @Override
    public boolean contains(String opt) {
        JavaConfig config = this.jeemxHelper.getJavaConfig();
        return config.contains(opt);
    }

    private JvmPojo createJvmPojo(JavaConfig config) {
        if (config == null) {
            return null;
        }
        JvmPojo pojo = new JvmPojo();
        pojo.setJvmOptions(this.convertList(config.getJvmOptions()));
        pojo.setJavaHome(config.getJavaHome());
        if (config.contains("-client")) {
            pojo.setHotSpot("-client");
        }
        pojo.setXms(config.getXmsMegs());
        pojo.setXmx(config.getXmxMegs());
        return pojo;
    }

    @Override
    public JvmPojo getJvmPojo() {
        JavaConfig config = this.jeemxHelper.getJavaConfig();
        return this.createJvmPojo(config);
    }

    @Override
    public void updateJavaConfig(JvmPojo pojo) throws Exception {
        JavaConfig config = this.jeemxHelper.getJavaConfig();
        config.setJavaHome(pojo.getJavaHome());
        ArrayList<String> newOptions = new ArrayList<String>();
        newOptions.add(pojo.getHotSpot());
        newOptions.add("-Xms" + pojo.getXms() + "M");
        newOptions.add("-Xmx" + pojo.getXmx() + "M");
        newOptions.addAll(pojo.getJvmOptions());
        List<String> finalOptions = this.mergeAddSaveJvmOptions(newOptions, new ArrayList<String>(0));
        config.setJvmOptions(finalOptions.toArray(new String[0]));
    }

    @Override
    public Map<String, String> listToMap(List<String> OptionsLst) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        if (OptionsLst != null) {
            for (int i = 0; i < OptionsLst.size(); ++i) {
                String option = OptionsLst.get(i);
                int index = option.indexOf("=");
                boolean isServer = "-server".equals(option);
                boolean isClient = "-client".equals(option);
                boolean isXmx = Pattern.compile("-Xmx((\\d)+[m|g|k|M|G|K]?)?").matcher(option).matches();
                boolean isXms = Pattern.compile("-Xms((\\d)+[m|g|k|M|G|K]?)?").matcher(option).matches();
                if (isXmx || isXms || isClient || isServer) continue;
                if (index != -1) {
                    tmp.put(option.substring(0, index), option.substring(index + 1));
                    continue;
                }
                tmp.put(option, "");
            }
        }
        return tmp;
    }

    @Override
    public List<String> mapToLst(Map<String, String> jvmOptions) {
        ArrayList<String> properties = new ArrayList<String>();
        if (jvmOptions != null) {
            Set<Map.Entry<String, String>> entrySet = jvmOptions.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String jvmOption = new String();
                jvmOption = entry.getValue() != null && !entry.getValue().equals("") ? entry.getKey() + "=" + entry.getValue() : entry.getKey();
                properties.add(jvmOption);
            }
        }
        return properties;
    }
}

