/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.monitor;

import com.bes.mq.admin.facade.api.monitor.MonitorFacade;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.tools.StringUtil;
import com.bes.mq.broker.jmx.BrokerViewMBean;
import com.bes.mq.broker.jmx.ConnectionViewMBean;
import com.bes.mq.broker.jmx.ConnectorViewMBean;
import com.bes.mq.broker.jmx.DestinationViewMBean;
import com.bes.mq.broker.jmx.DurableSubscriptionViewMBean;
import com.bes.mq.broker.jmx.NetworkBridgeViewMBean;
import com.bes.mq.broker.jmx.NetworkConnectorViewMBean;
import com.bes.mq.broker.jmx.QueueViewMBean;
import com.bes.mq.broker.jmx.SubscriptionViewMBean;
import com.bes.mq.broker.jmx.TopicViewMBean;
import com.bes.mq.command.BESMQDestination;
import com.bes.mq.util.JMXSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class MonitorFacadeImpl
extends BaseFacade
implements MonitorFacade {
    private MBeanServerConnection connection;

    public MonitorFacadeImpl(JEEMXHelper jeemxHelper, MBeanServerConnection connection) {
        super(jeemxHelper);
        this.connection = connection;
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public void setConnection(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.connection.queryNames(name, query);
    }

    public Object newProxyInstance(ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) throws Exception {
        return MBeanServerInvocationHandler.newProxyInstance(this.connection, objectName, interfaceClass, notificationBroadcaster);
    }

    @Override
    public Collection<QueueViewMBean> getQueues() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getQueues();
        return this.getManagedObjects(queues, QueueViewMBean.class);
    }

    @Override
    public Collection<TopicViewMBean> getTopics() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getTopics();
        return this.getManagedObjects(queues, TopicViewMBean.class);
    }

    @Override
    public Collection<DurableSubscriptionViewMBean> getDurableTopicSubscribers() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getDurableTopicSubscribers();
        return this.getManagedObjects(queues, DurableSubscriptionViewMBean.class);
    }

    @Override
    public Collection<DurableSubscriptionViewMBean> getInactiveDurableTopicSubscribers() throws Exception {
        BrokerViewMBean broker = this.getBrokerAdmin();
        if (broker == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName[] queues = broker.getInactiveDurableTopicSubscribers();
        return this.getManagedObjects(queues, DurableSubscriptionViewMBean.class);
    }

    @Override
    public QueueViewMBean getQueue(String name) throws Exception {
        return (QueueViewMBean)this.getDestinationByName(this.getQueues(), name);
    }

    @Override
    public TopicViewMBean getTopic(String name) throws Exception {
        return (TopicViewMBean)this.getDestinationByName(this.getTopics(), name);
    }

    protected DestinationViewMBean getDestinationByName(Collection<? extends DestinationViewMBean> collection, String name) {
        for (DestinationViewMBean destinationViewMBean : collection) {
            if (!name.equals(destinationViewMBean.getName())) continue;
            return destinationViewMBean;
        }
        return null;
    }

    protected <T> Collection<T> getManagedObjects(ObjectName[] names, Class<T> type) throws Exception {
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int i = 0; i < names.length; ++i) {
            ObjectName name = names[i];
            Object value = this.newProxyInstance(name, type, true);
            if (value == null) continue;
            answer.add(value);
        }
        return answer;
    }

    @Override
    public Collection<ConnectionViewMBean> getConnections() throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Connection,ConnectorName=*,ViewType=address,Name=*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), ConnectionViewMBean.class);
    }

    @Override
    public Collection<String> getConnections(String connectorName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Connection,ConnectorName=" + this.encodeObjectNamePart(connectorName) + ",Connection=*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        ArrayList<String> result = new ArrayList<String>(queryResult.size());
        for (ObjectName on : queryResult) {
            String name = StringUtil.replace(on.getKeyProperty("Connection"), "_", ":");
            result.add(name);
        }
        return result;
    }

    @Override
    public ConnectionViewMBean getConnection(String connectionName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return null;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + brokerName + ",Type=Connection,*,Connection=" + this.encodeObjectNamePart(connectionName));
        Set<ObjectName> queryResult = this.queryNames(query, null);
        if (queryResult.size() == 0) {
            return null;
        }
        ObjectName objectName = queryResult.iterator().next();
        return (ConnectionViewMBean)this.newProxyInstance(objectName, ConnectionViewMBean.class, true);
    }

    @Override
    public Collection<String> getConnectors() throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Connector,*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        ArrayList<String> result = new ArrayList<String>(queryResult.size());
        for (ObjectName on : queryResult) {
            result.add(on.getKeyProperty("ConnectorName"));
        }
        return result;
    }

    @Override
    public ConnectorViewMBean getConnector(String name) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return null;
        }
        ObjectName objectName = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Connector,ConnectorName=" + this.encodeObjectNamePart(name));
        return (ConnectorViewMBean)this.newProxyInstance(objectName, ConnectorViewMBean.class, true);
    }

    @Override
    public Collection<NetworkConnectorViewMBean> getNetworkConnectors() throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=NetworkConnector,*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), NetworkConnectorViewMBean.class);
    }

    @Override
    public Collection<NetworkBridgeViewMBean> getNetworkBridges() throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=NetworkBridge,*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), NetworkBridgeViewMBean.class);
    }

    @Override
    public Collection<SubscriptionViewMBean> getQueueConsumers(String queueName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Subscription,destinationType=Queue,destinationName=" + this.encodeObjectNamePart(queueName) + ",*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class);
    }

    @Override
    public Collection<SubscriptionViewMBean> getConsumersOnConnection(String connectionName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Subscription,clientId=" + this.encodeObjectNamePart(connectionName) + ",*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        return this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class);
    }

    @Override
    public boolean isSlave() throws Exception {
        return this.getBrokerAdmin().isSlave();
    }

    @Override
    public String getBrokerName() throws Exception {
        return this.getBrokerAdmin().getBrokerName();
    }

    @Override
    public BrokerViewMBean getBrokerAdmin() throws Exception {
        Set<ObjectName> brokers = this.findBrokers(this.connection);
        if (brokers.size() == 0) {
            throw new IOException("No broker could be found in the JMX.");
        }
        ObjectName name = brokers.iterator().next();
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(this.connection, name, BrokerViewMBean.class, true);
        return mbean;
    }

    @Override
    public void purgeQueue(BESMQDestination destination) throws Exception {
        QueueViewMBean queue = this.getQueue(destination.getPhysicalName());
        queue.purge();
    }

    protected Set<ObjectName> findBrokers(MBeanServerConnection connection) throws IOException, MalformedObjectNameException {
        ObjectName name = new ObjectName("com.bes.mq:Type=Broker,*");
        Set<ObjectName> brokers = connection.queryNames(name, null);
        return brokers;
    }

    @Override
    public Collection<SubscriptionViewMBean> getActiveTopicSubscribersByTopicName(String topicName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Subscription,destinationType=Topic,destinationName=" + this.encodeObjectNamePart(topicName) + ",*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        Collection<SubscriptionViewMBean> topicSubscribers = this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), SubscriptionViewMBean.class);
        Iterator<SubscriptionViewMBean> iterator = topicSubscribers.iterator();
        while (iterator.hasNext()) {
            SubscriptionViewMBean subscriptionViewMBean = iterator.next();
            if (subscriptionViewMBean.isActive()) continue;
            iterator.remove();
        }
        return topicSubscribers;
    }

    @Override
    public Collection<DurableSubscriptionViewMBean> getInactiveDurableTopicSubscribersByTopicName(String topicName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return Collections.EMPTY_LIST;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Subscription,persistentMode=Durable,destinationType=Topic,destinationName=" + this.encodeObjectNamePart(topicName) + ",*");
        Set<ObjectName> queryResult = this.queryNames(query, null);
        Collection<DurableSubscriptionViewMBean> durableTopicSubscribers = this.getManagedObjects(queryResult.toArray(new ObjectName[queryResult.size()]), DurableSubscriptionViewMBean.class);
        Iterator<DurableSubscriptionViewMBean> iterator = durableTopicSubscribers.iterator();
        while (iterator.hasNext()) {
            DurableSubscriptionViewMBean durableSubscriptionViewMBean = iterator.next();
            if (!durableSubscriptionViewMBean.isActive()) continue;
            iterator.remove();
        }
        return durableTopicSubscribers;
    }

    @Override
    public void deleteInactiveDurableSubscriptionViewMBeanBySubcriptionName(String subcriptionName, String clientId, String destinationName) throws Exception {
        String brokerName = this.getBrokerName();
        if (brokerName == null) {
            return;
        }
        ObjectName query = new ObjectName("com.bes.mq:BrokerName=" + this.encodeObjectNamePart(brokerName) + ",Type=Subscription,persistentMode=Durable,destinationType=Topic,subscriptionID=" + this.encodeObjectNamePart(subcriptionName) + ",destinationName=" + this.encodeObjectNamePart(destinationName) + ",clientId=" + this.encodeObjectNamePart(clientId));
        DurableSubscriptionViewMBean durableSubscriptionViewMBean = (DurableSubscriptionViewMBean)this.newProxyInstance(query, DurableSubscriptionViewMBean.class, false);
        durableSubscriptionViewMBean.destroy();
    }

    private String encodeObjectNamePart(String name) {
        return JMXSupport.encodeObjectNamePart(name);
    }
}

