/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.policy;

import com.bes.admin.jeemx.intf.config.Property;
import com.bes.mq.admin.facade.api.PropertyPojo;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.destinations.pojo.Type;
import com.bes.mq.admin.facade.api.policy.PoliciesFacade;
import com.bes.mq.admin.facade.api.policy.pojo.ConstantPendingMessageLimitStrategyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.IndividualDLQStrategyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.OldestMessageWithLowestPriorityEvictionStrategyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.PolicyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.PrefetchRatePendingMessageLimitStrategyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.QueuePolicyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.SharedDLQStrategyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.SlowConsumerStrategyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.TopicPolicyPojo;
import com.bes.mq.admin.facade.api.policy.pojo.UniquePropertyMessageEvictionStrategyPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.ConstantPendingMessageLimitStrategy;
import com.bes.mq.jeemx.config.intf.IndividualDeadLetterStrategy;
import com.bes.mq.jeemx.config.intf.MemoryUsage;
import com.bes.mq.jeemx.config.intf.OldestMessageWithLowestPriorityEvictionStrategy;
import com.bes.mq.jeemx.config.intf.Policies;
import com.bes.mq.jeemx.config.intf.PrefetchRatePendingMessageLimitStrategy;
import com.bes.mq.jeemx.config.intf.QueuePolicy;
import com.bes.mq.jeemx.config.intf.SharedDeadLetterStrategy;
import com.bes.mq.jeemx.config.intf.SlowConsumerStrategy;
import com.bes.mq.jeemx.config.intf.TopicPolicy;
import com.bes.mq.jeemx.config.intf.UniquePropertyMessageEvictionStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PoliciesFacadeImpl
extends BaseFacade
implements PoliciesFacade {
    private final String TYPE_QUEUE = "queue";
    private final String TYPE_TOPIC = "topic";

    public PoliciesFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public List<PolicyPojo> listAllPolicy() throws Exception {
        ArrayList<PolicyPojo> policies = new ArrayList<PolicyPojo>();
        policies.addAll(this.listAllQueuePolicy());
        policies.addAll(this.listAllTopicPolicy());
        return policies;
    }

    @Override
    public List<QueuePolicyPojo> listAllQueuePolicy() throws Exception {
        Map<String, QueuePolicy> queuePolicies = this.jeemxHelper.getPolicies().getQueuePolicy();
        ArrayList<QueuePolicyPojo> queuePolicyPojos = new ArrayList<QueuePolicyPojo>(queuePolicies.size());
        Iterator<String> it = queuePolicies.keySet().iterator();
        while (it.hasNext()) {
            QueuePolicyPojo pojo = this.createQueuePolicyPojo(queuePolicies.get(it.next()));
            queuePolicyPojos.add(pojo);
        }
        return queuePolicyPojos;
    }

    @Override
    public List<TopicPolicyPojo> listAllTopicPolicy() throws Exception {
        Map<String, TopicPolicy> topicPolicies = this.jeemxHelper.getPolicies().getTopicPolicy();
        ArrayList<TopicPolicyPojo> topicPolicyPojos = new ArrayList<TopicPolicyPojo>(topicPolicies.size());
        Iterator<String> it = topicPolicies.keySet().iterator();
        while (it.hasNext()) {
            TopicPolicyPojo pojo = this.createTopicPolicyPojo(topicPolicies.get(it.next()));
            topicPolicyPojos.add(pojo);
        }
        return topicPolicyPojos;
    }

    @Override
    public QueuePolicyPojo getQueuePolicy(String name) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        QueuePolicy queuePolicy = policies.getQueuePolicy().get(name);
        QueuePolicyPojo queuePolicyPojo = null;
        if (queuePolicy != null) {
            queuePolicyPojo = this.createQueuePolicyPojo(queuePolicy);
        }
        return queuePolicyPojo;
    }

    private QueuePolicyPojo createQueuePolicyPojo(QueuePolicy queuePolicy) throws Exception {
        QueuePolicyPojo queuePolicyPojo = new QueuePolicyPojo();
        queuePolicyPojo.setName(queuePolicy.getName());
        queuePolicyPojo.setNotifyForFastProducers(Utils.toBoolean(queuePolicy.getNotifyForFastProducers()));
        queuePolicyPojo.setNotifyForSlowConsumers(Utils.toBoolean(queuePolicy.getNotifyForSlowConsumers()));
        queuePolicyPojo.setNotifyWhenFull(Utils.toBoolean(queuePolicy.getNotifyWhenFull()));
        queuePolicyPojo.setCursor(queuePolicy.getCursor());
        queuePolicyPojo.setCursorMemoryHighWaterMark(Utils.toInt(queuePolicy.getCursorMemoryHighWaterMark()));
        queuePolicyPojo.setDispatchPolicy(queuePolicy.getDispatchPolicy());
        queuePolicyPojo.setDlqStrategy(queuePolicy.getDlqStrategy());
        queuePolicyPojo.setEnableAudit(Utils.toBoolean(queuePolicy.getEnableAudit()));
        queuePolicyPojo.setEnableSlowConsumerStrategy(Utils.toBoolean(queuePolicy.getEnableSlowConsumerStrategy()));
        queuePolicyPojo.setExpireMessagesPeriod(Utils.toInt(queuePolicy.getExpireMessagesPeriod()));
        queuePolicyPojo.setMemoryLimit(Utils.toInt(queuePolicy.getMemoryLimit()));
        queuePolicyPojo.setProducerFlowControl(Utils.toBoolean(queuePolicy.getProducerFlowControl()));
        queuePolicyPojo.setQueuePrefetch(Utils.toInt(queuePolicy.getQueuePrefetch()));
        queuePolicyPojo.setStoreUsageHighWaterMark(Utils.toInt(queuePolicy.getStoreUsageHighWaterMark()));
        queuePolicyPojo.setUseCache(Utils.toBoolean(queuePolicy.getUseCache()));
        queuePolicyPojo.setUseConsumerPriority(Utils.toBoolean(queuePolicy.getUseConsumerPriority()));
        SharedDeadLetterStrategy sharedDlq = queuePolicy.getSharedDeadLetterStrategy();
        SharedDLQStrategyPojo sharedDlqPojo = new SharedDLQStrategyPojo();
        sharedDlqPojo.setDlqType(sharedDlq.getDlqType());
        sharedDlqPojo.setProcessExpired(Utils.toBoolean(sharedDlq.getProcessExpired()));
        sharedDlqPojo.setProcessNonPersistent(Utils.toBoolean(sharedDlq.getProcessNonPersistent()));
        sharedDlqPojo.setEnableAudit(Utils.toBoolean(sharedDlq.getEnableAudit()));
        queuePolicyPojo.setSharedDlqPojo(sharedDlqPojo);
        IndividualDeadLetterStrategy individualDlq = queuePolicy.getIndividualDeadLetterStrategy();
        IndividualDLQStrategyPojo individualDlqPojo = new IndividualDLQStrategyPojo();
        individualDlqPojo.setDlqType(individualDlq.getDlqType());
        individualDlqPojo.setProcessExpired(Utils.toBoolean(individualDlq.getProcessExpired()));
        individualDlqPojo.setProcessNonPersistent(Utils.toBoolean(individualDlq.getProcessNonPersistent()));
        individualDlqPojo.setEnableAudit(Utils.toBoolean(individualDlq.getEnableAudit()));
        queuePolicyPojo.setIndividualDlqPojo(individualDlqPojo);
        SlowConsumerStrategy slowConsumerStrategy = queuePolicy.getSlowConsumerStrategy();
        SlowConsumerStrategyPojo slowPojo = new SlowConsumerStrategyPojo();
        slowPojo.setAbortConnection(Utils.toBoolean(slowConsumerStrategy.getAbortConnection()));
        slowPojo.setCheckPeriod(Utils.toInt(slowConsumerStrategy.getCheckPeriod()));
        slowPojo.setMaxSlowCount(Utils.toInt(slowConsumerStrategy.getMaxSlowCount()));
        slowPojo.setMaxSlowDuration(Utils.toInt(slowConsumerStrategy.getMaxSlowDuration()));
        queuePolicyPojo.setSlowPojo(slowPojo);
        Map<String, Property> properties = queuePolicy.getProperty();
        Iterator<String> it = properties.keySet().iterator();
        while (it.hasNext()) {
            Property property = properties.get(it.next());
            PropertyPojo propertyPojo = new PropertyPojo(property.getName(), property.getValue());
            queuePolicyPojo.addProperty(propertyPojo);
        }
        return queuePolicyPojo;
    }

    @Override
    public TopicPolicyPojo getTopicPolicy(String name) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        TopicPolicy topicPolicy = policies.getTopicPolicy().get(name);
        TopicPolicyPojo topicPolicyPojo = null;
        if (topicPolicy != null) {
            topicPolicyPojo = this.createTopicPolicyPojo(topicPolicy);
        }
        return topicPolicyPojo;
    }

    private TopicPolicyPojo createTopicPolicyPojo(TopicPolicy TopicPolicy2) throws Exception {
        TopicPolicyPojo topicPolicyPojo = new TopicPolicyPojo();
        topicPolicyPojo.setName(TopicPolicy2.getName());
        topicPolicyPojo.setNotifyForDiscardingMessages(Utils.toBoolean(TopicPolicy2.getNotifyForDiscardingMessages()));
        topicPolicyPojo.setNotifyForFastProducers(Utils.toBoolean(TopicPolicy2.getNotifyForFastProducers()));
        topicPolicyPojo.setNotifyForSlowConsumers(Utils.toBoolean(TopicPolicy2.getNotifyForSlowConsumers()));
        topicPolicyPojo.setNotifyWhenFull(Utils.toBoolean(TopicPolicy2.getNotifyWhenFull()));
        topicPolicyPojo.setCursor(TopicPolicy2.getCursor());
        topicPolicyPojo.setDurableCursor(TopicPolicy2.getDurableCursor());
        topicPolicyPojo.setCursorMemoryHighWaterMark(Utils.toInt(TopicPolicy2.getCursorMemoryHighWaterMark()));
        topicPolicyPojo.setDispatchPolicy(TopicPolicy2.getDispatchPolicy());
        topicPolicyPojo.setDlqStrategy(TopicPolicy2.getDlqStrategy());
        topicPolicyPojo.setEnableAudit(Utils.toBoolean(TopicPolicy2.getEnableAudit()));
        topicPolicyPojo.setEnableSlowConsumerStrategy(Utils.toBoolean(TopicPolicy2.getEnableSlowConsumerStrategy()));
        topicPolicyPojo.setExpireMessagesPeriod(Utils.toInt(TopicPolicy2.getExpireMessagesPeriod()));
        topicPolicyPojo.setMemoryLimit(Utils.toInt(TopicPolicy2.getMemoryLimit()));
        topicPolicyPojo.setProducerFlowControl(Utils.toBoolean(TopicPolicy2.getProducerFlowControl()));
        topicPolicyPojo.setTopicPrefetch(Utils.toInt(TopicPolicy2.getTopicPrefetch()));
        topicPolicyPojo.setDurableTopicPrefetch(Utils.toInt(TopicPolicy2.getDurableTopicPrefetch()));
        topicPolicyPojo.setStoreUsageHighWaterMark(Utils.toInt(TopicPolicy2.getStoreUsageHighWaterMark()));
        topicPolicyPojo.setMessageEvictionStrategy(TopicPolicy2.getMessageEvictionStrategy());
        topicPolicyPojo.setPendingMessageLimitStrategy(TopicPolicy2.getPendingMessageLimitStrategy());
        SharedDeadLetterStrategy sharedDlq = TopicPolicy2.getSharedDeadLetterStrategy();
        SharedDLQStrategyPojo sharedDlqPojo = new SharedDLQStrategyPojo();
        sharedDlqPojo.setDlqType(sharedDlq.getDlqType());
        sharedDlqPojo.setProcessExpired(Utils.toBoolean(sharedDlq.getProcessExpired()));
        sharedDlqPojo.setProcessNonPersistent(Utils.toBoolean(sharedDlq.getProcessNonPersistent()));
        sharedDlqPojo.setEnableAudit(Utils.toBoolean(sharedDlq.getEnableAudit()));
        topicPolicyPojo.setSharedDlqPojo(sharedDlqPojo);
        IndividualDeadLetterStrategy individualDlq = TopicPolicy2.getIndividualDeadLetterStrategy();
        IndividualDLQStrategyPojo individualDlqPojo = new IndividualDLQStrategyPojo();
        individualDlqPojo.setDlqType(individualDlq.getDlqType());
        individualDlqPojo.setProcessExpired(Utils.toBoolean(individualDlq.getProcessExpired()));
        individualDlqPojo.setProcessNonPersistent(Utils.toBoolean(individualDlq.getProcessNonPersistent()));
        individualDlqPojo.setEnableAudit(Utils.toBoolean(individualDlq.getEnableAudit()));
        individualDlqPojo.setDurableSubscriberShareDlq(Utils.toBoolean(individualDlq.getDurableSubscriberShareDlq()));
        topicPolicyPojo.setIndividualDlqPojo(individualDlqPojo);
        SlowConsumerStrategy slowConsumerStrategy = TopicPolicy2.getSlowConsumerStrategy();
        SlowConsumerStrategyPojo slowPojo = new SlowConsumerStrategyPojo();
        slowPojo.setAbortConnection(Utils.toBoolean(slowConsumerStrategy.getAbortConnection()));
        slowPojo.setCheckPeriod(Utils.toInt(slowConsumerStrategy.getCheckPeriod()));
        slowPojo.setMaxSlowCount(Utils.toInt(slowConsumerStrategy.getMaxSlowCount()));
        slowPojo.setMaxSlowDuration(Utils.toInt(slowConsumerStrategy.getMaxSlowDuration()));
        topicPolicyPojo.setSlowPojo(slowPojo);
        OldestMessageWithLowestPriorityEvictionStrategy basedTime = TopicPolicy2.getOldestMessageWithLowestPriorityEvictionStrategy();
        OldestMessageWithLowestPriorityEvictionStrategyPojo basedTimePojo = new OldestMessageWithLowestPriorityEvictionStrategyPojo();
        basedTimePojo.setEvictExpiredMessagesHighWaterMark(Utils.toInt(basedTime.getEvictExpiredMessagesHighWaterMark()));
        topicPolicyPojo.setBasedTimePojo(basedTimePojo);
        UniquePropertyMessageEvictionStrategy basedAttribute = TopicPolicy2.getUniquePropertyMessageEvictionStrategy();
        UniquePropertyMessageEvictionStrategyPojo basedAttributePojo = new UniquePropertyMessageEvictionStrategyPojo();
        basedAttributePojo.setEvictExpiredMessagesHighWaterMark(Utils.toInt(basedAttribute.getEvictExpiredMessagesHighWaterMark()));
        basedAttributePojo.setPropertyName(basedAttribute.getPropertyName());
        topicPolicyPojo.setBasedAttributePojo(basedAttributePojo);
        ConstantPendingMessageLimitStrategy basedConstant = TopicPolicy2.getConstantPendingMessageLimitStrategy();
        ConstantPendingMessageLimitStrategyPojo basedConstantPojo = new ConstantPendingMessageLimitStrategyPojo();
        basedConstantPojo.setLimit(Utils.toInt(basedConstant.getLimit()));
        topicPolicyPojo.setBasedConstantPojo(basedConstantPojo);
        PrefetchRatePendingMessageLimitStrategy basedRate = TopicPolicy2.getPrefetchRatePendingMessageLimitStrategy();
        PrefetchRatePendingMessageLimitStrategyPojo basedRatePojo = new PrefetchRatePendingMessageLimitStrategyPojo();
        basedRatePojo.setMultiplier(Utils.toDouble(basedRate.getMultiplier()));
        topicPolicyPojo.setBasedRatePojo(basedRatePojo);
        Map<String, Property> properties = TopicPolicy2.getProperty();
        Iterator<String> it = properties.keySet().iterator();
        while (it.hasNext()) {
            Property property = properties.get(it.next());
            PropertyPojo propertyPojo = new PropertyPojo(property.getName(), property.getValue());
            topicPolicyPojo.addProperty(propertyPojo);
        }
        return topicPolicyPojo;
    }

    @Override
    public void createQueuePolicy(QueuePolicyPojo queuePolicyPojo) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        Map<String, Object> map = Utils.pojo2map(queuePolicyPojo, new List[0]);
        QueuePolicy queuePolicy = policies.createChild("queue-policy", map).as(QueuePolicy.class);
        map = Utils.pojo2map(queuePolicyPojo.getSharedDlqPojo(), new List[0]);
        queuePolicy.createChild("shared-dead-letter-strategy", map);
        map = Utils.pojo2map(queuePolicyPojo.getIndividualDlqPojo(), new List[0]);
        map.remove("durable-subscriber-share-dlq");
        queuePolicy.createChild("individual-dead-letter-strategy", map);
        map = Utils.pojo2map(queuePolicyPojo.getSlowPojo(), new List[0]);
        queuePolicy.createChild("slow-consumer-strategy", map);
        JEEMXUtils.applyPropertyBag(queuePolicy, queuePolicyPojo);
    }

    @Override
    public void createTopicPolicy(TopicPolicyPojo topicPolicyPojo) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        Map<String, Object> map = Utils.pojo2map(topicPolicyPojo, new List[0]);
        TopicPolicy topicPolicy = policies.createChild("topic-policy", map).as(TopicPolicy.class);
        map = Utils.pojo2map(topicPolicyPojo.getSharedDlqPojo(), new List[0]);
        topicPolicy.createChild("shared-dead-letter-strategy", map);
        map = Utils.pojo2map(topicPolicyPojo.getIndividualDlqPojo(), new List[0]);
        topicPolicy.createChild("individual-dead-letter-strategy", map);
        map = Utils.pojo2map(topicPolicyPojo.getSlowPojo(), new List[0]);
        topicPolicy.createChild("slow-consumer-strategy", map);
        map = Utils.pojo2map(topicPolicyPojo.getBasedTimePojo(), new List[0]);
        topicPolicy.createChild("oldest-message-with-lowest-priority-eviction-strategy", map);
        map = Utils.pojo2map(topicPolicyPojo.getBasedAttributePojo(), new List[0]);
        topicPolicy.createChild("unique-property-message-eviction-strategy", map);
        map = Utils.pojo2map(topicPolicyPojo.getBasedConstantPojo(), new List[0]);
        topicPolicy.createChild("constant-pending-message-limit-strategy", map);
        map = Utils.pojo2map(topicPolicyPojo.getBasedRatePojo(), new List[0]);
        topicPolicy.createChild("prefetch-rate-pending-message-limit-strategy", map);
        JEEMXUtils.applyPropertyBag(topicPolicy, topicPolicyPojo);
    }

    @Override
    public void deletePolciy(String name, String type) throws Exception {
        TopicPolicy topicPolicy;
        Policies policies = this.jeemxHelper.getPolicies();
        if ("queue".equals(type)) {
            QueuePolicy queuePolicy = policies.getQueuePolicy().get(name);
            if (queuePolicy != null) {
                policies.removeChild("queue-policy", name);
            }
        } else if ("topic".equals(type) && (topicPolicy = policies.getTopicPolicy().get(name)) != null) {
            policies.removeChild("topic-policy", name);
        }
    }

    @Override
    public boolean isPolicyAlreadyExist(String name, String type) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        return "queue".equals(type) ? policies.getQueuePolicy().get(name) != null : "topic".equals(type) && policies.getTopicPolicy().get(name) != null;
    }

    @Override
    public PolicyPojo getPolicyPojo(String name, String type) throws Exception {
        PolicyPojo pojo = null;
        if ("queue".equals(type)) {
            pojo = this.getQueuePolicy(name);
        } else if ("topic".equals(type)) {
            pojo = this.getTopicPolicy(name);
        }
        return pojo;
    }

    @Override
    public boolean isDefaultPolicy(String name, String type) throws Exception {
        if ("queue".equals(type)) {
            return "defaultQueuePolicy".equalsIgnoreCase(name);
        }
        if ("topic".equals(type)) {
            return "defaultTopicPolicy".equalsIgnoreCase(name);
        }
        return false;
    }

    @Override
    public String isReferenced(String name, String type) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        if ("queue".equals(type)) {
            QueuePolicy queuePolicy = policies.getQueuePolicy().get(name);
            String queueName = queuePolicy.getQueueNameByPolicy();
            if (queuePolicy != null && queueName != null) {
                return queueName;
            }
        } else if ("topic".equals(type)) {
            TopicPolicy topicPolicy = policies.getTopicPolicy().get(name);
            String topicName = topicPolicy.getTopicNameByPolicy();
            if (topicPolicy != null && topicName != null) {
                return topicName;
            }
        }
        return "";
    }

    @Override
    public void updateQueuePolicy(QueuePolicyPojo pojo) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        QueuePolicy queuePolicy = policies.getQueuePolicy().get(pojo.getName());
        if (queuePolicy != null) {
            queuePolicy.setNotifyForFastProducers(String.valueOf(pojo.getNotifyForFastProducers()));
            queuePolicy.setNotifyForSlowConsumers(String.valueOf(pojo.getNotifyForSlowConsumers()));
            queuePolicy.setNotifyWhenFull(String.valueOf(pojo.getNotifyWhenFull()));
            queuePolicy.setCursor(pojo.getCursor());
            queuePolicy.setCursorMemoryHighWaterMark(String.valueOf(pojo.getCursorMemoryHighWaterMark()));
            queuePolicy.setDispatchPolicy(pojo.getDispatchPolicy());
            queuePolicy.setDlqStrategy(pojo.getDlqStrategy());
            queuePolicy.setEnableAudit(String.valueOf(pojo.getEnableAudit()));
            queuePolicy.setEnableSlowConsumerStrategy(String.valueOf(pojo.getEnableSlowConsumerStrategy()));
            queuePolicy.setExpireMessagesPeriod(String.valueOf(pojo.getExpireMessagesPeriod()));
            queuePolicy.setMemoryLimit(String.valueOf(pojo.getMemoryLimit()));
            queuePolicy.setProducerFlowControl(String.valueOf(pojo.getProducerFlowControl()));
            queuePolicy.setQueuePrefetch(String.valueOf(pojo.getQueuePrefetch()));
            queuePolicy.setStoreUsageHighWaterMark(String.valueOf(pojo.getStoreUsageHighWaterMark()));
            queuePolicy.setUseCache(String.valueOf(pojo.getUseCache()));
            queuePolicy.setUseConsumerPriority(String.valueOf(pojo.getUseConsumerPriority()));
            SharedDeadLetterStrategy sharedDlq = queuePolicy.getSharedDeadLetterStrategy();
            SharedDLQStrategyPojo sharedDlqPojo = pojo.getSharedDlqPojo();
            sharedDlq.setDlqType(sharedDlqPojo.getDlqType());
            sharedDlq.setProcessExpired(String.valueOf(sharedDlqPojo.getProcessExpired()));
            sharedDlq.setProcessNonPersistent(String.valueOf(sharedDlqPojo.getProcessNonPersistent()));
            sharedDlq.setEnableAudit(String.valueOf(sharedDlqPojo.getEnableAudit()));
            IndividualDeadLetterStrategy individualDlq = queuePolicy.getIndividualDeadLetterStrategy();
            IndividualDLQStrategyPojo individualDlqPojo = pojo.getIndividualDlqPojo();
            individualDlq.setDlqType(individualDlqPojo.getDlqType());
            individualDlq.setProcessExpired(String.valueOf(individualDlqPojo.getProcessExpired()));
            individualDlq.setProcessNonPersistent(String.valueOf(individualDlqPojo.getProcessNonPersistent()));
            individualDlq.setEnableAudit(String.valueOf(individualDlqPojo.getEnableAudit()));
            SlowConsumerStrategy slowConsumerStrategy = queuePolicy.getSlowConsumerStrategy();
            SlowConsumerStrategyPojo slowPojo = pojo.getSlowPojo();
            slowConsumerStrategy.setAbortConnection(String.valueOf(slowPojo.getAbortConnection()));
            slowConsumerStrategy.setCheckPeriod(String.valueOf(slowPojo.getCheckPeriod()));
            slowConsumerStrategy.setMaxSlowCount(String.valueOf(slowPojo.getMaxSlowCount()));
            slowConsumerStrategy.setMaxSlowDuration(String.valueOf(slowPojo.getMaxSlowDuration()));
            JEEMXUtils.updatePropertyBag(queuePolicy, pojo);
        }
    }

    @Override
    public void updateTopicPolicy(TopicPolicyPojo pojo) throws Exception {
        Policies policies = this.jeemxHelper.getPolicies();
        TopicPolicy topicPolicy = policies.getTopicPolicy().get(pojo.getName());
        if (topicPolicy != null) {
            topicPolicy.setNotifyForDiscardingMessages(String.valueOf(pojo.getNotifyForDiscardingMessages()));
            topicPolicy.setNotifyForFastProducers(String.valueOf(pojo.getNotifyForFastProducers()));
            topicPolicy.setNotifyForSlowConsumers(String.valueOf(pojo.getNotifyForSlowConsumers()));
            topicPolicy.setNotifyWhenFull(String.valueOf(pojo.getNotifyWhenFull()));
            topicPolicy.setCursor(pojo.getCursor());
            topicPolicy.setDurableCursor(pojo.getDurableCursor());
            topicPolicy.setCursorMemoryHighWaterMark(String.valueOf(pojo.getCursorMemoryHighWaterMark()));
            topicPolicy.setDispatchPolicy(pojo.getDispatchPolicy());
            topicPolicy.setDlqStrategy(pojo.getDlqStrategy());
            topicPolicy.setEnableAudit(String.valueOf(pojo.getEnableAudit()));
            topicPolicy.setEnableSlowConsumerStrategy(String.valueOf(pojo.getEnableSlowConsumerStrategy()));
            topicPolicy.setExpireMessagesPeriod(String.valueOf(pojo.getExpireMessagesPeriod()));
            topicPolicy.setMemoryLimit(String.valueOf(pojo.getMemoryLimit()));
            topicPolicy.setProducerFlowControl(String.valueOf(pojo.getProducerFlowControl()));
            topicPolicy.setTopicPrefetch(String.valueOf(pojo.getTopicPrefetch()));
            topicPolicy.setDurableTopicPrefetch(String.valueOf(pojo.getDurableTopicPrefetch()));
            topicPolicy.setStoreUsageHighWaterMark(String.valueOf(pojo.getStoreUsageHighWaterMark()));
            topicPolicy.setMessageEvictionStrategy(pojo.getMessageEvictionStrategy());
            topicPolicy.setPendingMessageLimitStrategy(pojo.getPendingMessageLimitStrategy());
            SharedDeadLetterStrategy sharedDlq = topicPolicy.getSharedDeadLetterStrategy();
            SharedDLQStrategyPojo sharedDlqPojo = pojo.getSharedDlqPojo();
            sharedDlq.setDlqType(sharedDlqPojo.getDlqType());
            sharedDlq.setProcessExpired(String.valueOf(sharedDlqPojo.getProcessExpired()));
            sharedDlq.setProcessNonPersistent(String.valueOf(sharedDlqPojo.getProcessNonPersistent()));
            sharedDlq.setEnableAudit(String.valueOf(sharedDlqPojo.getEnableAudit()));
            IndividualDeadLetterStrategy individualDlq = topicPolicy.getIndividualDeadLetterStrategy();
            IndividualDLQStrategyPojo individualDlqPojo = pojo.getIndividualDlqPojo();
            individualDlq.setDlqType(individualDlqPojo.getDlqType());
            individualDlq.setProcessExpired(String.valueOf(individualDlqPojo.getProcessExpired()));
            individualDlq.setProcessNonPersistent(String.valueOf(individualDlqPojo.getProcessNonPersistent()));
            individualDlq.setEnableAudit(String.valueOf(individualDlqPojo.getEnableAudit()));
            individualDlq.setDurableSubscriberShareDlq(String.valueOf(individualDlqPojo.getDurableSubscriberShareDlq()));
            SlowConsumerStrategy slowConsumerStrategy = topicPolicy.getSlowConsumerStrategy();
            SlowConsumerStrategyPojo slowPojo = pojo.getSlowPojo();
            slowConsumerStrategy.setAbortConnection(String.valueOf(slowPojo.getAbortConnection()));
            slowConsumerStrategy.setCheckPeriod(String.valueOf(slowPojo.getCheckPeriod()));
            slowConsumerStrategy.setMaxSlowCount(String.valueOf(slowPojo.getMaxSlowCount()));
            slowConsumerStrategy.setMaxSlowDuration(String.valueOf(slowPojo.getMaxSlowDuration()));
            OldestMessageWithLowestPriorityEvictionStrategy basedTime = topicPolicy.getOldestMessageWithLowestPriorityEvictionStrategy();
            OldestMessageWithLowestPriorityEvictionStrategyPojo basedTimePojo = pojo.getBasedTimePojo();
            basedTime.setEvictExpiredMessagesHighWaterMark(String.valueOf(basedTimePojo.getEvictExpiredMessagesHighWaterMark()));
            UniquePropertyMessageEvictionStrategy basedAttribute = topicPolicy.getUniquePropertyMessageEvictionStrategy();
            UniquePropertyMessageEvictionStrategyPojo basedAttributePojo = pojo.getBasedAttributePojo();
            basedAttribute.setEvictExpiredMessagesHighWaterMark(String.valueOf(basedAttributePojo.getEvictExpiredMessagesHighWaterMark()));
            basedAttribute.setPropertyName(basedAttributePojo.getPropertyName());
            ConstantPendingMessageLimitStrategy basedConstant = topicPolicy.getConstantPendingMessageLimitStrategy();
            ConstantPendingMessageLimitStrategyPojo basedConstantPojo = pojo.getBasedConstantPojo();
            basedConstant.setLimit(String.valueOf(basedConstantPojo.getLimit()));
            PrefetchRatePendingMessageLimitStrategy basedRate = topicPolicy.getPrefetchRatePendingMessageLimitStrategy();
            PrefetchRatePendingMessageLimitStrategyPojo basedRatePojo = pojo.getBasedRatePojo();
            basedRate.setMultiplier(String.valueOf(basedRatePojo.getMultiplier()));
            JEEMXUtils.updatePropertyBag(topicPolicy, pojo);
        }
    }

    @Override
    public void setDlqStrategy(String newValue, String policyName, String type) throws Exception {
        TopicPolicy topicPolicy;
        Policies policies = this.jeemxHelper.getPolicies();
        if ("queue".equals(type)) {
            QueuePolicy queuePolicy = policies.getQueuePolicy().get(policyName);
            if (queuePolicy != null) {
                queuePolicy.setDlqStrategy(newValue);
            }
        } else if ("topic".equals(type) && (topicPolicy = policies.getTopicPolicy().get(policyName)) != null) {
            topicPolicy.setDlqStrategy(newValue);
        }
    }

    @Override
    public String getDlqStrategy(String policyName, String type) throws Exception {
        TopicPolicy topicPolicy;
        Policies policies = this.jeemxHelper.getPolicies();
        if ("queue".equals(type)) {
            QueuePolicy queuePolicy = policies.getQueuePolicy().get(policyName);
            if (queuePolicy != null) {
                return queuePolicy.getDlqStrategy();
            }
        } else if ("topic".equals(type) && (topicPolicy = policies.getTopicPolicy().get(policyName)) != null) {
            return topicPolicy.getDlqStrategy();
        }
        return null;
    }

    @Override
    public void setEnableSlowConsumerStrategy(boolean value, String policyName, String type) throws Exception {
        TopicPolicy topicPolicy;
        Policies policies = this.jeemxHelper.getPolicies();
        if ("queue".equals(type)) {
            QueuePolicy queuePolicy = policies.getQueuePolicy().get(policyName);
            if (queuePolicy != null) {
                queuePolicy.setEnableSlowConsumerStrategy(String.valueOf(value));
            }
        } else if ("topic".equals(type) && (topicPolicy = policies.getTopicPolicy().get(policyName)) != null) {
            topicPolicy.setEnableSlowConsumerStrategy(String.valueOf(value));
        }
    }

    @Override
    public void updatePolicy(PolicyPojo pojo) throws Exception {
        if (Type.isQueue(pojo.getType())) {
            this.updateQueuePolicy((QueuePolicyPojo)pojo);
        } else {
            this.updateTopicPolicy((TopicPolicyPojo)pojo);
        }
    }

    @Override
    public int getSystemMemoryLimit() throws Exception {
        MemoryUsage memoryUsage = this.jeemxHelper.getSystemUsage().getMemoryUsage();
        return Integer.valueOf(memoryUsage.getLimit());
    }
}

