/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.security;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.destinations.pojo.Type;
import com.bes.mq.admin.facade.api.security.SecuritySeviceFacade;
import com.bes.mq.admin.facade.api.security.pojo.AuthEntryPojo;
import com.bes.mq.admin.facade.api.security.pojo.AuthQueuePojo;
import com.bes.mq.admin.facade.api.security.pojo.AuthTopicPojo;
import com.bes.mq.admin.facade.api.security.pojo.AuthenticationPojo;
import com.bes.mq.admin.facade.api.security.pojo.SslPojo;
import com.bes.mq.admin.facade.api.security.pojo.UserGroupPojo;
import com.bes.mq.admin.facade.api.security.pojo.UserPojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.Authentication;
import com.bes.mq.jeemx.config.intf.Authorization;
import com.bes.mq.jeemx.config.intf.Authorizations;
import com.bes.mq.jeemx.config.intf.QueueAuthorization;
import com.bes.mq.jeemx.config.intf.SecurityService;
import com.bes.mq.jeemx.config.intf.Ssl;
import com.bes.mq.jeemx.config.intf.TopicAuthorization;
import com.bes.mq.jeemx.config.intf.ext.Realms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecuritySeviceFacadeImpl
extends BaseFacade
implements SecuritySeviceFacade {
    private static final String REALM = "fileRealm";
    private static final String SEPARATOR = ",";
    private static final String MQ_ADMIN = "mqadmin";

    public SecuritySeviceFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public List<AuthEntryPojo> listAllAuthEntry() throws Exception {
        ArrayList<AuthEntryPojo> pojos = new ArrayList<AuthEntryPojo>();
        Map<String, Authorization> map = this.jeemxHelper.getAuthorizations().getAuthorization();
        for (String key : map.keySet()) {
            AuthEntryPojo pojo = this.createAuthEntryPojo(map.get(key));
            pojos.add(pojo);
        }
        return pojos;
    }

    @Override
    public AuthEntryPojo getAuthEntry(String name) throws Exception {
        AuthEntryPojo pojo = null;
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        Authorization authorization = authorizations.getAuthorization().get(name);
        if (authorization != null) {
            pojo = this.createAuthEntryPojo(authorization);
        }
        return pojo;
    }

    @Override
    public void createAuthEntry(AuthEntryPojo authEntryPojo) throws Exception {
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        Map<String, Object> map = Utils.pojo2map(authEntryPojo, new List[0]);
        Authorization authorization = authorizations.createChild("authorization", map).as(Authorization.class);
        for (AuthQueuePojo authQueuePojo : authEntryPojo.getQueuePojos()) {
            map = Utils.pojo2map(authQueuePojo, new List[0]);
            authorization.createChild("queue-authorization", map);
        }
        for (AuthTopicPojo authTopicPojo : authEntryPojo.getTopicPojos()) {
            map = Utils.pojo2map(authTopicPojo, new List[0]);
            authorization.createChild("topic-authorization", map);
        }
    }

    @Override
    public void deleteAuthEntry(String name) throws Exception {
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        authorizations.removeChild("authorization", name);
    }

    @Override
    public void updateAuthEntry(AuthEntryPojo pojo) throws Exception {
        Map<String, Object> map = null;
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        Authorization authorization = authorizations.getAuthorization().get(pojo.getGroup());
        authorization.setAdmin(String.valueOf(pojo.getAdmin()));
        authorization.setRead(String.valueOf(pojo.getRead()));
        authorization.setWrite(String.valueOf(pojo.getWrite()));
        Map<String, QueueAuthorization> authQueueMap = authorization.getQueueAuthorization();
        for (AuthQueuePojo authQueuePojo : pojo.getQueuePojos()) {
            if (authQueueMap.get(authQueuePojo.getName()) == null) {
                map = Utils.pojo2map(authQueuePojo, new List[0]);
                authorization.createChild("queue-authorization", map);
                continue;
            }
            authQueueMap.remove(authQueuePojo.getName());
        }
        if (!authQueueMap.isEmpty()) {
            Iterator<String> it = authQueueMap.keySet().iterator();
            while (it.hasNext()) {
                authorization.removeChild("queue-authorization", it.next());
            }
        }
        Map<String, TopicAuthorization> authTopicMap = authorization.getTopicAuthorization();
        for (AuthTopicPojo authTopicPojo : pojo.getTopicPojos()) {
            if (authTopicMap.get(authTopicPojo.getName()) == null) {
                map = Utils.pojo2map(authTopicPojo, new List[0]);
                authorization.createChild("topic-authorization", map);
                continue;
            }
            authTopicMap.remove(authTopicPojo.getName());
        }
        if (!authTopicMap.isEmpty()) {
            Iterator<String> it = authTopicMap.keySet().iterator();
            while (it.hasNext()) {
                authorization.removeChild("topic-authorization", it.next());
            }
        }
    }

    @Override
    public boolean isAuthDestinationAlreadyExist(String group, String type, String name) throws Exception {
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        Authorization authorization = authorizations.getAuthorization().get(group);
        if (authorization != null) {
            if (Type.isQueue(type) && authorization.getQueueAuthorization().get(name) != null) {
                return true;
            }
            if (Type.isTopic(type) && authorization.getTopicAuthorization().get(name) != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isGroupNotExist(String group) throws Exception {
        return !this.jeemxHelper.getExtension().getRealms().isGroupExist(REALM, group);
    }

    private AuthEntryPojo createAuthEntryPojo(Authorization authorization) {
        AuthEntryPojo pojo = new AuthEntryPojo();
        pojo.setGroup(authorization.getGroup());
        pojo.setAdmin(Utils.toBoolean(authorization.getAdmin()));
        pojo.setRead(Utils.toBoolean(authorization.getRead()));
        pojo.setWrite(Utils.toBoolean(authorization.getWrite()));
        Iterator<String> it = authorization.getQueueAuthorization().keySet().iterator();
        while (it.hasNext()) {
            QueueAuthorization authQueue = authorization.getQueueAuthorization().get(it.next());
            AuthQueuePojo queuePojo = new AuthQueuePojo(authQueue.getName());
            pojo.addAuthQueuePojo(queuePojo);
        }
        Iterator<String> itTopic = authorization.getTopicAuthorization().keySet().iterator();
        while (itTopic.hasNext()) {
            TopicAuthorization authTopic = authorization.getTopicAuthorization().get(itTopic.next());
            AuthTopicPojo topicPojo = new AuthTopicPojo(authTopic.getName());
            pojo.addAuthTopicPojo(topicPojo);
        }
        return pojo;
    }

    @Override
    public boolean isAuthDestinationNotExist(String group, String type, String name) throws Exception {
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        Authorization authorization = authorizations.getAuthorization().get(group);
        if (authorization != null) {
            if (Type.isQueue(type) && authorization.getQueueAuthorization().get(name) == null) {
                return true;
            }
            if (Type.isTopic(type) && authorization.getTopicAuthorization().get(name) == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addAuthDestination(String group, String type, String targetName) throws Exception {
        Map<String, Object> map = null;
        Authorization authorization = this.jeemxHelper.getAuthorizations().getAuthorization().get(group);
        if (Type.isQueue(type)) {
            AuthQueuePojo pojo = new AuthQueuePojo(targetName);
            map = Utils.pojo2map(pojo, new List[0]);
            authorization.createChild("queue-authorization", map);
        } else {
            AuthTopicPojo pojo = new AuthTopicPojo(targetName);
            map = Utils.pojo2map(pojo, new List[0]);
            authorization.createChild("topic-authorization", map);
        }
    }

    @Override
    public void deleteAuthDestination(String group, String type, String targetName) throws Exception {
        Authorization authorization = this.jeemxHelper.getAuthorizations().getAuthorization().get(group);
        if (Type.isQueue(type)) {
            authorization.removeChild("queue-authorization", targetName);
        } else {
            authorization.removeChild("topic-authorization", targetName);
        }
    }

    @Override
    public String getAuthDestination(AuthEntryPojo pojo) throws Exception {
        String authDestination = null;
        for (AuthQueuePojo queuePojo : pojo.getQueuePojos()) {
            if (authDestination == null) {
                authDestination = "queue=" + queuePojo.getName();
                continue;
            }
            authDestination = authDestination + ",queue=" + queuePojo.getName();
        }
        for (AuthTopicPojo topicPojo : pojo.getTopicPojos()) {
            if (authDestination == null) {
                authDestination = "topic=" + topicPojo.getName();
                continue;
            }
            authDestination = authDestination + ",topic=" + topicPojo.getName();
        }
        return authDestination;
    }

    @Override
    public boolean isAuthGroupNotExist(String group) throws Exception {
        Authorization authorization = this.jeemxHelper.getAuthorizations().getAuthorization().get(group);
        return authorization == null;
    }

    @Override
    public void createUser(UserPojo pojo) throws Exception {
        String groupList = pojo.getGroupList();
        String[] groups = null;
        if (groupList != null) {
            groups = pojo.getGroupList().split(SEPARATOR);
        }
        this.jeemxHelper.getExtension().getRealms().addUser(REALM, pojo.getName(), pojo.getPassword().toCharArray(), groups);
    }

    @Override
    public void createGroup(UserGroupPojo pojo) throws Exception {
        this.jeemxHelper.getExtension().getRealms().addGroup(REALM, pojo.getName());
    }

    @Override
    public void deleteUser(String username) throws Exception {
        this.jeemxHelper.getExtension().getRealms().removeUser(REALM, username);
    }

    @Override
    public void deleteGroup(String groupName) throws Exception {
        this.jeemxHelper.getExtension().getRealms().removeGroup(REALM, groupName);
    }

    @Override
    public UserPojo getUser(String username) throws Exception {
        UserPojo pojo = new UserPojo();
        pojo.setName(username);
        pojo.setGroupList(this.getGroupList(username));
        return pojo;
    }

    private String getGroupList(String username) throws Exception {
        String[] groups;
        String groupList = null;
        for (String group : groups = this.jeemxHelper.getExtension().getRealms().getGroupNames(REALM, username)) {
            groupList = groupList == null ? group : groupList + SEPARATOR + group;
        }
        return groupList;
    }

    @Override
    public boolean isGroupAlreadyExist(String name) throws Exception {
        return this.jeemxHelper.getExtension().getRealms().isGroupExist(REALM, name);
    }

    @Override
    public boolean isUserAlreadyExist(String username) throws Exception {
        return this.jeemxHelper.getExtension().getRealms().isUserExist(REALM, username);
    }

    @Override
    public boolean isUserNotExist(String username) throws Exception {
        return !this.jeemxHelper.getExtension().getRealms().isUserExist(REALM, username);
    }

    @Override
    public List<UserGroupPojo> listAllUserGroups() throws Exception {
        String[] groupNames = this.jeemxHelper.getExtension().getRealms().getGroupNames(REALM);
        ArrayList<UserGroupPojo> groupPojos = new ArrayList<UserGroupPojo>();
        for (String groupName : groupNames) {
            UserGroupPojo pojo = new UserGroupPojo();
            pojo.setUserList(this.getUserList(groupName));
            pojo.setName(groupName);
            groupPojos.add(pojo);
        }
        return groupPojos;
    }

    @Override
    public List<UserPojo> listAllUsers() throws Exception {
        Realms realms = this.jeemxHelper.getExtension().getRealms();
        String[] usernames = realms.getUserNames(REALM);
        ArrayList<UserPojo> userPojos = new ArrayList<UserPojo>();
        for (String username : usernames) {
            UserPojo pojo = new UserPojo();
            pojo.setName(username);
            pojo.setGroupList(this.getGroupList(username));
            userPojos.add(pojo);
        }
        Collections.sort(userPojos);
        return userPojos;
    }

    @Override
    public void authenticationEnable(AuthenticationPojo pojo) throws Exception {
        Authentication authentication = this.jeemxHelper.getAuthentication();
        authentication.setEnable(String.valueOf(pojo.getEnable()));
        authentication.setRealm(pojo.getRealm());
    }

    @Override
    public void addGroupToUser(String groupName, String user) throws Exception {
        this.jeemxHelper.getExtension().getRealms().addGroup(REALM, user, groupName);
    }

    @Override
    public void changeUserPassword(UserPojo pojo) throws Exception {
        String groupList = pojo.getGroupList();
        String[] groups = null;
        if (groupList != null) {
            groups = pojo.getGroupList().split(SEPARATOR);
        }
        this.jeemxHelper.getExtension().getRealms().updateUser(REALM, pojo.getName(), pojo.getPassword().toCharArray(), groups);
    }

    @Override
    public void removeGroupFromUser(String groupName, String user) throws Exception {
        this.jeemxHelper.getExtension().getRealms().removeGroup(REALM, user, groupName);
    }

    @Override
    public boolean isGroupReferenced(String groupName) throws Exception {
        String[] userNames = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM, groupName);
        Authorizations authorizations = this.jeemxHelper.getAuthorizations();
        Authorization authorization = authorizations.getAuthorization().get(groupName);
        return userNames.length > 0 || authorization != null;
    }

    @Override
    public boolean isGroupAdmin(String groupName) throws Exception {
        return MQ_ADMIN.equals(groupName);
    }

    @Override
    public void updateSsl(SslPojo sslPojo) throws Exception {
        SecurityService securityService = this.jeemxHelper.getSecurityService();
        Ssl ssl = securityService.getSsl();
        if (ssl == null) {
            Map<String, Object> map = Utils.pojo2map(sslPojo, new List[0]);
            securityService.createChild("ssl", map);
        } else {
            ssl.setKeyStore(sslPojo.getKeyStore());
            ssl.setKeyStoreAlgorithm(sslPojo.getKeyStoreAlgorithm());
            ssl.setKeyStoreKeyPassword(sslPojo.getKeyStoreKeyPassword());
            ssl.setKeyStorePassword(sslPojo.getKeyStorePassword());
            ssl.setKeyStoreType(sslPojo.getKeyStoreType());
            ssl.setProtocol(sslPojo.getProtocol());
            ssl.setTrustStore(sslPojo.getTrustStore());
            ssl.setTrustStoreAlgorithm(sslPojo.getTrustStoreAlgorithm());
            ssl.setTrustStorePassword(sslPojo.getTrustStorePassword());
            ssl.setTrustStoreType(sslPojo.getTrustStoreType());
        }
    }

    @Override
    public SslPojo getSslPojo() throws Exception {
        Ssl ssl = this.jeemxHelper.getSecurityService().getSsl();
        SslPojo sslPojo = null;
        if (ssl != null) {
            sslPojo = new SslPojo();
            sslPojo.setKeyStore(ssl.getKeyStore());
            sslPojo.setKeyStoreAlgorithm(ssl.getKeyStoreAlgorithm());
            sslPojo.setKeyStoreKeyPassword(ssl.getKeyStoreKeyPassword());
            sslPojo.setKeyStorePassword(ssl.getKeyStorePassword());
            sslPojo.setKeyStoreType(ssl.getKeyStoreType());
            sslPojo.setProtocol(ssl.getProtocol());
            sslPojo.setTrustStore(ssl.getTrustStore());
            sslPojo.setTrustStoreAlgorithm(ssl.getTrustStoreAlgorithm());
            sslPojo.setTrustStorePassword(ssl.getTrustStorePassword());
            sslPojo.setTrustStoreType(ssl.getTrustStoreType());
        }
        return sslPojo;
    }

    @Override
    public UserGroupPojo getGroupPojo(String groupName) throws Exception {
        UserGroupPojo pojo = new UserGroupPojo();
        pojo.setName(groupName);
        pojo.setUserList(this.getUserList(groupName));
        return pojo;
    }

    private String getUserList(String groupName) throws Exception {
        String[] userNames;
        String userList = null;
        for (String userName : userNames = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM, groupName)) {
            userList = userList == null ? userName : userList + SEPARATOR + userName;
        }
        return userList;
    }

    @Override
    public List<String> getSelectedUsers(String group) throws Exception {
        String[] userNames = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM, group);
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String userName : userNames) {
            selectedUsers.add(userName);
        }
        Collections.sort(selectedUsers);
        return selectedUsers;
    }

    @Override
    public List<String> getUnselectedUsers(String group) throws Exception {
        String[] userNamesAll = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM);
        String[] userNames = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM, group);
        List<String> userNamesList = Arrays.asList(userNames);
        ArrayList<String> unselectedUsers = new ArrayList<String>();
        for (String userNameAll : userNamesAll) {
            if (userNamesList.contains(userNameAll)) continue;
            unselectedUsers.add(userNameAll);
        }
        Collections.sort(unselectedUsers);
        return unselectedUsers;
    }

    @Override
    public List<String> getUnselectedUsers() throws Exception {
        String[] userNamesAll = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM);
        ArrayList<String> unselectedUsers = new ArrayList<String>();
        for (String userNameAll : userNamesAll) {
            unselectedUsers.add(userNameAll);
        }
        Collections.sort(unselectedUsers);
        return unselectedUsers;
    }

    @Override
    public boolean isRealmNotExist(String realm) throws Exception {
        String[] realms;
        for (String tempRealm : realms = this.jeemxHelper.getExtension().getRealms().getRealmNames()) {
            if (!tempRealm.equals(realm)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AuthenticationPojo getAuthenticationPojo() throws Exception {
        Authentication authentication = this.jeemxHelper.getAuthentication();
        AuthenticationPojo pojo = new AuthenticationPojo();
        pojo.setEnable(Boolean.valueOf(authentication.getEnable()));
        pojo.setRealm(authentication.getRealm());
        return pojo;
    }

    @Override
    public List<String> getRealms() throws Exception {
        String[] realms = this.jeemxHelper.getExtension().getRealms().getRealmNames();
        return Arrays.asList(realms);
    }

    @Override
    public List<String> getGroupNames() throws Exception {
        String[] groupNames = this.jeemxHelper.getExtension().getRealms().getGroupNames(REALM);
        ArrayList<String> groupNameList = new ArrayList<String>();
        String mqadmin = null;
        for (String groupName : groupNames) {
            if (groupName.equals(MQ_ADMIN)) {
                mqadmin = groupName;
                continue;
            }
            groupNameList.add(groupName);
        }
        Collections.sort(groupNameList);
        if (mqadmin != null) {
            groupNameList.add(0, mqadmin);
        }
        return groupNameList;
    }

    @Override
    public boolean isGroupUserExist(String groupName, String username) throws Exception {
        String[] groupNames;
        for (String tempGroupName : groupNames = this.jeemxHelper.getExtension().getRealms().getGroupNames(REALM, username)) {
            if (!groupName.equals(tempGroupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGroupUserNotExist(String groupName, String username) throws Exception {
        String[] groupNames;
        for (String tempGroupName : groupNames = this.jeemxHelper.getExtension().getRealms().getGroupNames(REALM, username)) {
            if (!groupName.equals(tempGroupName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMqadminUserCount() throws Exception {
        String[] userNames = this.jeemxHelper.getExtension().getRealms().getUserNames(REALM, MQ_ADMIN);
        return userNames.length;
    }

    @Override
    public boolean isMqadminUser(String username) throws Exception {
        String[] groupNames;
        for (String groupName : groupNames = this.jeemxHelper.getExtension().getRealms().getGroupNames(REALM, username)) {
            if (!MQ_ADMIN.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPasswordContainSpace(String password) throws Exception {
        char[] passwordChars;
        for (char c : passwordChars = password.toCharArray()) {
            if (!Character.isSpaceChar(c)) continue;
            return true;
        }
        return false;
    }
}

