/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.store;

import com.bes.admin.jeemx.config.JEEMXConfigProxy;
import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.store.StoreFacade;
import com.bes.mq.admin.facade.api.store.pojo.BrokerType;
import com.bes.mq.admin.facade.api.store.pojo.FSType;
import com.bes.mq.admin.facade.api.store.pojo.FileStorePojo;
import com.bes.mq.admin.facade.api.store.pojo.HighAvailabilityPojo;
import com.bes.mq.admin.facade.api.store.pojo.JdbcStorePojo;
import com.bes.mq.admin.facade.api.store.pojo.MemoryStorePojo;
import com.bes.mq.admin.facade.api.store.pojo.StorePojo;
import com.bes.mq.admin.facade.api.store.pojo.StoreType;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.FileStore;
import com.bes.mq.jeemx.config.intf.HighAvailability;
import com.bes.mq.jeemx.config.intf.HighAvailabilityStore;
import com.bes.mq.jeemx.config.intf.JdbcStore;
import com.bes.mq.jeemx.config.intf.MemoryStore;
import com.bes.mq.jeemx.config.intf.MessageStores;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoreFacadeImpl
extends BaseFacade
implements StoreFacade {
    public StoreFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void createFileStore(FileStorePojo storePojo) throws Exception {
        Map<String, Object> fileStoreMap = Utils.pojo2map(storePojo, new List[0]);
        MessageStores stores = this.jeemxHelper.getMessageStores();
        JEEMXConfigProxy fileStore = stores.createChild("file-store", fileStoreMap);
        JEEMXUtils.applyPropertyBag(fileStore, storePojo);
        HighAvailabilityPojo haPojo = storePojo.getHighAvailabilityPojo();
        this.configureFileStoreHa(fileStore, haPojo);
    }

    private void configureFileStoreHa(JEEMXConfigProxy proxy, HighAvailabilityPojo pojo) throws Exception {
        if (pojo == null) {
            return;
        }
        FileStore store = proxy.as(FileStore.class);
        HighAvailability ha = store.getHighAvailability();
        if (ha == null) {
            Map<String, Object> haMap = Utils.pojo2map(pojo, new List[0]);
            if (FSType.isShared(pojo.getFsType())) {
                haMap.clear();
                haMap.put("fs-type", pojo.getFsType());
                haMap.put("enable", pojo.getEnable());
            } else if (BrokerType.isMaster(pojo.getBrokerType())) {
                haMap.remove("master-uri");
                haMap.remove("username");
                haMap.remove("password");
                haMap.remove("shutdown-on-master-failure");
            } else {
                haMap.remove("shutdown-on-slave-failure");
                haMap.remove("wait-for-slave-timeout");
            }
            store.createChild("high-availability", haMap);
        } else {
            this.updateHa(StoreType.FILE, ha, pojo);
        }
    }

    private void updateHa(StoreType storeType, HighAvailability ha, HighAvailabilityPojo pojo) {
        ha.setEnable(String.valueOf(pojo.getEnable()));
        if (storeType == StoreType.FILE) {
            ha.setFsType(pojo.getFsType());
            if (FSType.isShared(pojo.getFsType())) {
                ha.setBrokerType(null);
                ha.setShutdownOnSlaveFailure(null);
                ha.setWaitForSlaveTimeout(null);
                ha.setMasterUri(null);
                ha.setUsername(null);
                ha.setPassword(null);
                ha.setShutdownOnMasterFailure(null);
            } else {
                ha.setBrokerType(pojo.getBrokerType());
                if (BrokerType.isMaster(pojo.getBrokerType())) {
                    ha.setShutdownOnSlaveFailure(String.valueOf(pojo.getShutdownOnSlaveFailure()));
                    ha.setWaitForSlaveTimeout(String.valueOf(pojo.getWaitForSlaveTimeout()));
                    ha.setMasterUri(null);
                    ha.setUsername(null);
                    ha.setPassword(null);
                    ha.setShutdownOnMasterFailure(null);
                } else {
                    ha.setShutdownOnSlaveFailure(null);
                    ha.setWaitForSlaveTimeout(null);
                    ha.setMasterUri(pojo.getMasterUri());
                    ha.setUsername(pojo.getUsername());
                    ha.setPassword(pojo.getPassword());
                    ha.setShutdownOnMasterFailure(String.valueOf(pojo.getShutdownOnMasterFailure()));
                }
            }
        } else if (storeType == StoreType.JDBC) {
            ha.setBrokerType(null);
            ha.setFsType(null);
            ha.setShutdownOnSlaveFailure(null);
            ha.setWaitForSlaveTimeout(null);
            ha.setMasterUri(null);
            ha.setUsername(null);
            ha.setPassword(null);
            ha.setShutdownOnMasterFailure(null);
        } else {
            ha.setBrokerType(pojo.getBrokerType());
            ha.setFsType(null);
            if (BrokerType.isMaster(pojo.getBrokerType())) {
                ha.setShutdownOnSlaveFailure(String.valueOf(pojo.getShutdownOnSlaveFailure()));
                ha.setWaitForSlaveTimeout(String.valueOf(pojo.getWaitForSlaveTimeout()));
                ha.setMasterUri(null);
                ha.setUsername(null);
                ha.setPassword(null);
                ha.setShutdownOnMasterFailure(null);
            } else {
                ha.setShutdownOnSlaveFailure(null);
                ha.setWaitForSlaveTimeout(null);
                ha.setMasterUri(pojo.getMasterUri());
                ha.setUsername(pojo.getUsername());
                ha.setPassword(pojo.getPassword());
                ha.setShutdownOnMasterFailure(String.valueOf(pojo.getShutdownOnMasterFailure()));
            }
        }
    }

    @Override
    public void createJdbcStore(JdbcStorePojo storePojo) throws Exception {
        Map<String, Object> jdbcStoreMap = Utils.pojo2map(storePojo, new List[0]);
        MessageStores stores = this.jeemxHelper.getMessageStores();
        JEEMXConfigProxy proxy = stores.createChild("jdbc-store", jdbcStoreMap);
        JEEMXUtils.applyPropertyBag(proxy, storePojo);
        HighAvailabilityPojo haPojo = storePojo.getHighAvailabilityPojo();
        this.configureJdbcStoreHa(proxy, haPojo);
    }

    private void configureJdbcStoreHa(JEEMXConfigProxy proxy, HighAvailabilityPojo haPojo) throws Exception {
        if (haPojo == null) {
            return;
        }
        JdbcStore store = proxy.as(JdbcStore.class);
        HighAvailability ha = store.getHighAvailability();
        if (ha == null) {
            haPojo.resetSettingForJdbc();
            HashMap<String, Object> haMap = new HashMap<String, Object>();
            haMap.put("enable", haPojo.getEnable());
            store.createChild("high-availability", haMap);
        } else {
            this.updateHa(StoreType.JDBC, ha, haPojo);
        }
    }

    @Override
    public void createMemoryStore(MemoryStorePojo storePojo) throws Exception {
        Map<String, Object> memoryStoreMap = Utils.pojo2map(storePojo, new List[0]);
        MessageStores stores = this.jeemxHelper.getMessageStores();
        JEEMXConfigProxy memoryStore = stores.createChild("memory-store", memoryStoreMap);
        JEEMXUtils.applyPropertyBag(memoryStore, storePojo);
        HighAvailabilityPojo haPojo = storePojo.getHighAvailabilityPojo();
        this.configureMemoryStoreHa(memoryStore, haPojo);
    }

    @Override
    public void updateFileStore(FileStorePojo pojo) throws Exception {
        FileStore store = this.jeemxHelper.getMessageStores().getFileStore();
        if (store == null) {
            return;
        }
        store.setDirectory(pojo.getDirectory());
        store.setJournalMaxFileLength(String.valueOf(pojo.getJournalMaxFileLength()));
        store.setJournalMaxWriteBatchSize(String.valueOf(pojo.getJournalMaxWriteBatchSize()));
        store.setEnableJournalDiskSync(String.valueOf(pojo.isEnableJournalDiskSync()));
        store.setCheckpointInterval(String.valueOf(pojo.getCheckpointInterval()));
        store.setCleanupInterval(String.valueOf(pojo.getCleanupInterval()));
        store.setMaxAsyncJobs(String.valueOf(pojo.getMaxAsyncJobs()));
        store.setConcurrentStoreAndDispatchQueues(String.valueOf(pojo.getConcurrentStoreAndDispatchQueues()));
        store.setConcurrentStoreAndDispatchTopics(String.valueOf(pojo.getConcurrentStoreAndDispatchTopics()));
        store.setArchiveDataLogs(String.valueOf(pojo.getArchiveDataLogs()));
        store.setDirectoryArchive(pojo.getDirectoryArchive());
        store.setEnableIndexWriteAsync(String.valueOf(pojo.getEnableIndexWriteAsync()));
        store.setEnableIndexPageCaching(String.valueOf(pojo.getEnableIndexPageCaching()));
        store.setEnableIndexDiskSync(String.valueOf(pojo.isEnableIndexDiskSync()));
        store.setIndexWriteBatchSize(String.valueOf(pojo.getIndexWriteBatchSize()));
        store.setIndexCacheSize(String.valueOf(pojo.getIndexCacheSize()));
        JEEMXUtils.updatePropertyBag(store, pojo);
        this.configureFileStoreHa(store, pojo.getHighAvailabilityPojo());
    }

    @Override
    public void updateJdbcStore(JdbcStorePojo pojo) throws Exception {
        JdbcStore store = this.jeemxHelper.getMessageStores().getJdbcStore();
        if (store == null) {
            return;
        }
        store.setTransactionIsolation(pojo.getTransactionIsolation());
        store.setDriverClassName(pojo.getDriverClassName());
        store.setDbUrl(pojo.getDbUrl());
        store.setUsername(pojo.getUsername());
        store.setPassword(pojo.getPassword());
        store.setInitialSize(String.valueOf(pojo.getInitialSize()));
        store.setMaxActive(String.valueOf(pojo.getMaxActive()));
        store.setMinIdle(String.valueOf(pojo.getMinIdle()));
        store.setMaxIdle(String.valueOf(pojo.getMaxIdle()));
        store.setMaxWait(String.valueOf(pojo.getMaxWait()));
        JEEMXUtils.updatePropertyBag(store, pojo);
        this.configureJdbcStoreHa(store, pojo.getHighAvailabilityPojo());
    }

    @Override
    public void updateMemoryStore(MemoryStorePojo pojo) throws Exception {
        MemoryStore store = this.jeemxHelper.getMessageStores().getMemoryStore();
        if (store == null) {
            return;
        }
        JEEMXUtils.updatePropertyBag(store, pojo);
        this.configureMemoryStoreHa(store, pojo.getHighAvailabilityPojo());
    }

    private void configureMemoryStoreHa(JEEMXConfigProxy proxy, HighAvailabilityPojo pojo) throws Exception {
        if (pojo == null) {
            return;
        }
        MemoryStore store = proxy.as(MemoryStore.class);
        HighAvailability ha = store.getHighAvailability();
        if (ha == null) {
            Map<String, Object> haMap = Utils.pojo2map(pojo, new List[0]);
            haMap.remove("fs-type");
            if (BrokerType.isMaster(pojo.getBrokerType())) {
                haMap.remove("master-uri");
                haMap.remove("username");
                haMap.remove("password");
                haMap.remove("shutdown-on-master-failure");
            } else {
                haMap.remove("shutdown-on-slave-failure");
                haMap.remove("wait-for-slave-timeout");
            }
            store.createChild("high-availability", haMap);
        } else {
            this.updateHa(StoreType.MEMORY, ha, pojo);
        }
    }

    @Override
    public FileStorePojo getFileStore() throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        FileStorePojo pojo = null;
        FileStore store = stores.getFileStore();
        if (store != null) {
            pojo = new FileStorePojo();
            pojo.setDirectory(store.getDirectory());
            pojo.setJournalMaxFileLength(Utils.toInt(store.getJournalMaxFileLength()));
            pojo.setJournalMaxWriteBatchSize(Utils.toInt(store.getJournalMaxWriteBatchSize()));
            pojo.setEnableJournalDiskSync(Utils.toBoolean(store.getEnableJournalDiskSync()));
            pojo.setCheckpointInterval(Utils.toInt(store.getCheckpointInterval()));
            pojo.setCleanupInterval(Utils.toInt(store.getCleanupInterval()));
            pojo.setMaxAsyncJobs(Utils.toInt(store.getMaxAsyncJobs()));
            pojo.setConcurrentStoreAndDispatchQueues(Utils.toBoolean(store.getConcurrentStoreAndDispatchQueues()));
            pojo.setConcurrentStoreAndDispatchTopics(Utils.toBoolean(store.getConcurrentStoreAndDispatchTopics()));
            pojo.setArchiveDataLogs(Utils.toBoolean(store.getArchiveDataLogs()));
            pojo.setDirectoryArchive(store.getDirectoryArchive());
            pojo.setEnableIndexWriteAsync(Utils.toBoolean(store.getEnableIndexWriteAsync()));
            pojo.setEnableIndexPageCaching(Utils.toBoolean(store.getEnableIndexPageCaching()));
            pojo.setEnableIndexDiskSync(Utils.toBoolean(store.getEnableIndexDiskSync()));
            pojo.setIndexWriteBatchSize(Utils.toInt(store.getIndexWriteBatchSize()));
            pojo.setIndexCacheSize(Utils.toInt(store.getIndexCacheSize()));
            JEEMXUtils.fillPropertyBag(pojo, store);
            HighAvailability ha = store.getHighAvailability();
            HighAvailabilityPojo haPojo = this.createHighAvailabilityPojo(ha);
            pojo.setHighAvailabilityPojo(haPojo);
        }
        return pojo;
    }

    private HighAvailabilityPojo createHighAvailabilityPojo(HighAvailability ha) {
        HighAvailabilityPojo pojo = null;
        if (ha != null) {
            pojo = new HighAvailabilityPojo();
            pojo.setBrokerType(ha.getBrokerType());
            pojo.setFsType(ha.getFsType());
            pojo.setShutdownOnSlaveFailure(Utils.toBoolean(ha.getShutdownOnSlaveFailure()));
            pojo.setWaitForSlaveTimeout(Utils.toInt(ha.getWaitForSlaveTimeout()));
            pojo.setMasterUri(ha.getMasterUri());
            pojo.setUsername(ha.getUsername());
            pojo.setPassword(ha.getPassword());
            pojo.setShutdownOnMasterFailure(Utils.toBoolean(ha.getShutdownOnMasterFailure()));
            pojo.setEnable(Utils.toBoolean(ha.getEnable()));
        }
        return pojo;
    }

    @Override
    public JdbcStorePojo getJdbcStore() throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        JdbcStorePojo pojo = null;
        JdbcStore store = stores.getJdbcStore();
        if (store != null) {
            pojo = new JdbcStorePojo();
            pojo.setTransactionIsolation(store.getTransactionIsolation());
            pojo.setDriverClassName(store.getDriverClassName());
            pojo.setDbUrl(store.getDbUrl());
            pojo.setUsername(store.getUsername());
            pojo.setPassword(store.getPassword());
            pojo.setInitialSize(Utils.toInt(store.getInitialSize()));
            pojo.setMaxActive(Utils.toInt(store.getMaxActive()));
            pojo.setMinIdle(Utils.toInt(store.getMinIdle()));
            pojo.setMaxIdle(Utils.toInt(store.getMaxIdle()));
            pojo.setMaxWait(Utils.toInt(store.getMaxWait()));
            JEEMXUtils.fillPropertyBag(pojo, store);
            HighAvailability ha = store.getHighAvailability();
            HighAvailabilityPojo haPojo = this.createHighAvailabilityPojo(ha);
            pojo.setHighAvailabilityPojo(haPojo);
        }
        return pojo;
    }

    @Override
    public MemoryStorePojo getMemoryStore() throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        MemoryStorePojo pojo = null;
        MemoryStore store = stores.getMemoryStore();
        if (store != null) {
            pojo = new MemoryStorePojo();
            JEEMXUtils.fillPropertyBag(pojo, store);
            HighAvailability ha = store.getHighAvailability();
            HighAvailabilityPojo haPojo = this.createHighAvailabilityPojo(ha);
            pojo.setHighAvailabilityPojo(haPojo);
        }
        return pojo;
    }

    @Override
    public StoreType getStoreType() throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        return StoreType.toStoreType(stores.getStoreType());
    }

    @Override
    public void enableHighAvailability(StoreType storeType, HighAvailabilityPojo haPojo) throws Exception {
        JEEMXConfigProxy proxy = this.getStoreProxy(storeType);
        if (StoreType.FILE == storeType) {
            this.configureFileStoreHa(proxy, haPojo);
        } else if (StoreType.JDBC == storeType) {
            this.configureJdbcStoreHa(proxy, haPojo);
        } else {
            this.configureMemoryStoreHa(proxy, haPojo);
        }
    }

    @Override
    public void disableHighAvailability(StoreType storeType) throws Exception {
        HighAvailability ha = this.getHighAvailabilityProxy(storeType);
        if (ha != null) {
            ha.setEnable("false");
        }
    }

    private JEEMXConfigProxy getStoreProxy(StoreType storeType) {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        HighAvailabilityStore proxy = null;
        proxy = StoreType.FILE == storeType ? stores.getFileStore() : (StoreType.JDBC == storeType ? stores.getJdbcStore() : stores.getMemoryStore());
        return proxy;
    }

    private HighAvailability getHighAvailabilityProxy(StoreType storeType) {
        JEEMXConfigProxy proxy = this.getStoreProxy(storeType);
        if (proxy == null) {
            return null;
        }
        HighAvailability ha = null;
        if (StoreType.FILE == storeType) {
            FileStore as = proxy.as(FileStore.class);
            ha = as.getHighAvailability();
        } else if (StoreType.JDBC == storeType) {
            JdbcStore as = proxy.as(JdbcStore.class);
            ha = as.getHighAvailability();
        } else {
            MemoryStore as = proxy.as(MemoryStore.class);
            ha = as.getHighAvailability();
        }
        return ha;
    }

    @Override
    public void disableStore(StoreType storeType) throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        String type = storeType.toString().toLowerCase();
        if (type.equals(stores.getStoreType())) {
            stores.setStoreType(null);
        }
    }

    @Override
    public void enableStore(StoreType storeType) throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        stores.setStoreType(storeType.toString().toLowerCase());
    }

    @Override
    public StorePojo getStoreByType(StoreType storeType) throws Exception {
        if (StoreType.FILE == storeType) {
            return this.getFileStore();
        }
        if (StoreType.JDBC == storeType) {
            return this.getJdbcStore();
        }
        return this.getMemoryStore();
    }

    @Override
    public void deleteHighAvailability(StoreType storeType) throws Exception {
        JEEMXConfigProxy proxy = this.getStoreProxy(storeType);
        if (proxy != null) {
            proxy.removeChild("high-availability");
        }
    }

    @Override
    public void deleteStore(StoreType type) throws Exception {
        MessageStores stores = this.jeemxHelper.getMessageStores();
        String storeType = stores.getStoreType();
        if (StoreType.FILE == type && stores.getFileStore() != null) {
            stores.removeChild("file-store");
            if (StoreType.isFile(storeType)) {
                stores.setStoreType(null);
            }
        } else if (StoreType.JDBC == type && stores.getJdbcStore() != null) {
            stores.removeChild("jdbc-store");
            if (StoreType.isJdbc(storeType)) {
                stores.setStoreType(null);
            }
        } else if (stores.getMemoryStore() != null) {
            if (StoreType.isMemory(storeType)) {
                stores.setStoreType(null);
            }
            stores.removeChild("memory-store");
        }
    }

    @Override
    public HighAvailabilityPojo getHighAvailabilityByType(StoreType type) throws Exception {
        HighAvailability proxy = this.getHighAvailabilityProxy(type);
        HighAvailabilityPojo pojo = null;
        if (proxy != null) {
            pojo = this.createHighAvailabilityPojo(proxy);
        }
        return pojo;
    }
}

