/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.store;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.store.TempStoreFacade;
import com.bes.mq.admin.facade.api.store.pojo.TempStorePojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.jeemx.config.intf.TempStore;

public class TempStoreFacadeImpl
extends BaseFacade
implements TempStoreFacade {
    public TempStoreFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public TempStorePojo getTempStore() throws Exception {
        TempStore store = this.jeemxHelper.getBroker().getTempStore();
        TempStorePojo pojo = null;
        if (store != null) {
            pojo = new TempStorePojo();
            pojo.setDirectory(store.getDirectory());
            pojo.setJournalMaxFileLength(Utils.toInt(store.getJournalMaxFileLength()));
            pojo.setJournalMaxWriteBatchSize(Utils.toInt(store.getJournalMaxWriteBatchSize()));
            pojo.setCleanupInterval(Utils.toInt(store.getCleanupInterval()));
            JEEMXUtils.fillPropertyBag(pojo, store);
        }
        return pojo;
    }

    @Override
    public void updateTempStore(TempStorePojo pojo) throws Exception {
        TempStore store = this.jeemxHelper.getBroker().getTempStore();
        if (store == null) {
            return;
        }
        store.setDirectory(pojo.getDirectory());
        store.setJournalMaxFileLength(String.valueOf(pojo.getJournalMaxFileLength()));
        store.setJournalMaxWriteBatchSize(String.valueOf(pojo.getJournalMaxWriteBatchSize()));
        store.setCleanupInterval(String.valueOf(pojo.getCleanupInterval()));
        JEEMXUtils.updatePropertyBag(store, pojo);
    }
}

