/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.tools;

import com.bes.mq.admin.facade.impl.jeemx.tools.JMXConnectorStatusListener;
import com.bes.mq.admin.facade.impl.jeemx.tools.MBeanServerConnectionHandler;
import com.bes.mq.admin.facade.impl.jeemx.tools.ProxyFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class JMXConnectorHandler
implements InvocationHandler,
JMXConnector {
    private JMXConnector delegate;
    private JMXServiceURL url;
    private Map<String, Object> env;
    private final Map<NotificationListener, Object[]> listeners = Collections.synchronizedMap(new HashMap());
    private boolean isCloseInvoked = false;
    private AtomicLong invokingConnections = new AtomicLong();
    private final Set<MBeanServerConnectionHandler> listenerConnections = Collections.synchronizedSet(new HashSet());

    public JMXConnectorHandler(JMXConnector conn, JMXServiceURL url, Map<String, Object> env) {
        this.delegate = conn;
        this.url = url;
        this.env = env;
    }

    public boolean isCloseAllowed() {
        return this.listenerConnections.isEmpty();
    }

    public void register(MBeanServerConnectionHandler h) {
        this.listenerConnections.add(h);
    }

    public void unregister(MBeanServerConnectionHandler h) {
        this.listenerConnections.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean closeMethod = "close".equals(method.getName());
        if (!closeMethod) {
            JMXConnectorHandler jMXConnectorHandler = this;
            synchronized (jMXConnectorHandler) {
                if (this.isCloseInvoked) {
                    throw new IOException("Connector has been closed.");
                }
                this.initialize();
            }
        }
        try {
            return method.invoke((Object)this, args);
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                if (closeMethod) {
                    throw ex;
                }
                this.recreate();
                return method.invoke((Object)this, args);
            }
            throw ex;
        }
    }

    private synchronized boolean initialize() throws IOException {
        if (this.delegate != null) {
            return false;
        }
        this.delegate = JMXConnectorFactory.connect(this.url, this.env);
        for (Map.Entry<NotificationListener, Object[]> e : this.listeners.entrySet()) {
            NotificationListener listener = e.getKey();
            NotificationFilter filter = (NotificationFilter)e.getValue()[0];
            Object handback = e.getValue()[1];
            this.delegate.addConnectionNotificationListener(listener, filter, handback);
        }
        return true;
    }

    private synchronized void invokeFinish() {
        if (this.isCloseAllowed() && this.delegate != null) {
            try {
                this.delegate.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.delegate = null;
        }
    }

    public synchronized void finish() {
        if (this.invokingConnections.get() <= 0L) {
            this.invokeFinish();
        }
    }

    public MBeanServerConnection getCurrentMBeanServerConnection() throws IOException {
        this.initialize();
        try {
            return this.delegate.getMBeanServerConnection();
        }
        catch (IOException ex) {
            this.recreate();
            return this.delegate.getMBeanServerConnection();
        }
    }

    public synchronized void recreate() throws IOException {
        this.invokeFinish();
        this.initialize();
    }

    public Map<String, ?> getEnv() {
        return this.env;
    }

    public JMXServiceURL getUrl() {
        return this.url;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void connect(Map<String, ?> env0) throws IOException {
    }

    public void preConnectionInvoke() {
        this.invokingConnections.incrementAndGet();
    }

    public void postConnectionInvoke() {
        this.invokingConnections.decrementAndGet();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return ProxyFactory.createProxy(this);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        return ProxyFactory.createProxy(this);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isCloseInvoked) {
            return;
        }
        if (this.delegate == null) {
            this.isCloseInvoked = true;
            this.listenerConnections.clear();
            this.notifyConnectorClosed();
        } else {
            this.delegate.close();
            this.isCloseInvoked = true;
            this.delegate = null;
            this.listenerConnections.clear();
            this.notifyConnectorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectorClosed() {
        Map<NotificationListener, Object[]> map = this.listeners;
        synchronized (map) {
            for (NotificationListener notifyListener : this.listeners.keySet()) {
                if (!(notifyListener instanceof JMXConnectorStatusListener)) continue;
                JMXConnectorStatusListener listener = (JMXConnectorStatusListener)((Object)notifyListener);
                listener.connectorClosed();
            }
        }
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener0, NotificationFilter filter0, Object handback) {
        Object[] tmp = new Object[]{filter0, handback};
        this.listeners.put(listener0, tmp);
        this.delegate.addConnectionNotificationListener(listener0, filter0, handback);
        if (listener0 instanceof JMXConnectorStatusListener) {
            JMXConnectorStatusListener listener = (JMXConnectorStatusListener)((Object)listener0);
            listener.connectorStarted();
        }
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.removeConnectionNotificationListener(listener, null, null);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener0, NotificationFilter filter0, Object handback) throws ListenerNotFoundException {
        this.listeners.remove(listener0);
        this.delegate.removeConnectionNotificationListener(listener0, filter0, handback);
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.delegate.getConnectionId();
    }
}

